/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.discovery.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.svn.core.discovery.model.ConnectorDescriptorKind;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.discovery.IConnectorsInstallJob;
import org.eclipse.team.svn.ui.discovery.util.DiscoveryUiUtil;
import org.eclipse.team.svn.ui.discovery.wizards.ConnectorDiscoveryWizardMainPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDiscoveryWizard
extends Wizard {
    private ConnectorDiscoveryWizardMainPage mainPage;
    protected IConnectorsInstallJob installJob;
    private final Map<ConnectorDescriptorKind, Boolean> connectorDescriptorKindToVisibility = new HashMap<ConnectorDescriptorKind, Boolean>();
    private boolean showConnectorDescriptorKindFilter;
    private boolean showConnectorDescriptorTextFilter;
    private Dictionary<Object, Object> environment;

    public ConnectorDiscoveryWizard(IConnectorsInstallJob installJob) {
        ConnectorDescriptorKind[] connectorDescriptorKindArray = ConnectorDescriptorKind.values();
        int n = connectorDescriptorKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectorDescriptorKind kind = connectorDescriptorKindArray[n2];
            this.connectorDescriptorKindToVisibility.put(kind, true);
            ++n2;
        }
        this.showConnectorDescriptorKindFilter = true;
        this.showConnectorDescriptorTextFilter = true;
        this.installJob = installJob;
        this.setWindowTitle(SVNUIMessages.ConnectorDiscoveryWizard_connectorDiscovery);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.createEnvironment();
    }

    private void createEnvironment() {
        this.environment = new Hashtable<Object, Object>(System.getProperties());
    }

    public void addPages() {
        this.mainPage = new ConnectorDiscoveryWizardMainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        try {
            this.installJob.setInstallableConnectors(this.mainPage.getInstallableConnectors());
            this.getContainer().run(true, true, (IRunnableWithProgress)this.installJob);
            return true;
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.team.svn.core.svnnature", SVNUIMessages.format((String)SVNUIMessages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            DiscoveryUiUtil.logAndDisplayStatus(SVNUIMessages.ConnectorDiscoveryWizard_cannotInstall, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void setVisibility(ConnectorDescriptorKind kind, boolean visible) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        this.connectorDescriptorKindToVisibility.put(kind, visible);
    }

    public boolean isVisible(ConnectorDescriptorKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        return this.connectorDescriptorKindToVisibility.get(kind);
    }

    public boolean isShowConnectorDescriptorKindFilter() {
        return false;
    }

    public void setShowConnectorDescriptorKindFilter(boolean showConnectorDescriptorKindFilter) {
        this.showConnectorDescriptorKindFilter = showConnectorDescriptorKindFilter;
    }

    public boolean isShowConnectorDescriptorTextFilter() {
        return this.showConnectorDescriptorTextFilter;
    }

    public void setShowConnectorDescriptorTextFilter(boolean showConnectorDescriptorTextFilter) {
        this.showConnectorDescriptorTextFilter = showConnectorDescriptorTextFilter;
    }

    public Dictionary<Object, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Dictionary<Object, Object> environment) {
        if (environment == null) {
            throw new IllegalArgumentException();
        }
        this.environment = environment;
    }
}

