/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNMergeStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNMergeHelper {
    protected ISVNConnector connector;

    public SVNMergeHelper(ISVNConnector connector) {
        this.connector = connector;
    }

    public void mergeStatus(SVNEntryReference reference, SVNRevisionRange[] revisions, String path, SVNDepth depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, revisions, path, depth, options, cb, monitor);
    }

    public void mergeStatus(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String path, SVNDepth depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference1, reference2, null, path, depth, options, cb, monitor);
    }

    public void mergeStatus(SVNEntryReference reference, String mergePath, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, null, mergePath, SVNDepth.INFINITY, options, cb, monitor);
    }

    protected void mergeStatus(SVNEntryReference reference1, SVNEntryRevisionReference reference2, SVNRevisionRange[] revisions, String path, SVNDepth depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String endUrlPref;
        SVNLogEntry[] entries;
        SVNRevision to;
        SVNRevision from;
        final ArrayList tmp = new ArrayList();
        ISVNNotificationCallback listener = new ISVNNotificationCallback(){

            public void notify(SVNNotification info) {
                tmp.add(info);
            }
        };
        SVNUtility.addSVNNotifyListener(this.connector, listener);
        try {
            if (reference2 != null) {
                this.connector.mergeTwo((SVNEntryRevisionReference)reference1, reference2, path, depth, options, monitor);
            } else if (revisions != null) {
                this.connector.merge(reference1, revisions, path, depth, options, monitor);
            } else {
                this.connector.mergeReintegrate(reference1, path, options, monitor);
            }
        }
        finally {
            SVNUtility.removeSVNNotifyListener(this.connector, listener);
        }
        SVNRevision sVNRevision = reference2 == null ? (revisions != null ? revisions[0].from : SVNRevision.fromNumber(1L)) : (from = ((SVNEntryRevisionReference)reference1).revision);
        SVNRevision sVNRevision2 = reference2 == null ? (revisions != null ? revisions[revisions.length - 1].to : reference1.pegRevision) : (to = reference2.revision);
        if (from.getKind() != SVNRevision.Kind.NUMBER) {
            entries = SVNUtility.logEntries(this.connector, reference1, from, SVNRevision.fromNumber(1L), 0L, ISVNConnector.EMPTY_LOG_ENTRY_PROPS, 1L, monitor);
            from = SVNRevision.fromNumber(entries[0].revision);
        }
        if (to.getKind() != SVNRevision.Kind.NUMBER) {
            entries = SVNUtility.logEntries(this.connector, reference2 == null ? reference1 : reference2, to, SVNRevision.fromNumber(1L), 0L, ISVNConnector.EMPTY_LOG_ENTRY_PROPS, 1L, monitor);
            to = SVNRevision.fromNumber(entries[0].revision);
        }
        if (reference2 != null && from.equals(to)) {
            from = SVNRevision.fromNumber(((SVNRevision.Number)to).getNumber() - 1L);
        }
        boolean reversed = reference2 == null ? SVNUtility.compareRevisions(from, to, new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, from), new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, to), this.connector) == 1 : SVNUtility.compareRevisions(from, to, (SVNEntryRevisionReference)reference1, reference2, this.connector) == 1;
        String startUrlPref = reference1.path;
        String string = endUrlPref = reference2 == null ? reference1.path : reference2.path;
        SVNLogEntry[] allMsgs = reversed ? SVNUtility.logEntries(this.connector, reference2 == null ? reference1 : this.getValidReference(reference2, from, monitor), from, to, 262144L, ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, 0L, monitor) : SVNUtility.logEntries(this.connector, reference2 == null ? reference1 : reference2, to, from, 262144L, ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, 0L, monitor);
        long minRev = ((SVNRevision.Number)(reversed ? to : from)).getNumber();
        Iterator it = tmp.iterator();
        while (it.hasNext() && !monitor.isActivityCancelled()) {
            int idx;
            SVNNotification state = (SVNNotification)it.next();
            SVNEntry.Kind kind = state.kind;
            String tPath = state.path.substring(path.length());
            String startUrl = SVNUtility.normalizeURL(String.valueOf(startUrlPref) + tPath);
            String endUrl = SVNUtility.normalizeURL(String.valueOf(endUrlPref) + tPath);
            boolean skipped = state.action == SVNNotification.PerformedAction.SKIP;
            SVNEntryStatus.Kind cState = SVNEntryStatus.Kind.NONE;
            SVNEntryStatus.Kind pState = SVNEntryStatus.Kind.NONE;
            boolean hasTreeConflict = state.action == SVNNotification.PerformedAction.TREE_CONFLICT;
            SVNConflictDescriptor treeConflict = null;
            if (hasTreeConflict) {
                SVNEntryInfo[] infos = SVNUtility.info(this.connector, new SVNEntryRevisionReference(state.path), SVNDepth.EMPTY, monitor);
                if (infos.length > 0 && infos[0].treeConflicts != null && infos[0].treeConflicts.length > 0) {
                    treeConflict = infos[0].treeConflicts[0];
                    kind = infos[0].kind;
                    if (treeConflict.conflictKind == SVNConflictDescriptor.Kind.CONTENT) {
                        cState = SVNEntryStatus.Kind.CONFLICTED;
                    } else {
                        pState = SVNEntryStatus.Kind.CONFLICTED;
                    }
                } else {
                    hasTreeConflict = false;
                }
            }
            if (state.action == SVNNotification.PerformedAction.UPDATE_ADD) {
                cState = SVNEntryStatus.Kind.ADDED;
            } else if (state.action == SVNNotification.PerformedAction.UPDATE_DELETE) {
                cState = SVNEntryStatus.Kind.DELETED;
            } else if (state.action == SVNNotification.PerformedAction.UPDATE_UPDATE) {
                SVNEntryStatus.Kind kind2 = state.propState == SVNNotification.NodeStatus.CHANGED ? SVNEntryStatus.Kind.MODIFIED : (pState = state.propState == SVNNotification.NodeStatus.CONFLICTED ? SVNEntryStatus.Kind.CONFLICTED : SVNEntryStatus.Kind.NONE);
                cState = state.contentState == SVNNotification.NodeStatus.CHANGED || state.contentState == SVNNotification.NodeStatus.MERGED ? SVNEntryStatus.Kind.MODIFIED : (state.contentState == SVNNotification.NodeStatus.CONFLICTED ? SVNEntryStatus.Kind.CONFLICTED : SVNEntryStatus.Kind.NONE);
            } else if (state.action == SVNNotification.PerformedAction.SKIP) {
                if (state.contentState == SVNNotification.NodeStatus.MISSING) {
                    try {
                        SVNRevision pegRev = reference1.pegRevision;
                        if (reference2 != null) {
                            pegRev = reference2.pegRevision;
                        }
                        SVNUtility.info(this.connector, new SVNEntryRevisionReference(endUrl, pegRev, to), SVNDepth.EMPTY, monitor);
                        pState = SVNEntryStatus.Kind.MODIFIED;
                        cState = SVNEntryStatus.Kind.MODIFIED;
                    }
                    catch (Exception exception) {
                        cState = SVNEntryStatus.Kind.DELETED;
                    }
                } else if (state.contentState == SVNNotification.NodeStatus.OBSTRUCTED) {
                    cState = SVNEntryStatus.Kind.ADDED;
                }
            }
            if (cState == SVNEntryStatus.Kind.NONE && pState == SVNEntryStatus.Kind.NONE && !hasTreeConflict) continue;
            long startRevision = -1L;
            long endRevision = -1L;
            long date = 0L;
            String author = null;
            String message = null;
            if (cState == SVNEntryStatus.Kind.ADDED && !reversed || cState == SVNEntryStatus.Kind.DELETED && reversed || hasTreeConflict && (treeConflict.action == SVNConflictDescriptor.Action.ADD && !reversed || treeConflict.action == SVNConflictDescriptor.Action.DELETE && reversed)) {
                idx = this.getLogIndex(allMsgs, endUrl, false);
                if (idx != -1) {
                    endRevision = allMsgs[idx].revision;
                    date = allMsgs[idx].date;
                    author = allMsgs[idx].author;
                    message = allMsgs[idx].message;
                }
            } else if (cState == SVNEntryStatus.Kind.MODIFIED || cState == SVNEntryStatus.Kind.CONFLICTED || pState == SVNEntryStatus.Kind.MODIFIED || pState == SVNEntryStatus.Kind.CONFLICTED || hasTreeConflict && treeConflict.action == SVNConflictDescriptor.Action.MODIFY) {
                idx = this.getLogIndex(allMsgs, endUrl, false);
                if (idx != -1) {
                    endRevision = allMsgs[idx].revision;
                    date = allMsgs[idx].date;
                    author = allMsgs[idx].author;
                    message = allMsgs[idx].message;
                }
                startRevision = (idx = this.getLogIndex(allMsgs, startUrl, true)) != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
            } else {
                idx = this.getLogIndex(allMsgs, endUrl, false);
                if (idx != -1) {
                    endRevision = allMsgs[idx].revision;
                    date = allMsgs[idx].date;
                    author = allMsgs[idx].author;
                    message = allMsgs[idx].message;
                } else {
                    idx = this.getLogIndex(allMsgs, startUrl, false);
                    if (idx != -1) {
                        endUrl = startUrl;
                        endRevision = allMsgs[idx].revision;
                        date = allMsgs[idx].date;
                        author = allMsgs[idx].author;
                        message = allMsgs[idx].message;
                    }
                }
                idx = this.getLogIndex(allMsgs, startUrl, true);
                long l = startRevision = idx != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
            }
            if (reversed) {
                startRevision = endRevision;
                endRevision = allMsgs[allMsgs.length - 1].revision;
                date = allMsgs[allMsgs.length - 1].date;
                author = allMsgs[allMsgs.length - 1].author;
                message = allMsgs[allMsgs.length - 1].message;
            }
            cb.next(new SVNMergeStatus(startUrl, endUrl, state.path, kind, cState, pState, startRevision, endRevision, date, author, message, skipped, hasTreeConflict, treeConflict));
        }
    }

    protected SVNEntryReference getValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) throws SVNConnectorException {
        if (referenceToExisting.pegRevision == null) {
            referenceToExisting = new SVNEntryReference(referenceToExisting.path, SVNRevision.HEAD);
        }
        if (referenceToExisting.pegRevision.getKind() != SVNRevision.Kind.HEAD && referenceToExisting.pegRevision.getKind() != SVNRevision.Kind.NUMBER) {
            throw new RuntimeException("Unexpected revision kind. Kind: " + (Object)((Object)referenceToExisting.pegRevision.getKind()));
        }
        if (lastRevision.getKind() != SVNRevision.Kind.NUMBER) {
            throw new RuntimeException("Unexpected last revision kind. Kind: " + (Object)((Object)lastRevision.getKind()));
        }
        if (referenceToExisting.pegRevision.getKind() == SVNRevision.Kind.HEAD) {
            return referenceToExisting;
        }
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        while (end > start) {
            referenceToExisting = this.getLastValidReference(referenceToExisting, lastRevision, monitor);
            if (referenceToExisting.pegRevision.equals(lastRevision)) continue;
            start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber() + 1L;
            SVNEntryReference tRef = new SVNEntryReference(referenceToExisting.path, SVNRevision.fromNumber(start));
            while (!this.exists(tRef, monitor)) {
                tRef = new SVNEntryReference(tRef.path.substring(0, tRef.path.lastIndexOf("/")), tRef.pegRevision);
            }
            SVNLogEntry[] log = SVNUtility.logEntries(this.connector, tRef, tRef.pegRevision, referenceToExisting.pegRevision, 262144L, ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, 0L, monitor);
            SVNLogPath[] paths = log[0].changedPaths;
            boolean renamed = false;
            if (paths != null) {
                String decodedUrl = SVNUtility.decodeURL(referenceToExisting.path);
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].copiedFromPath)) != -1 && (decodedUrl.charAt(idx + paths[k].copiedFromPath.length()) == '/' || decodedUrl.endsWith(paths[k].copiedFromPath))) {
                        decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[k].path + decodedUrl.substring(idx + paths[k].copiedFromPath.length());
                        tRef = new SVNEntryReference(SVNUtility.encodeURL(decodedUrl), tRef.pegRevision);
                        renamed = true;
                        break;
                    }
                    ++k;
                }
            }
            referenceToExisting = tRef;
            if (renamed) continue;
            return referenceToExisting;
        }
        return referenceToExisting;
    }

    protected SVNEntryReference getLastValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) {
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        do {
            long middle;
            SVNEntryReference tRef;
            if (this.exists(tRef = new SVNEntryReference(referenceToExisting.path, SVNRevision.fromNumber(middle = end - (end - start) / 2L)), monitor)) {
                start = middle;
                referenceToExisting = tRef;
                continue;
            }
            if (end - start == 1L) break;
            end = middle;
        } while (end > start);
        return referenceToExisting;
    }

    protected boolean exists(SVNEntryReference reference, ISVNProgressMonitor monitor) {
        try {
            SVNUtility.logEntries(this.connector, reference, reference.pegRevision, reference.pegRevision, 0L, ISVNConnector.EMPTY_LOG_ENTRY_PROPS, 1L, monitor);
            return true;
        }
        catch (SVNConnectorException sVNConnectorException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLogIndex(SVNLogEntry[] msgs, String url, boolean last) {
        String decodedUrl = SVNUtility.decodeURL(url);
        int retVal = -1;
        int j = 0;
        while (j < msgs.length) {
            SVNLogPath[] paths = msgs[j].changedPaths;
            if (paths != null) {
                int maxPathIdx = -1;
                int maxPathLen = 0;
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k] != null && decodedUrl.endsWith(paths[k].path)) {
                        if (!last) return j;
                        if (paths[k].copiedFromPath != null) {
                            maxPathIdx = k;
                            maxPathLen = paths[k].path.length();
                        }
                        retVal = paths[k].action == SVNLogPath.ChangeType.ADDED ? j : -1;
                    } else if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].path)) != -1 && (decodedUrl.charAt(idx + paths[k].path.length()) == '/' || decodedUrl.endsWith(paths[k].path)) && paths[k].path.length() > maxPathLen) {
                        maxPathIdx = k;
                        maxPathLen = paths[k].path.length();
                    }
                    ++k;
                }
                if (maxPathIdx != -1) {
                    int idx = decodedUrl.indexOf(paths[maxPathIdx].path);
                    decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[maxPathIdx].copiedFromPath + decodedUrl.substring(idx + paths[maxPathIdx].path.length());
                }
            }
            ++j;
        }
        return retVal;
    }
}

