/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialog
extends Dialog {
    private String fTitle;
    private Image fTitleImage;
    private String fMessage;
    private Label fMessageLabel;
    private Control customArea;

    protected AbstractDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.fTitle = title;
        this.fMessage = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
        if (this.fTitleImage != null) {
            shell.setImage(this.fTitleImage);
        }
    }

    protected int getMessageLabelStyle() {
        return 64;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(0).equalWidth(true).applyTo(composite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).applyTo((Control)composite);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Point defaultMargins = LayoutConstants.getMargins();
        Point defaultSpacing = LayoutConstants.getSpacing();
        GridLayoutFactory.fillDefaults().margins(defaultMargins.x, defaultMargins.y * 3 / 2).spacing(defaultSpacing.x * 2, defaultSpacing.y).numColumns(this.getColumnCount()).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createDialogAndButtonArea(parent);
        return parent;
    }

    protected int getColumnCount() {
        return 2;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        this.buttonBar = this.createButtonBar(parent);
        AbstractDialog.applyDialogFont((Control)parent);
    }

    protected Control createCustomArea(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.customArea = this.createCustomArea(composite);
        if (this.customArea == null) {
            this.customArea = new Label(composite, 0);
        }
        return composite;
    }

    protected Control createMessageArea(Composite composite) {
        if (this.fMessage != null) {
            this.fMessageLabel = new Label(composite, this.getMessageLabelStyle());
            this.fMessageLabel.setText(this.fMessage);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.fMessageLabel);
        }
        return composite;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }
}

