/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.AbstractTreeElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.TreeElementStateProviderFactory;
import org.eclipse.ui.IMemento;

public class FileElementStateProvider
extends AbstractTreeElementStateProvider {
    private IFile file = null;

    public FileElementStateProvider(TreeViewer viewer, IMemento memento) {
        super(viewer);
        Assert.isNotNull((Object)memento);
        String pathAsString = memento.getString("path");
        if (pathAsString != null) {
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathAsString));
        }
    }

    public FileElementStateProvider(TreeViewer viewer, IFile file) {
        super(viewer);
        this.file = file;
    }

    @Override
    public boolean hasUnderlyingModel() {
        return ModelDescriptorRegistry.INSTANCE.isModelFile(this.file);
    }

    @Override
    public boolean canUnderlyingModelBeLoaded() {
        return !this.isStale();
    }

    @Override
    public boolean isUnderlyingModelLoaded() {
        return EcorePlatformUtil.isFileLoaded((IFile)this.file);
    }

    @Override
    public void loadUnderlyingModel() {
        IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(this.file);
        if (modelDescriptor != null) {
            ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
        }
    }

    @Override
    public boolean isStale() {
        if (this.file != null) {
            return !this.file.exists();
        }
        return true;
    }

    @Override
    public Object getTreeElement() {
        return this.file;
    }

    @Override
    public void appendToMemento(IMemento parentMemento) {
        if (this.file != null) {
            IMemento memento = parentMemento.createChild(TreeElementStateProviderFactory.MEMENTO_TYPE_ELEMENT_FILE);
            memento.putString("path", this.file.getFullPath().toString());
        }
    }

    public String toString() {
        return "FileElementProvider [file=" + this.file.getFullPath() + "]";
    }
}

