/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRelations;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class RepresentationExtensionsFinder {
    private final RepresentationDescription extensionTarget;

    public RepresentationExtensionsFinder(RepresentationDescription extensionTarget) {
        this.extensionTarget = (RepresentationDescription)Preconditions.checkNotNull((Object)extensionTarget);
    }

    public List<RepresentationExtensionDescription> findApplicableExtensions(Iterable<Viewpoint> context) {
        String targetSiriusURI = this.getTargetSiriusURI();
        String targetRepresentationName = this.extensionTarget.getName();
        if (targetSiriusURI != null && targetRepresentationName != null) {
            return this.findApplicableExtensions(context, targetSiriusURI, targetRepresentationName);
        }
        return Collections.emptyList();
    }

    public boolean isAffectedBy(Viewpoint vp) {
        return !this.findApplicableExtensions(Collections.singleton(vp)).isEmpty();
    }

    public LinkedHashSet<Viewpoint> findAllRelevantViewpoints(Session session) {
        RepresentationDescription mainRepresentationDescription = this.extensionTarget;
        LinkedHashSet result = Sets.newLinkedHashSet();
        Viewpoint mainVP = new RepresentationDescriptionQuery(mainRepresentationDescription).getParentViewpoint();
        if (mainVP != null) {
            HashBiMap candidates = HashBiMap.create();
            for (Viewpoint vp : session.getSelectedViewpoints(false)) {
                Option<URI> uri = new ViewpointQuery(vp).getViewpointURI();
                if (!uri.some()) continue;
                candidates.put((Object)((URI)uri.get()), (Object)vp);
            }
            ViewpointRelations relations = ((ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance()).getRelations();
            boolean changed = result.add(mainVP);
            while (changed) {
                changed = false;
                for (Viewpoint v1 : Lists.newArrayList((Iterable)result)) {
                    URI uri = (URI)candidates.inverse().get((Object)v1);
                    boolean bl = changed = changed || Iterables.addAll((Collection)result, (Iterable)Iterables.transform((Iterable)relations.getReuse().apply((Object)uri), (Function)Functions.forMap((Map)candidates)));
                }
                for (Viewpoint v : session.getSelectedViewpoints(false)) {
                    URI extenderUri = (URI)candidates.inverse().get((Object)v);
                    for (URI extendeeUri : relations.getCustomize().apply((Object)extenderUri)) {
                        if (!result.contains(candidates.get((Object)extendeeUri))) continue;
                        boolean bl = changed = changed || result.add(v);
                    }
                }
            }
        }
        return result;
    }

    private String getTargetSiriusURI() {
        Option<URI> viewpointURI;
        Option<EObject> parentVp = new EObjectQuery(this.extensionTarget).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getViewpoint());
        if (parentVp.some() && (viewpointURI = new ViewpointQuery((Viewpoint)parentVp.get()).getViewpointURI()).some()) {
            return ((URI)viewpointURI.get()).toString();
        }
        return null;
    }

    private List<RepresentationExtensionDescription> findApplicableExtensions(Iterable<Viewpoint> context, String targetSiriusURI, String targetRepresentationName) {
        ArrayList result = Lists.newArrayList();
        for (Viewpoint vp : context) {
            for (RepresentationExtensionDescription ext : vp.getOwnedRepresentationExtensions()) {
                if (!this.appliesTo(ext, targetSiriusURI, targetRepresentationName)) continue;
                result.add(ext);
            }
        }
        return result;
    }

    private boolean appliesTo(RepresentationExtensionDescription ext, String targetViewpointURI, String targetRepresentationName) {
        return targetViewpointURI.matches(ext.getViewpointURI()) && targetRepresentationName.matches(ext.getRepresentationName());
    }
}

