/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.search;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;
import org.eclipse.search.ui.text.Match;

public class NlsFindKeysJob
extends AbstractJob {
    private final List<String> m_searchKeys;
    private final Map<String, List<Match>> m_matches;

    public NlsFindKeysJob(String nlsKey, String jobTitle) {
        this(Collections.singletonList(nlsKey), jobTitle);
    }

    public NlsFindKeysJob(INlsProject project, String jobTitle) {
        this(NlsFindKeysJob.getLocalKeys(project), jobTitle);
    }

    protected NlsFindKeysJob(List<String> searchKeys, String jobTitle) {
        super(jobTitle);
        this.m_searchKeys = new ArrayList<String>(searchKeys.size() * 2);
        for (String key : searchKeys) {
            this.m_searchKeys.add("\"" + key + "\"");
            this.m_searchKeys.add(String.valueOf('\'') + key + '\'');
        }
        this.m_matches = new HashMap<String, List<Match>>();
    }

    protected static List<String> getLocalKeys(INlsProject project) {
        return project.getAllEntries().stream().filter(entry -> entry.getType() == 1).map(INlsEntry::getKey).collect(Collectors.toList());
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        this.m_matches.clear();
        IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        monitor.beginTask("Searching for NLS keys", javaProjects.length);
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject root = iJavaProjectArray[n2];
            monitor.setTaskName("Searching in '" + root.getElementName() + "'.");
            IProject p = root.getProject();
            Path outputLocation = new File(p.getLocation().toOSString(), root.getOutputLocation().removeFirstSegments(1).toOSString()).toPath();
            this.searchInFolder(p.getLocation().toFile().toPath(), p.getDefaultCharset(), outputLocation, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            ++n2;
        }
    }

    protected void searchInFolder(Path folder, final String charset, final Path outputFolder, final IProgressMonitor monitor) throws CoreException {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    boolean isHiddenDir;
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (dir.equals(outputFolder)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Path fileName = dir.getFileName();
                    boolean bl = isHiddenDir = fileName != null && fileName.toString().startsWith(".");
                    if (isHiddenDir) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (NlsFindKeysJob.this.isInterestingFile(file, attrs)) {
                        NlsFindKeysJob.this.searchInFile(file, charset, monitor);
                    }
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
    }

    protected boolean isInterestingFile(Path file, BasicFileAttributes attrs) {
        String[] interestingFileExtensions;
        if (!attrs.isRegularFile()) {
            return false;
        }
        Path path = file.getFileName();
        if (path == null) {
            return false;
        }
        String fileName = path.toString().toLowerCase();
        String[] stringArray = interestingFileExtensions = new String[]{".java", ".js", ".html", ".less", ".json", ".xml", ".sql", ".css", ".svg", ".txt", ".jsp"};
        int n = interestingFileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (fileName.endsWith(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void searchInFile(Path file, String charset, IProgressMonitor monitor) throws IOException {
        IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toUri());
        if (workspaceFiles.length < 1) {
            return;
        }
        IFile workspaceFile = workspaceFiles[0];
        if (!workspaceFile.exists()) {
            return;
        }
        String content = new String(Files.readAllBytes(file), charset);
        for (String search : this.m_searchKeys) {
            int pos = 0;
            int index = -1;
            while ((index = content.indexOf(search, pos)) >= 0) {
                if (monitor.isCanceled()) {
                    return;
                }
                Match match = new Match((Object)workspaceFile, index, search.length());
                String key = search.substring(1, search.length() - 1);
                this.acceptNlsKeyMatch(key, match);
                pos = index + search.length();
            }
        }
    }

    protected void acceptNlsKeyMatch(String nlsKey, Match match) {
        this.m_matches.computeIfAbsent(nlsKey, key -> new ArrayList()).add(match);
    }

    public List<Match> getMatches(String nlsKey) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Match>(list);
    }

    public Map<String, List<Match>> getAllMatches() {
        return new HashMap<String, List<Match>>(this.m_matches);
    }
}

