/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.validators;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;

public class ContextReferenceValidator
implements IQ7Validator {
    @Override
    public void validate(IQ7NamedElement element, IQ7ProblemReporter reporter, IProgressMonitor monitor) {
        block18: {
            try {
                String[] contexts;
                String[] ctxs;
                IQ7Project project = element.getQ7Project();
                IQ7ProjectMetadata md = element.getQ7Project().getMetadata();
                List<String> lctxs = null;
                if (md != null && md.exists() && (ctxs = md.getContexts()) != null) {
                    lctxs = Arrays.asList(ctxs);
                }
                if (element instanceof ITestCase) {
                    try {
                        contexts = Q7SearchCore.findContextsByDocument((IQ7Element)element);
                        if (contexts == null) {
                            contexts = ((ITestCase)element).getContexts();
                        }
                        if (contexts != null) {
                            String[] stringArray = contexts;
                            int n = contexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String cid = stringArray[n2];
                                this.reportProjectContextUsed(element, reporter, lctxs, cid);
                                List context = project.find(IContext.class, cid);
                                if (context.size() == 0) {
                                    this.reportUnresolved(element, reporter, cid);
                                }
                                ++n2;
                            }
                        }
                        break block18;
                    }
                    catch (ModelException e) {
                        RcpttPlugin.log((Throwable)e);
                    }
                    break block18;
                }
                if (element instanceof IContext) {
                    for (String cid : RcpttCore.getInstance().getContextReferences((IContext)element)) {
                        this.reportProjectContextUsed(element, reporter, lctxs, cid);
                        List contexts2 = project.find(IContext.class, cid);
                        if (!contexts2.isEmpty()) continue;
                        this.reportUnresolved(element, reporter, cid);
                    }
                } else if (element instanceof IQ7ProjectMetadata) {
                    contexts = Q7SearchCore.findContextsByDocument((IQ7Element)element);
                    if (contexts == null) {
                        contexts = ((IQ7ProjectMetadata)element).getContexts();
                    }
                    if (contexts != null) {
                        String[] stringArray = contexts;
                        int n = contexts.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String cid = stringArray[n3];
                            List context = project.find(IContext.class, cid);
                            if (context.size() == 0) {
                                this.reportUnresolved(element, reporter, cid);
                            }
                            ++n3;
                        }
                    }
                }
            }
            catch (Throwable e) {
                TeslaCore.log((Throwable)e);
            }
        }
    }

    private void reportProjectContextUsed(IQ7NamedElement element, IQ7ProblemReporter reporter, List<String> lctxs, String cid) {
        if (lctxs != null && lctxs.contains(cid)) {
            String name = cid;
            try {
                List located = element.getQ7Project().find(IContext.class, cid);
                if (located != null && located.size() == 1) {
                    name = ((IContext)located.get(0)).getElementName();
                }
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)e);
            }
            reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Warning, "Referenced context \"" + name + "\" is included as default context for project: " + element.getQ7Project().getName() + " and will be ignored.", 0, 0, 0, 0);
        }
    }

    private void reportUnresolved(IQ7NamedElement element, IQ7ProblemReporter reporter, String cid) {
        reporter.reportProblem((IFile)element.getResource(), IQ7ProblemReporter.ProblemType.Error, "Unresolved context:" + cid, 0, 0, 0, 0);
    }

    @Override
    public void reconcile(IQ7NamedElement content, String eclCode, IQ7ProblemReporter reporter, IProgressMonitor nullProgressMonitor) {
    }
}

