/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.AccessRulesDialog;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementSorter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;
import org.eclipse.php.internal.ui.preferences.includepath.PHPIPListLabelProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPProjectsWorkbookPage
extends BuildPathBasePage {
    private final int IDX_ADDPROJECT = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private ListDialogField fBuildpathList;
    private IScriptProject fCurrJProject;
    private TreeListDialogField fProjectsList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public PHPProjectsWorkbookPage(ListDialogField buildpathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fBuildpathList = buildpathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[4];
        stringArray[0] = NewWizardMessages.ProjectsWorkbookPage_projects_add_button;
        stringArray[2] = NewWizardMessages.ProjectsWorkbookPage_projects_edit_button;
        stringArray[3] = NewWizardMessages.ProjectsWorkbookPage_projects_remove_button;
        String[] buttonLabels = stringArray;
        ProjectsAdapter adapter = new ProjectsAdapter();
        this.fProjectsList = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new PHPIPListLabelProvider());
        this.fProjectsList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fProjectsList.setLabelText(NewWizardMessages.ProjectsWorkbookPage_projects_label);
        this.fProjectsList.enableButton(3, false);
        this.fProjectsList.enableButton(2, false);
        this.fProjectsList.setViewerComparator((ViewerComparator)new BPListElementSorter());
    }

    public void init(IScriptProject jproject) {
        this.updateProjectsList(jproject);
    }

    public void setTitle(String title) {
        this.fProjectsList.setLabelText(title);
    }

    private void updateProjectsList(IScriptProject currJProject) {
        List cpelements = this.fBuildpathList.getElements();
        ArrayList<BPListElement> checkedProjects = new ArrayList<BPListElement>(cpelements.size());
        int i = cpelements.size() - 1;
        while (i >= 0) {
            BPListElement cpelem = (BPListElement)cpelements.get(i);
            if (this.isEntryKind(cpelem.getEntryKind())) {
                checkedProjects.add(cpelem);
            }
            --i;
        }
        this.fProjectsList.setElements(checkedProjects);
        this.fCurrJProject = currJProject;
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fProjectsList}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProjectsList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        return composite;
    }

    private void updateBuildpathList() {
        List projelements = this.fProjectsList.getElements();
        boolean remove = false;
        List cpelements = this.fBuildpathList.getElements();
        int i = cpelements.size() - 1;
        while (i >= 0) {
            BPListElement cpe = (BPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind()) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            cpelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fBuildpathList.setElements((Collection)cpelements);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fProjectsList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public boolean isEntryKind(int kind) {
        return kind == 2;
    }

    private void projectPageCustomButtonPressed(DialogField field, int index) {
        Object[] entries = null;
        switch (index) {
            case 0: {
                entries = this.openProjectDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (entries != null) {
            int nElementsChosen = entries.length;
            List cplist = this.fProjectsList.getElements();
            ArrayList<BPListElement> elementsToAdd = new ArrayList<BPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                BPListElement curr = entries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fProjectsList.addElements(elementsToAdd);
            if (index == 0) {
                this.fProjectsList.refresh();
            }
            this.fProjectsList.postSetSelection((ISelection)new StructuredSelection(entries));
        }
    }

    private void removeEntry() {
        List selElements = this.fProjectsList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)elem;
                String key = attrib.getKey();
                IAccessRule[] value = null;
                if (key.equals("accessrules")) {
                    value = new IAccessRule[]{};
                }
                attrib.getParent().setAttribute(key, (Object)value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fProjectsList.refresh();
            this.fBuildpathList.dialogFieldChanged();
        } else {
            for (BPListElement entry : selElements) {
                try {
                    BuildPathUtils.removeEntryFromBuildPath((IScriptProject)this.fCurrJProject, (IBuildpathEntry)entry.getBuildpathEntry());
                }
                catch (ModelException e) {
                    PHPCorePlugin.log((Throwable)e);
                }
            }
            this.fProjectsList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int elements = 0;
        int attributes = 0;
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)elem;
                if (attrib.getKey().equals("accessrules")) {
                    return ((IAccessRule[])attrib.getValue()).length > 0;
                }
                if (attrib.getValue() == null) {
                    return false;
                }
                ++attributes;
            } else if (elem instanceof BPListElement) {
                ++elements;
            }
            ++i;
        }
        return attributes == selElements.size() || elements == selElements.size();
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof BPListElement) {
            return false;
        }
        return elem instanceof BPListElementAttribute;
    }

    private void editEntry() {
        List selElements = this.fProjectsList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fProjectsList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((BPListElement)elem);
        } else if (elem instanceof BPListElementAttribute) {
            this.editAttributeEntry((BPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(BPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("accessrules")) {
            this.showAccessRestrictionDialog(elem.getParent());
        }
    }

    private void showAccessRestrictionDialog(BPListElement selElement) {
        AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, this.fCurrJProject, this.fPageContainer != null);
        int res = dialog.open();
        if (res == 0 || res == 10) {
            selElement.setAttribute("accessrules", (Object)dialog.getAccessRules());
            selElement.setAttribute("combineaccessrules", (Object)dialog.doCombineAccessRules());
            this.fProjectsList.refresh();
            this.fBuildpathList.dialogFieldChanged();
            if (res == 10) {
                dialog.performPageSwitch(this.fPageContainer);
            }
        }
    }

    private void editElementEntry(BPListElement elem) {
        BPListElement[] res = this.openProjectDialog(elem);
        if (res != null && res.length > 0) {
            BPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fProjectsList.replaceElement((Object)elem, (Object)curr);
        }
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    private BPListElement[] openProjectDialog(BPListElement elem) {
        try {
            ArrayList<IScriptProject> selectable = new ArrayList<IScriptProject>();
            IScriptModel model = this.fCurrJProject.getModel();
            IDLTKLanguageToolkit toolkit = this.fCurrJProject.getLanguageToolkit();
            selectable.addAll(Arrays.asList(toolkit != null ? model.getScriptProjects(toolkit.getNatureId()) : model.getScriptProjects()));
            selectable.remove(this.fCurrJProject);
            List elements = this.fProjectsList.getElements();
            int i = 0;
            while (i < elements.size()) {
                BPListElement curr = (BPListElement)elements.get(i);
                IScriptProject proj = (IScriptProject)DLTKCore.create((IResource)curr.getResource());
                selectable.remove(proj);
                ++i;
            }
            Object[] selectArr = selectable.toArray();
            new ModelElementSorter().sort(null, selectArr);
            ScriptUILabelProvider labelProvider = new ScriptUILabelProvider();
            ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), Arrays.asList(selectArr), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, NewWizardMessages.ProjectsWorkbookPage_chooseProjects_message);
            dialog.setTitle(NewWizardMessages.ProjectsWorkbookPage_chooseProjects_title);
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                BPListElement[] cpElements = new BPListElement[result.length];
                int i2 = 0;
                while (i2 < result.length) {
                    IScriptProject curr = (IScriptProject)result[i2];
                    cpElements[i2] = new BPListElement(this.fCurrJProject, 2, curr.getPath(), curr.getResource(), false);
                    ++i2;
                }
                return cpElements;
            }
        }
        catch (ModelException e) {
            return null;
        }
        return null;
    }

    protected void projectPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fProjectsList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void projectPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fProjectsList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void projectPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateBuildpathList();
        }
    }

    private void projectPageSelectionChanged(DialogField field) {
        List selElements = this.fProjectsList.getSelectedElements();
        this.fProjectsList.enableButton(2, this.canEdit(selElements));
        this.fProjectsList.enableButton(3, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fProjectsList.enableButton(0, noAttributes);
    }

    private class ProjectsAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private ProjectsAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            PHPProjectsWorkbookPage.this.projectPageCustomButtonPressed((DialogField)field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            PHPProjectsWorkbookPage.this.projectPageSelectionChanged((DialogField)field);
        }

        public void doubleClicked(TreeListDialogField field) {
            PHPProjectsWorkbookPage.this.projectPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            PHPProjectsWorkbookPage.this.projectPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof BPListElement) {
                return ((BPListElement)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof BPListElementAttribute) {
                return ((BPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            PHPProjectsWorkbookPage.this.projectPageDialogFieldChanged(field);
        }
    }
}

