/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.ui.ServerTypeWizardFragment;
import org.eclipse.php.internal.server.ui.wizard.ServerTypeCompositeFragmentFactory;
import org.eclipse.php.internal.ui.wizards.FragmentedWizard;
import org.eclipse.php.internal.ui.wizards.WizardFragment;
import org.eclipse.php.internal.ui.wizards.WizardModel;
import org.eclipse.php.server.core.types.IServerType;
import org.eclipse.php.server.core.types.ServerTypesManager;
import org.eclipse.php.server.ui.types.IServerTypeDescriptor;
import org.eclipse.php.server.ui.types.ServerTypesDescriptorRegistry;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ServerWizard
extends FragmentedWizard
implements INewWizard {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.server.ui.serverWizardAndComposite";
    private IServerType serverType;
    private ServerTypeWizardFragment serverTypeWizardFragment;

    public ServerWizard() {
        this(PHPServerUIMessages.getString("ServerWizard.serverCreation"));
    }

    public ServerWizard(String title, WizardModel taskModel) {
        super(title, null, taskModel);
        this.setRootFragment(this.createRootFragment(null));
        ServerTypeCompositeFragmentFactory serverType = new ServerTypeCompositeFragmentFactory();
        this.serverTypeWizardFragment = (ServerTypeWizardFragment)serverType.createWizardFragment();
    }

    public ServerWizard(String title) {
        super(title, null);
        this.setRootFragment(this.createRootFragment(null));
        ServerTypeCompositeFragmentFactory serverType = new ServerTypeCompositeFragmentFactory();
        this.serverTypeWizardFragment = (ServerTypeWizardFragment)serverType.createWizardFragment();
    }

    private WizardFragment createRootFragment(final IServerType type) {
        WizardFragment fragment = new WizardFragment(){
            private WizardFragment[] children;

            protected void createChildFragments(List list) {
                if (this.children != null) {
                    ServerWizard.this.loadChildren(this.children, list);
                    return;
                }
                IServerTypeDescriptor serverTypeDescriptor = ServerTypesDescriptorRegistry.getDescriptor(type);
                ICompositeFragmentFactory[] factories = serverTypeDescriptor.getWizardFragmentFactories();
                int index = 0;
                if (ServerTypesManager.getInstance().getAll().size() > 1) {
                    this.children = new WizardFragment[factories.length + 1];
                    this.children[index] = ServerWizard.this.serverTypeWizardFragment;
                    index = 1;
                } else {
                    this.children = new WizardFragment[factories.length];
                }
                int i = 0;
                while (i < factories.length) {
                    this.children[i + index] = factories[i].createWizardFragment();
                    ++i;
                }
                ServerWizard.this.loadChildren(this.children, list);
            }
        };
        return fragment;
    }

    private void loadChildren(WizardFragment[] children, List list) {
        int i = 0;
        while (i < children.length) {
            list.add(children[i]);
            ++i;
        }
    }

    public void addPages() {
        IServerType newType;
        if (this.serverTypeWizardFragment != null && (newType = this.serverTypeWizardFragment.getType()) != null && !newType.equals(this.serverType)) {
            this.serverType = newType;
            this.setRootFragment(this.createRootFragment(newType));
        }
        super.addPages();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        if (this.getCurrentWizardFragment() != null && this.getCurrentWizardFragment().equals((Object)this.serverTypeWizardFragment)) {
            return false;
        }
        return super.canFinish();
    }
}

