/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.UnsupportedEncodingException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

public abstract class AbstractDBGpValue
extends DBGpElement
implements IValue,
IPHPDataType {
    protected IPHPDataType.DataType fDataType;
    protected boolean fHasVariables = false;
    protected DBGpVariable fOwner;
    protected String fValueString = "";
    protected Node fDescriptor;

    public AbstractDBGpValue(DBGpVariable owner) {
        super(owner.getDebugTarget());
        this.fOwner = owner;
        this.update(this.fOwner.getDescriptor());
    }

    @Override
    public IPHPDataType.DataType getDataType() {
        return this.fDataType;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fDataType.getText();
    }

    public String getValueString() throws DebugException {
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return this.fHasVariables;
    }

    public String getValueDetail() throws DebugException {
        return this.getValueString();
    }

    protected abstract String createValueString(DBGpValueData var1);

    protected abstract boolean supportsValueModification();

    protected abstract boolean verifyValue(String var1);

    protected void setValue(String value) {
        this.fValueString = value;
    }

    protected DBGpVariable getOwner() {
        return this.fOwner;
    }

    protected Node getDescriptor() {
        return this.fDescriptor;
    }

    protected void update(Node descriptor) {
        this.fDescriptor = descriptor;
        String t = DBGpResponse.getAttribute(this.fDescriptor, "type");
        this.fDataType = IPHPDataType.DataType.find(t);
        this.fValueString = this.createValueString(new DBGpValueData(this.fDescriptor));
    }

    protected class DBGpValueData {
        private static final String ENCODING_BASE64 = "base64";
        private byte[] fValueBytes = null;
        private String fValueString;

        protected DBGpValueData(Node property) {
            this.decode(property);
        }

        private void decode(Node property) {
            String encoding = DBGpResponse.getAttribute(property, "encoding");
            Node Child = property.getFirstChild();
            if (Child != null) {
                String valueData;
                this.fValueString = valueData = Child.getNodeValue();
                if (encoding != null && encoding.equalsIgnoreCase(ENCODING_BASE64) && valueData != null && valueData.trim().length() != 0) {
                    DBGpTarget target = (DBGpTarget)AbstractDBGpValue.this.getDebugTarget();
                    this.fValueBytes = Base64.decode(valueData.trim());
                    try {
                        this.fValueString = new String(this.fValueBytes, target.getBinaryEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        DBGpLogger.logException("Unexpected encoding problem", this, e);
                        this.fValueString = new String(this.fValueBytes);
                    }
                }
            }
        }

        public byte[] getValueBytes() {
            return this.fValueBytes;
        }

        public String getValueString() {
            return this.fValueString;
        }
    }
}

