/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.phar.Messages;
import org.eclipse.php.internal.core.phar.PharConstants;
import org.eclipse.php.internal.core.phar.PharEntry;
import org.eclipse.php.internal.core.phar.PharEntryBufferedRandomInputStream;
import org.eclipse.php.internal.core.phar.PharException;
import org.eclipse.php.internal.core.phar.PharUtil;
import org.eclipse.php.internal.core.phar.digest.Digest;
import org.eclipse.php.internal.core.tar.CBZip2InputStreamForPhar;
import org.eclipse.php.internal.core.tar.GZIPInputStreamForPhar;

public class PharFile {
    private File file;
    private int currentIndex;
    private int manifestLength;
    private int fileNumber;
    private int stubLength;
    private String version;
    private boolean hasSignature = false;
    private boolean hasZlibcompression = false;
    private boolean hasBzipcompression = false;
    private String alias;
    private String metadata;
    private List<PharEntry> pharEntryList = new ArrayList<PharEntry>();
    private Map<String, PharEntry> pharEntryMap = new HashMap<String, PharEntry>();
    private List<Integer> bytesAfterStub;
    private BufferedInputStream bis;
    private PharEntry stubEntry;
    private PharEntry signatureEntry;

    public PharFile(PharFile oldPharFile, File file) throws IOException, PharException {
        this.file = file;
        if (oldPharFile != null && oldPharFile.file.equals(file)) {
            this.copyProperties(oldPharFile);
        } else {
            this.init();
        }
    }

    public PharFile(File file) throws IOException, PharException {
        this(null, file);
    }

    private void copyProperties(PharFile oldPharFile) {
        this.currentIndex = oldPharFile.currentIndex;
        this.manifestLength = oldPharFile.manifestLength;
        this.fileNumber = oldPharFile.fileNumber;
        this.stubLength = oldPharFile.stubLength;
        this.version = oldPharFile.version;
        this.hasSignature = oldPharFile.hasSignature;
        this.hasZlibcompression = oldPharFile.hasZlibcompression;
        this.hasBzipcompression = oldPharFile.hasBzipcompression;
        this.alias = oldPharFile.alias;
        this.metadata = oldPharFile.metadata;
        this.pharEntryList = oldPharFile.pharEntryList;
        this.pharEntryMap = oldPharFile.pharEntryMap;
        this.stubEntry = oldPharFile.stubEntry;
        this.signatureEntry = oldPharFile.signatureEntry;
    }

    protected void init() throws IOException, PharException {
        this.bis = new BufferedInputStream(new FileInputStream(this.file));
        try {
            this.getStub();
            this.getManifest();
            this.getEntries();
        }
        finally {
            this.bis.close();
        }
    }

    protected void getEntries() throws IOException, PharException {
        PharEntry pharEntry;
        byte[] buffer;
        int j = 0;
        while (j < this.fileNumber) {
            buffer = new byte[4];
            pharEntry = new PharEntry();
            this.read(this.bis, buffer);
            int fileNameLength = PharFile.getInt(buffer);
            String fileName = null;
            if (fileNameLength > 0) {
                buffer = new byte[fileNameLength];
                this.read(this.bis, buffer);
                fileName = PharFile.getString(buffer);
                pharEntry.setName(fileName);
                buffer = new byte[4];
            }
            this.read(this.bis, buffer);
            pharEntry.setSizeByte(buffer);
            pharEntry.setSize(PharFile.getInt(buffer));
            this.read(this.bis, buffer);
            pharEntry.setTime(PharFile.getInt(buffer));
            this.read(this.bis, buffer);
            pharEntry.setCsize(PharFile.getInt(buffer));
            this.read(this.bis, buffer);
            pharEntry.setCrcByte(buffer);
            this.read(this.bis, buffer);
            pharEntry.setBitMappedFlag(buffer);
            this.read(this.bis, buffer);
            int metaFileLength = PharFile.getInt(buffer);
            String metaFileData = null;
            if (metaFileLength > 0) {
                buffer = new byte[metaFileLength];
                this.read(this.bis, buffer);
                metaFileData = PharFile.getString(buffer);
                pharEntry.setMetadata(metaFileData);
            }
            this.pharEntryList.add(pharEntry);
            this.pharEntryMap.put(pharEntry.getName(), pharEntry);
            ++j;
        }
        j = 0;
        while (j < this.pharEntryList.size()) {
            pharEntry = this.pharEntryList.get(j);
            if (j == 0) {
                pharEntry.setPosition(this.currentIndex);
            } else {
                pharEntry.setPosition(this.pharEntryList.get(j - 1).getEnd());
            }
            ++j;
        }
        this.stubEntry = new PharEntry();
        this.stubEntry.setName(".phar/stub.php");
        this.stubEntry.setSize(this.stubLength);
        this.stubEntry.setCsize(this.stubLength);
        this.stubEntry.setBitMappedFlag(PharConstants.Default_Entry_Bitmap);
        this.stubEntry.setPosition(0);
        this.pharEntryList.add(this.stubEntry);
        this.pharEntryMap.put(this.stubEntry.getName(), this.stubEntry);
        if (this.hasSignature) {
            this.signatureEntry = new PharEntry();
            this.signatureEntry.setName(".phar/signature.php");
            this.signatureEntry.setBitMappedFlag(PharConstants.Default_Entry_Bitmap);
            int signatureLength = this.bis.available();
            if (this.fileNumber == 0) {
                this.signatureEntry.setPosition(this.currentIndex);
            } else {
                this.signatureEntry.setPosition(this.pharEntryList.get(this.fileNumber - 1).getEnd());
                PharUtil.skip(this.bis, this.pharEntryList.get(this.fileNumber - 1).getEnd() - this.currentIndex);
                signatureLength = this.bis.available();
            }
            if (signatureLength <= 4) {
                this.signatureEntry = null;
                return;
            }
            this.signatureEntry.setSize(signatureLength);
            this.signatureEntry.setCsize(signatureLength);
            if (signatureLength < 24) {
                throw new PharException(Messages.Phar_Signature_Corrupted);
            }
            this.bis.skip(signatureLength - 8);
            buffer = new byte[4];
            this.read(this.bis, buffer);
            boolean found = false;
            for (Digest digest : Digest.DIGEST_MAP.values()) {
                if (!PharUtil.byteArrayEquals(digest.getBitMap(), buffer)) continue;
                if (digest.getDigest().digest().length != signatureLength - 8 || !PharUtil.checkSignature(this.file, digest, this.signatureEntry.getPosition())) {
                    throw new PharException(Messages.Phar_Signature_Corrupted);
                }
                found = true;
                break;
            }
            if (!found) {
                throw new PharException(Messages.Phar_Signature_Unsupported);
            }
            this.read(this.bis, buffer);
            if (!PharUtil.byteArrayEquals(PharConstants.GBMB, buffer)) {
                throw new PharException(Messages.Phar_Signature_End);
            }
            this.pharEntryList.add(this.signatureEntry);
            this.pharEntryMap.put(this.signatureEntry.getName(), this.signatureEntry);
        }
    }

    protected void getManifest() throws IOException, PharException {
        int lineSeparatorLength = 0;
        this.bytesAfterStub.add(this.read(this.bis));
        this.bytesAfterStub.add(this.read(this.bis));
        if (this.bytesAfterStub.get(0) == 13) {
            ++lineSeparatorLength;
            if (this.bytesAfterStub.get(1) == 10) {
                ++lineSeparatorLength;
            }
        } else if (this.bytesAfterStub.get(0) == 10) {
            ++lineSeparatorLength;
            if (this.bytesAfterStub.get(1) == 13) {
                ++lineSeparatorLength;
            }
        }
        this.bytesAfterStub = this.bytesAfterStub.subList(lineSeparatorLength, this.bytesAfterStub.size());
        this.stubLength = this.currentIndex - this.bytesAfterStub.size();
        byte[] buffer = new byte[4];
        int i = 0;
        while (i < buffer.length) {
            if (i < this.bytesAfterStub.size()) {
                buffer[i] = this.bytesAfterStub.get(i).byteValue();
            } else {
                buffer[i] = (byte)this.read(this.bis);
                this.check(buffer[i]);
            }
            ++i;
        }
        this.manifestLength = PharFile.getInt(buffer);
        this.read(this.bis, buffer);
        this.fileNumber = PharFile.getInt(buffer);
        buffer = new byte[2];
        this.read(this.bis, buffer);
        this.version = PharUtil.getVersion(buffer);
        buffer = new byte[4];
        this.read(this.bis, buffer);
        if ((buffer[2] & 1) != 0) {
            this.hasSignature = true;
        }
        if ((buffer[1] & 0x10) != 0) {
            this.hasZlibcompression = true;
        }
        if ((buffer[1] & 0x20) != 0) {
            this.hasBzipcompression = true;
        }
        this.read(this.bis, buffer);
        int aliaslength = PharFile.getInt(buffer);
        if (aliaslength > 0) {
            buffer = new byte[aliaslength];
            this.read(this.bis, buffer);
            this.alias = PharFile.getString(buffer);
            buffer = new byte[4];
        }
        this.read(this.bis, buffer);
        int metadatalength = PharFile.getInt(buffer);
        if (metadatalength > 0) {
            buffer = new byte[metadatalength];
            this.read(this.bis, buffer);
            this.metadata = PharFile.getString(buffer);
        }
    }

    protected void getStub() throws IOException, PharException {
        boolean stubHasBeenFound = false;
        int n = -1;
        int currentByte = -1;
        this.bytesAfterStub = new ArrayList<Integer>();
        while (!(stubHasBeenFound || currentByte != 95 && (n = this.read(this.bis)) == -1)) {
            if (n != 95) continue;
            boolean match = false;
            int j = 1;
            while (j < PharConstants.STUB_ENDS.length && n != -1) {
                n = this.read(this.bis);
                if (n != PharConstants.STUB_ENDS[j]) break;
                if (j == PharConstants.STUB_ENDS.length - 1) {
                    match = true;
                }
                ++j;
            }
            stubHasBeenFound = match;
            if (!match) continue;
            j = 0;
            match = false;
            while (j < PharConstants.STUB_TAIL.length && n != -1) {
                n = this.read(this.bis);
                this.bytesAfterStub.add(n);
                if (n != PharConstants.STUB_TAIL[j]) break;
                if (j == PharConstants.STUB_TAIL.length - 1) {
                    match = true;
                }
                ++j;
            }
            if (!match) continue;
            this.bytesAfterStub.clear();
        }
        if (!stubHasBeenFound) {
            PharUtil.throwPharException(Messages.Phar_No_Stub_End);
        }
    }

    public static String getString(byte[] subBytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < subBytes.length) {
            sb.append((char)subBytes[i]);
            ++i;
        }
        return sb.toString();
    }

    private int read(BufferedInputStream bis, byte[] buffer) throws IOException, PharException {
        int result = bis.read(buffer);
        if (result != buffer.length) {
            PharUtil.throwPharException(Messages.Phar_Corrupted);
        }
        this.currentIndex += result;
        return result;
    }

    private void check(byte b) throws IOException, PharException {
        if (b == -1) {
            PharUtil.throwPharException(Messages.Phar_Corrupted);
        }
    }

    public static int getInt(byte[] subBytes) {
        int result = 0;
        if (subBytes.length > 0) {
            result = PharUtil.getPositive(subBytes[subBytes.length - 1]);
            int i = 0;
            while (i < subBytes.length - 1) {
                result = result * 256 + PharUtil.getPositive(subBytes[subBytes.length - 2 - i]);
                ++i;
            }
        }
        return result;
    }

    private int read(BufferedInputStream bis) throws IOException {
        ++this.currentIndex;
        int result = bis.read();
        return result;
    }

    public void close() throws IOException {
    }

    public PharEntry getEntry(String name) {
        return this.pharEntryMap.get(name);
    }

    public InputStream getInputStream(PharEntry pharEntry) throws IOException {
        BufferedInputStream result = null;
        InputStream is = new PharEntryBufferedRandomInputStream(this.file, pharEntry);
        if (pharEntry.isCompressed()) {
            int ctype = pharEntry.getCompressedType();
            if (2 == ctype) {
                is = new CBZip2InputStreamForPhar(is);
            } else if (1 == ctype) {
                is = new GZIPInputStreamForPhar(is);
            }
        }
        result = new BufferedInputStream(is);
        return result;
    }

    public String getName() {
        return this.file.getPath();
    }

    public List<PharEntry> getPharEntryList() {
        return this.pharEntryList;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public int getManifestLength() {
        return this.manifestLength;
    }

    public void setManifestLength(int manifestLength) {
        this.manifestLength = manifestLength;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public void setFileNumber(int fileNumber) {
        this.fileNumber = fileNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isHasSignature() {
        return this.hasSignature;
    }

    public void setHasSignature(boolean hasSignature) {
        this.hasSignature = hasSignature;
    }

    public boolean isHasZlibcompression() {
        return this.hasZlibcompression;
    }

    public void setHasZlibcompression(boolean hasZlibcompression) {
        this.hasZlibcompression = hasZlibcompression;
    }

    public boolean isHasBzipcompression() {
        return this.hasBzipcompression;
    }

    public void setHasBzipcompression(boolean hasBzipcompression) {
        this.hasBzipcompression = hasBzipcompression;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Map<String, PharEntry> getPharEntryMap() {
        return this.pharEntryMap;
    }

    public void setPharEntryMap(Map<String, PharEntry> pharEntryMap) {
        this.pharEntryMap = pharEntryMap;
    }
}

