/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.ArraySpec;
import org.eclipse.photran.internal.core.analysis.types.DerivedType;
import org.eclipse.photran.internal.core.analysis.types.FunctionType;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.analysis.types.TypeProcessor;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAccessSpecNode;
import org.eclipse.photran.internal.core.parser.ASTArraySpecNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecSeqNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTIntentSpecNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.ISpecificationStmt;
import org.eclipse.photran.internal.core.vpg.EdgeType;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.IVPGNode;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

public class Definition
implements IPhotranSerializable,
Comparable<Definition> {
    private static final long serialVersionUID = 1L;
    protected Classification classification;
    protected PhotranTokenRef tokenRef;
    protected String declaredName;
    protected String canonicalizedName;
    protected String completionText;
    protected Type type;
    protected ArraySpec arraySpec;
    private boolean subprogramArgument = false;
    private boolean parameter = false;
    private boolean typeBoundProcedure = false;
    private boolean renamedTypeBoundProcedure = false;
    private boolean target = false;
    private boolean pointer = false;
    private boolean allocatable = false;
    private boolean intent_in = false;
    private boolean intent_out = false;
    private boolean optional = false;
    private boolean save = false;

    protected Definition() {
    }

    public Definition(String declaredName, PhotranTokenRef tokenRef, Classification classification, Type type) {
        this.classification = classification;
        this.tokenRef = tokenRef;
        this.declaredName = declaredName;
        this.canonicalizedName = this.canonicalize(declaredName);
        this.type = type;
        this.arraySpec = null;
        this.completionText = declaredName;
    }

    protected String canonicalize(String identifier) {
        return identifier.toLowerCase();
    }

    public boolean matches(String canonicalizedName) {
        return canonicalizedName != null && (canonicalizedName.equals(this.canonicalizedName) || this.canonicalizedName.matches(canonicalizedName));
    }

    void markAsSubprogramArgument() {
        this.subprogramArgument = true;
    }

    public boolean isSubprogramArgument() {
        return this.subprogramArgument;
    }

    private boolean isInternal() {
        IASTNode startFrom = this.tokenRef.findToken();
        if (this.isSubprogram()) {
            startFrom = startFrom.findNearestAncestor(ScopingNode.class);
        }
        IASTNode parent = startFrom.getParent();
        while (parent != null) {
            if (parent instanceof ASTModuleNode || parent instanceof ASTSubroutineSubprogramNode || parent instanceof ASTFunctionSubprogramNode || parent instanceof ASTMainProgramNode) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public boolean isInternalSubprogramDefinition() {
        return this.isInternal() && this.isSubprogram();
    }

    public boolean isExternallyVisibleSubprogramDefinition() {
        return !this.isInternal() && this.isSubprogram();
    }

    public boolean isModuleReference() {
        return false;
    }

    public boolean isLocalVariable() {
        return this.classification == Classification.IMPLICIT_LOCAL_VARIABLE || this.classification == Classification.VARIABLE_DECLARATION;
    }

    public boolean isDerivedType() {
        return this.classification == Classification.DERIVED_TYPE;
    }

    public boolean isDerivedTypeComponent() {
        return this.classification == Classification.DERIVED_TYPE_COMPONENT;
    }

    public boolean isSubprogram() {
        return this.classification == Classification.SUBROUTINE || this.classification == Classification.FUNCTION;
    }

    public boolean isModule() {
        return this.classification == Classification.MODULE;
    }

    public boolean isExternal() {
        return this.classification == Classification.EXTERNAL;
    }

    public boolean isImplicitExternalSubprogram() {
        return this.classification == Classification.IMPLICIT_EXTERNAL_SUBPROGRAM;
    }

    public boolean isInterface() {
        return this.classification == Classification.INTERFACE;
    }

    public boolean isRenamedModuleEntity() {
        return this.classification == Classification.RENAMED_MODULE_ENTITY;
    }

    public boolean isModuleEntityBeforeRename() {
        return this.classification == Classification.MODULE_ENTITY_BEFORE_RENAME;
    }

    public boolean isMainProgram() {
        return this.classification == Classification.MAIN_PROGRAM;
    }

    public boolean isIntrinsic() {
        return this.classification == Classification.INTRINSIC;
    }

    public boolean isImplicit() {
        return this.classification == Classification.IMPLICIT_LOCAL_VARIABLE;
    }

    public boolean isNamelist() {
        return this.classification == Classification.NAMELIST;
    }

    public boolean isCommon() {
        return this.classification == Classification.COMMON_BLOCK;
    }

    public boolean isBlockData() {
        return this.classification == Classification.BLOCK_DATA;
    }

    public Classification getClassification() {
        return this.classification;
    }

    void setType(ASTTypeSpecNode typeSpecNode) {
        this.type = Type.parse(typeSpecNode);
    }

    void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getDeclaredName() {
        return this.declaredName;
    }

    public String getCanonicalizedName() {
        return this.canonicalizedName;
    }

    public void setCompletionText(String completionText) {
        this.completionText = completionText;
    }

    public String getCompletionText() {
        return this.completionText;
    }

    public String describeClassification() {
        StringBuilder result = new StringBuilder();
        result.append(this.classification.toString());
        if (!this.type.equals(Type.VOID) && !(this.type instanceof FunctionType)) {
            result.append(" - ");
            result.append(this.type);
            if (this.arraySpec != null) {
                result.append(this.arraySpec);
            }
        }
        return result.toString();
    }

    public PhotranTokenRef getTokenRef() {
        return this.tokenRef;
    }

    void setArraySpec(ASTArraySpecNode arraySpecNode) {
        if (arraySpecNode != null) {
            this.arraySpec = new ArraySpec(arraySpecNode);
        }
    }

    public ArraySpec getArraySpec() {
        return this.arraySpec;
    }

    public boolean isArray() {
        return this.arraySpec != null;
    }

    void setAttributes(IASTListNode<ASTAttrSpecSeqNode> listNode, ScopingNode setInScope) {
        if (listNode == null) {
            return;
        }
        int i = 0;
        while (i < listNode.size()) {
            this.setAttribute(((ASTAttrSpecSeqNode)listNode.get(i)).getAttrSpec(), setInScope);
            ++i;
        }
    }

    private void setAttribute(ASTAttrSpecNode attrSpec, ScopingNode setInScope) {
        ASTArraySpecNode arraySpec = attrSpec.getArraySpec();
        ASTAccessSpecNode accessSpec = attrSpec.getAccessSpec();
        if (arraySpec != null) {
            this.setArraySpec(arraySpec);
        } else if (accessSpec != null) {
            this.setVisibility(accessSpec, setInScope);
        } else if (attrSpec.isParameter()) {
            this.setParameter();
        } else if (attrSpec.isPointer()) {
            this.setPointer();
        } else if (attrSpec.isTarget()) {
            this.setTarget();
        } else if (attrSpec.isAllocatable()) {
            this.setAllocatable();
        } else if (attrSpec.isIntent()) {
            this.setIntent(attrSpec.getIntentSpec());
        } else if (attrSpec.isOptional()) {
            this.setOptional();
        } else if (attrSpec.isSave()) {
            this.setSave();
        }
    }

    void setVisibility(ASTAccessSpecNode accessSpec, ScopingNode setInScope) {
        PhotranVPG.getProvider().markDefinitionVisibilityInScope(this.tokenRef, setInScope, accessSpec.isPrivate() ? Visibility.PRIVATE : Visibility.PUBLIC);
    }

    public boolean isParameter() {
        return this.parameter;
    }

    void setParameter() {
        this.parameter = true;
    }

    public boolean isPointer() {
        return this.pointer;
    }

    void setPointer() {
        this.pointer = true;
    }

    public boolean isTarget() {
        return this.target;
    }

    void setTarget() {
        this.target = true;
    }

    public boolean isAllocatable() {
        return this.allocatable;
    }

    void setAllocatable() {
        this.allocatable = true;
    }

    public boolean isOptional() {
        return this.optional;
    }

    void setOptional() {
        this.optional = true;
    }

    public boolean isSave() {
        return this.save;
    }

    void setSave() {
        this.save = true;
    }

    public boolean isIntentIn() {
        return this.intent_in;
    }

    public boolean isIntentOut() {
        return this.intent_out;
    }

    void setIntent(ASTIntentSpecNode intent) {
        if (intent.isIntentIn() || intent.isIntentInOut()) {
            this.intent_in = true;
        }
        if (intent.isIntentOut() || intent.isIntentInOut()) {
            this.intent_out = true;
        }
    }

    void markAsTypeBoundProcedure(boolean renamed) {
        this.typeBoundProcedure = true;
        this.renamedTypeBoundProcedure = renamed;
    }

    public boolean isTypeBoundProcedure() {
        return this.typeBoundProcedure;
    }

    public boolean isRenamedTypeBoundProcedure() {
        return this.renamedTypeBoundProcedure;
    }

    public IMarker createMarker() {
        Token token;
        block3: {
            try {
                token = this.tokenRef.findTokenOrReturnNull();
                if (token != null && token.getPhysicalFile().getIFile() != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        IMarker marker = token.getPhysicalFile().getIFile().createMarker("org.eclipse.core.resources.textmarker");
        marker.setAttribute("charStart", token.getFileOffset());
        marker.setAttribute("charEnd", token.getFileOffset() + token.getLength());
        return marker;
    }

    public Set<PhotranTokenRef> findAllReferences(boolean shouldBindInterfacesAndExternals) {
        if (this.isImpliedFunctionResultVar() && this.findEnclosingFunctionDefinition() != null) {
            return this.findAllReferencesToEnclosingSubprogramInstead(shouldBindInterfacesAndExternals);
        }
        return this.internalFindAllReferences(shouldBindInterfacesAndExternals);
    }

    private Set<PhotranTokenRef> findAllReferencesToEnclosingSubprogramInstead(boolean aggressive) {
        Definition fnDef = this.findEnclosingFunctionDefinition();
        Set<PhotranTokenRef> result = fnDef.internalFindAllReferences(aggressive);
        result.add(fnDef.getTokenRef());
        result.remove(this.getTokenRef());
        return result;
    }

    private boolean isImpliedFunctionResultVar() {
        if (!this.isLocalVariable()) {
            return false;
        }
        ASTFunctionSubprogramNode fn = this.findEnclosingFunction();
        if (fn != null && !fn.getFunctionStmt().hasResultClause()) {
            Definition fnDef = this.findEnclosingFunctionDefinition();
            return this.getCanonicalizedName().equals(fnDef.getCanonicalizedName());
        }
        return false;
    }

    private ASTFunctionSubprogramNode findEnclosingFunction() {
        return this.getTokenRef().findToken().findNearestAncestor(ASTFunctionSubprogramNode.class);
    }

    private Definition findEnclosingFunctionDefinition() {
        ASTFunctionSubprogramNode fn = this.findEnclosingFunction();
        return fn == null ? null : PhotranVPG.getInstance().getDefinitionFor(fn.getRepresentativeToken());
    }

    private Set<PhotranTokenRef> internalFindAllReferences(boolean shouldBindInterfacesAndExternals) {
        if ((this.isSubprogram() || this.isExternal()) && shouldBindInterfacesAndExternals) {
            return this.internalFindAllReferencesToSubprogramAggressively();
        }
        return this.findAllImmediateReferences();
    }

    private Set<PhotranTokenRef> findAllImmediateReferences() {
        TreeSet<PhotranTokenRef> result = new TreeSet<PhotranTokenRef>();
        this.addImmediateBindings(result);
        if (this.isFunction()) {
            this.matchFunctionAndImpliedResultVariable(result);
        }
        result.remove(this.getTokenRef());
        return result;
    }

    private void matchFunctionAndImpliedResultVariable(Collection<PhotranTokenRef> result) {
        try {
            ASTFunctionSubprogramNode fn = this.findEnclosingFunction();
            if (fn == null || fn.getFunctionStmt().hasResultClause()) {
                return;
            }
            for (Definition def : fn.getAllDefinitions()) {
                if (def == null || !def.getCanonicalizedName().equals(this.getCanonicalizedName())) continue;
                result.add(def.getTokenRef());
                result.addAll(def.internalFindAllReferences(false));
            }
        }
        catch (Throwable throwable) {}
    }

    private boolean isFunction() {
        return this.getClassification().equals((Object)Classification.FUNCTION);
    }

    private void addImmediateBindings(Collection<PhotranTokenRef> result) {
        result.add(this.getTokenRef());
        for (IVPGNode iVPGNode : this.tokenRef.followIncoming(EdgeType.BINDING_EDGE_TYPE)) {
            result.add((PhotranTokenRef)iVPGNode);
        }
    }

    private Set<PhotranTokenRef> internalFindAllReferencesToSubprogramAggressively() {
        Collection<Definition> subprogramDefinitions;
        assert (this.isSubprogram() || this.isExternal());
        if (this.isInInterfaceBlock()) {
            subprogramDefinitions = this.resolveInterfaceBinding();
        } else if (this.isInExternalStmt()) {
            subprogramDefinitions = this.resolveExternalBinding();
        } else if (this.isExternallyVisibleSubprogramDefinition()) {
            subprogramDefinitions = this.findAllSimilarlyNamedExternalSubprograms();
        } else {
            return this.findAllImmediateReferences();
        }
        TreeSet<PhotranTokenRef> result = new TreeSet<PhotranTokenRef>();
        result.addAll(this.findAllImmediateReferences());
        for (Definition subprogram : subprogramDefinitions) {
            result.addAll(subprogram.internalFindAllReferencesToSubprogIncludingInterfacesAndExternalStmts());
        }
        result.remove(this.getTokenRef());
        return result;
    }

    private Set<PhotranTokenRef> internalFindAllReferencesToSubprogIncludingInterfacesAndExternalStmts() {
        assert (this.isExternallyVisibleSubprogramDefinition());
        TreeSet<PhotranTokenRef> result = new TreeSet<PhotranTokenRef>();
        this.addExternalSubprogramDefinitions(result);
        this.addInterfaceDecls(result);
        this.addExternalStmts(result);
        return result;
    }

    private void addExternalSubprogramDefinitions(Collection<PhotranTokenRef> result) {
        for (Definition externalSubprogDef : this.findAllSimilarlyNamedExternalSubprograms()) {
            result.add(externalSubprogDef.getTokenRef());
            result.addAll(externalSubprogDef.internalFindAllReferences(false));
        }
    }

    private void addInterfaceDecls(Collection<PhotranTokenRef> result) {
        for (Definition interfaceDef : this.findMatchingDeclarationsInInterfaces()) {
            result.add(interfaceDef.getTokenRef());
            result.addAll(interfaceDef.internalFindAllReferences(false));
        }
    }

    private void addExternalStmts(Collection<PhotranTokenRef> result) {
        for (Definition externalDef : this.findMatchingDeclarationsInExternalStmts()) {
            result.add(externalDef.getTokenRef());
            result.addAll(externalDef.internalFindAllReferences(false));
        }
    }

    public boolean isExternalSubprogramReferenceInInterfaceBlock() {
        ScopingNode scopeOfThisDef;
        if (!this.isInInterfaceBlock()) {
            return false;
        }
        Token token = this.getTokenRef().findToken();
        HashSet<Definition> result = this.collectResolutions(token, scopeOfThisDef = token.getEnclosingScope());
        return !this.resolvesToSubprogramArgument(result);
    }

    public Collection<Definition> resolveInterfaceBinding() {
        if (!this.isInInterfaceBlock()) {
            return Collections.emptySet();
        }
        Token token = this.getTokenRef().findToken();
        ScopingNode scopeOfThisDef = token.getEnclosingScope();
        ScopingNode parentScope = scopeOfThisDef.getEnclosingScope();
        HashSet<Definition> result = this.collectResolutions(token, scopeOfThisDef);
        if (this.resolvesToSubprogramArgument(result)) {
            return Collections.emptyList();
        }
        if (this.needToResolveInParentScope(result)) {
            result = this.collectResolutions(token, parentScope);
        }
        result.addAll(this.collectMatchingExternalSubprograms(token));
        return result;
    }

    public boolean isInInterfaceBlock() {
        Token tok = this.getTokenRef().findTokenOrReturnNull();
        return tok != null && tok.findNearestAncestor(ASTInterfaceBlockNode.class) != null;
    }

    private HashSet<Definition> collectResolutions(Token token, ScopingNode scope) {
        HashSet<Definition> result = new HashSet<Definition>();
        for (PhotranTokenRef d : scope.manuallyResolve(new Token.FakeToken(token, token.getText()))) {
            Definition def = PhotranVPG.getInstance().getDefinitionFor(d);
            if (def == null || (!def.isSubprogram() || def.isInInterfaceBlock()) && !def.isSubprogramArgument()) continue;
            result.add(def);
        }
        return result;
    }

    private boolean resolvesToSubprogramArgument(Set<Definition> listOfDefs) {
        for (Definition def : listOfDefs) {
            if (def == null || !def.isSubprogramArgument()) continue;
            return true;
        }
        return false;
    }

    private boolean needToResolveInParentScope(HashSet<Definition> result) {
        return result.size() < 2;
    }

    private ArrayList<Definition> collectMatchingExternalSubprograms(Token token) {
        return PhotranVPG.getInstance().findAllExternalSubprogramsNamed(token.getText());
    }

    public Collection<Definition> findAllSimilarlyNamedExternalSubprograms() {
        return PhotranVPG.getInstance().findAllExternalSubprogramsNamed(this.canonicalizedName);
    }

    public Collection<Definition> resolveExternalBinding() {
        if (!this.isInExternalStmt()) {
            return Collections.emptySet();
        }
        Token token = this.getTokenRef().findToken();
        ScopingNode scopeOfThisDef = token.getEnclosingScope();
        ScopingNode parentScope = scopeOfThisDef.getEnclosingScope();
        HashSet<Definition> result = this.collectExternalResolutions(token, scopeOfThisDef);
        if (this.resolvesToSubprogramArgument(result)) {
            return Collections.emptyList();
        }
        if (this.needToResolveInParentScope(result)) {
            result = this.collectResolutions(token, parentScope);
        }
        result.addAll(this.collectMatchingExternalSubprograms(token));
        return result;
    }

    public boolean isInExternalStmt() {
        Token tok = this.getTokenRef().findTokenOrReturnNull();
        return tok != null && tok.findNearestAncestor(ASTExternalStmtNode.class) != null;
    }

    private HashSet<Definition> collectExternalResolutions(Token token, ScopingNode scope) {
        HashSet<Definition> result = new HashSet<Definition>();
        for (PhotranTokenRef d : scope.manuallyResolve(new Token.FakeToken(token, token.getText()))) {
            Definition def = PhotranVPG.getInstance().getDefinitionFor(d);
            if (def == null || (!def.isSubprogram() || def.isInInterfaceBlock()) && !def.isSubprogramArgument()) continue;
            result.add(def);
        }
        return result;
    }

    public Collection<Definition> findMatchingDeclarationsInInterfaces() {
        if (this.isExternallyVisibleSubprogramDefinition()) {
            return PhotranVPG.getInstance().findAllDeclarationsInInterfacesForExternalSubprogram(this.canonicalizedName);
        }
        return Collections.emptySet();
    }

    public Collection<Definition> findMatchingDeclarationsInExternalStmts() {
        return PhotranVPG.getInstance().findAllDeclarationsInExternalStmts(this.canonicalizedName);
    }

    public String toString() {
        return String.valueOf(this.canonicalizedName) + " - " + (Object)((Object)this.classification) + (this.subprogramArgument ? " (Subprogram Argument)" : "") + " (" + this.tokenRef.getFilename() + ", offset " + this.tokenRef.getOffset() + ")";
    }

    public boolean equals(Object other) {
        if (!(other instanceof Definition)) {
            return false;
        }
        Definition o = (Definition)other;
        return this.equals(this.arraySpec, o.arraySpec) && this.equals(this.canonicalizedName, o.canonicalizedName) && this.equals((Object)this.classification, (Object)o.classification) && this.parameter == o.parameter && this.subprogramArgument == o.subprogramArgument && this.equals(this.tokenRef, o.tokenRef) && this.equals(this.type, o.type);
    }

    private boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode(this.arraySpec) + this.hashCode(this.canonicalizedName) + this.hashCode((Object)this.classification) + (this.parameter ? 1 : 0) + (this.subprogramArgument ? 1 : 0) + this.hashCode(this.tokenRef) + 0;
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    @Override
    public int compareTo(Definition o) {
        return this.canonicalizedName.compareTo(o.canonicalizedName);
    }

    public String describe() {
        String commentsBefore = "\n";
        String name = this.getCanonicalizedName();
        String commentsAfter = "";
        boolean isScopingUnit = false;
        Token tok = this.tokenRef.findTokenOrReturnNull();
        if (tok != null) {
            IASTNode headerStmt;
            ScopingNode localScope;
            if (!name.equals("(anonymous)")) {
                name = tok.getText();
            }
            if ((localScope = tok.getLocalScope()) != null && (headerStmt = (isScopingUnit = localScope != tok.getEnclosingScope()) ? localScope.getHeaderStmt() : this.findEnclosingSpecificationStmt(tok)) != null) {
                Token after;
                Token first = headerStmt.findFirstToken();
                Token last = headerStmt.findLastToken();
                if (first != null) {
                    commentsBefore = first.getWhiteBefore();
                }
                if (last != null) {
                    commentsAfter = last.getWhiteAfter();
                }
                if ((after = this.findFirstTokenAfter(last, localScope)) != null && !this.startsWithBlankLine(after.getWhiteBefore())) {
                    commentsAfter = String.valueOf(commentsAfter) + after.getWhiteBefore();
                }
            }
        }
        return String.valueOf(commentsBefore) + this.describe(name) + "\n" + commentsAfter;
    }

    private boolean startsWithBlankLine(String string) {
        while (string.startsWith(" ") || string.startsWith("\t")) {
            string = string.substring(1);
        }
        return string.startsWith("\r") || string.startsWith("\n");
    }

    private Token findFirstTokenAfter(Token target, ScopingNode localScope) {
        class TokenFinder
        extends GenericASTVisitor {
            private Token lastToken = null;
            private Token result = null;
            private final /* synthetic */ Token val$target;

            TokenFinder(Token token) {
                this.val$target = token;
            }

            @Override
            public void visitToken(Token thisToken) {
                if (this.lastToken == this.val$target) {
                    this.result = thisToken;
                }
                this.lastToken = thisToken;
            }
        }
        TokenFinder t = new TokenFinder(target);
        localScope.accept(t);
        return t.result;
    }

    private IASTNode findEnclosingSpecificationStmt(Token tok) {
        IASTNode candidate = tok.getParent();
        while (candidate != null) {
            if (candidate instanceof ISpecificationStmt) {
                return candidate;
            }
            candidate = candidate.getParent();
        }
        return null;
    }

    private String describe(String name) {
        StringBuilder sb = new StringBuilder();
        switch (this.classification) {
            case VARIABLE_DECLARATION: {
                sb.append("! ");
                sb.append(this.describeClassification());
                sb.append('\n');
                sb.append(this.describeType());
                sb.append(":: ");
                sb.append(name);
                break;
            }
            case IMPLICIT_LOCAL_VARIABLE: {
                sb.append("! ");
                sb.append(this.describeClassification());
                sb.append('\n');
                sb.append(this.describeType());
                sb.append(":: ");
                sb.append(name);
                break;
            }
            case SUBROUTINE: {
                sb.append("subroutine ");
                sb.append(name);
                break;
            }
            case FUNCTION: {
                sb.append("function ");
                sb.append(name);
                break;
            }
            case INTERFACE: {
                sb.append("interface ");
                sb.append(name);
                break;
            }
            case MODULE: {
                sb.append("module ");
                sb.append(name);
                break;
            }
            case DERIVED_TYPE: {
                sb.append("type :: ");
                sb.append(name);
                break;
            }
            default: {
                sb.append("! ");
                sb.append(this.describeClassification());
                sb.append('\n');
                sb.append(name);
            }
        }
        return sb.toString();
    }

    private String describeType() {
        return this.type.processUsing(new TypeProcessor<String>(){

            @Override
            public String ifCharacter(Type type) {
                return "character ";
            }

            @Override
            public String ifComplex(Type type) {
                return "complex ";
            }

            @Override
            public String ifDerivedType(String derivedTypeName, DerivedType type) {
                return "type(" + derivedTypeName + ") ";
            }

            @Override
            public String ifDoublePrecision(Type type) {
                return "double precision ";
            }

            @Override
            public String ifFunctionType(String name, FunctionType functionType) {
                return "function ";
            }

            @Override
            public String ifInteger(Type type) {
                return "integer ";
            }

            @Override
            public String ifLogical(Type type) {
                return "logical ";
            }

            @Override
            public String ifReal(Type type) {
                return "real ";
            }

            @Override
            public String ifUnclassified(Type type) {
                return "";
            }

            @Override
            public String ifUnknown(Type type) {
                return "";
            }
        });
    }

    public static Definition readFrom(InputStream in) throws IOException {
        Definition result = new Definition();
        result.classification = Classification.values()[(Integer)PhotranVPGSerializer.deserialize(in)];
        result.tokenRef = (PhotranTokenRef)PhotranVPGSerializer.deserialize(in);
        result.declaredName = (String)PhotranVPGSerializer.deserialize(in);
        result.canonicalizedName = PhotranVPG.canonicalizeIdentifier(result.declaredName);
        result.type = (Type)PhotranVPGSerializer.deserialize(in);
        result.arraySpec = (ArraySpec)PhotranVPGSerializer.deserialize(in);
        result.subprogramArgument = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.parameter = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.typeBoundProcedure = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.renamedTypeBoundProcedure = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.pointer = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.target = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.allocatable = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.intent_in = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.intent_out = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.optional = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.save = (Boolean)PhotranVPGSerializer.deserialize(in);
        result.completionText = (String)PhotranVPGSerializer.deserialize(in);
        return result;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.classification.ordinal(), out);
        PhotranVPGSerializer.serialize(this.tokenRef, out);
        PhotranVPGSerializer.serialize(this.declaredName, out);
        PhotranVPGSerializer.serialize(this.type, out);
        PhotranVPGSerializer.serialize(this.arraySpec, out);
        PhotranVPGSerializer.serialize(this.subprogramArgument, out);
        PhotranVPGSerializer.serialize(this.parameter, out);
        PhotranVPGSerializer.serialize(this.typeBoundProcedure, out);
        PhotranVPGSerializer.serialize(this.renamedTypeBoundProcedure, out);
        PhotranVPGSerializer.serialize(this.pointer, out);
        PhotranVPGSerializer.serialize(this.target, out);
        PhotranVPGSerializer.serialize(this.allocatable, out);
        PhotranVPGSerializer.serialize(this.intent_in, out);
        PhotranVPGSerializer.serialize(this.intent_out, out);
        PhotranVPGSerializer.serialize(this.optional, out);
        PhotranVPGSerializer.serialize(this.save, out);
        PhotranVPGSerializer.serialize(this.completionText, out);
    }

    @Override
    public char getSerializationCode() {
        return 'D';
    }

    public static enum Classification {
        BLOCK_DATA,
        COMMON_BLOCK,
        DERIVED_TYPE,
        DERIVED_TYPE_COMPONENT,
        DO,
        ENTRY,
        EXTERNAL,
        FORALL,
        FUNCTION,
        IMPLICIT_LOCAL_VARIABLE,
        IF,
        INTERFACE,
        INTRINSIC,
        MAIN_PROGRAM,
        MODULE,
        MODULE_ENTITY_BEFORE_RENAME,
        NAMELIST,
        RENAMED_MODULE_ENTITY,
        SUBROUTINE,
        SELECT,
        VARIABLE_DECLARATION{

            @Override
            public String toString() {
                return "Local variable";
            }
        }
        ,
        WHERE,
        ENUMERATOR,
        IMPLICIT_EXTERNAL_SUBPROGRAM;


        public String toString() {
            String name = super.toString().replaceAll("_", " ");
            return String.valueOf(name.charAt(0)) + name.substring(1).toLowerCase();
        }
    }

    public static enum Visibility {
        PUBLIC,
        PRIVATE;


        public String toString() {
            String name = super.toString().replaceAll("_", " ");
            return String.valueOf(name.charAt(0)) + name.substring(1).toLowerCase();
        }
    }
}

