/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.DefinitionCollector;
import org.eclipse.photran.internal.core.analysis.binding.DerivedTypeCollector;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpecCollector;
import org.eclipse.photran.internal.core.analysis.binding.ModuleLoader;
import org.eclipse.photran.internal.core.analysis.binding.PrivateCollector;
import org.eclipse.photran.internal.core.analysis.binding.ReferenceCollector;
import org.eclipse.photran.internal.core.analysis.binding.SpecificationCollector;
import org.eclipse.photran.internal.core.analysis.binding.SubprogramTypeCollector;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGWriter;

public class Binder {
    private static Map<Class<?>, Long> avgTimes = new HashMap();
    private static Map<Class<?>, Long> counts = new HashMap();
    private static Map<Class<?>, Long> maxTimes = new HashMap();
    private static Map<Class<?>, String> maxFiles = new HashMap();

    private Binder() {
    }

    public static void bind(IFortranAST ast, IFile file) {
        PhotranVPGWriter vpg = PhotranVPG.getProvider();
        String filename = file.getName();
        StringBuilder sb = new StringBuilder("  - Binder#bind: ");
        long start = System.currentTimeMillis();
        ast.accept(new ImplicitSpecCollector());
        Binder.logTime(start, ImplicitSpecCollector.class, filename);
        start = System.currentTimeMillis();
        ast.accept(new PrivateCollector());
        Binder.logTime(start, PrivateCollector.class, filename);
        start = System.currentTimeMillis();
        ast.accept(new DefinitionCollector(file));
        Binder.logTime(start, DefinitionCollector.class, filename);
        start = System.currentTimeMillis();
        ast.accept(new SpecificationCollector());
        Binder.logTime(start, SpecificationCollector.class, filename);
        start = System.currentTimeMillis();
        ast.accept(new SubprogramTypeCollector());
        Binder.logTime(start, SubprogramTypeCollector.class, filename);
        start = System.currentTimeMillis();
        ast.accept(new DerivedTypeCollector());
        Binder.logTime(start, DerivedTypeCollector.class, filename);
        start = System.currentTimeMillis();
        ast.accept(new ModuleLoader(file));
        Binder.logTime(start, ModuleLoader.class, filename);
        start = System.currentTimeMillis();
        vpg.enableDefinitionCaching();
        ast.accept(new ReferenceCollector());
        vpg.disableDefinitionCaching();
        Binder.logTime(start, ReferenceCollector.class, filename);
        PhotranVPG.getInstance().debug(sb.toString(), "");
    }

    private static void logTime(long start, Class<?> clazz, String filename) {
        long oldMaxTime;
        long elapsed = System.currentTimeMillis() - start;
        long oldCount = counts.containsKey(clazz) ? counts.get(clazz) : 0L;
        long oldAvgTime = avgTimes.containsKey(clazz) ? avgTimes.get(clazz) : 0L;
        long newAvgTime = (oldAvgTime * oldCount + elapsed) / (oldCount + 1L);
        counts.put(clazz, oldCount + 1L);
        avgTimes.put(clazz, newAvgTime);
        long l = oldMaxTime = maxTimes.containsKey(clazz) ? maxTimes.get(clazz) : 0L;
        if (elapsed > oldMaxTime) {
            maxTimes.put(clazz, elapsed);
            maxFiles.put(clazz, filename);
        }
    }

    public static long getAvgTime(Class<?> clazz) {
        return avgTimes.containsKey(clazz) ? avgTimes.get(clazz) : 0L;
    }

    public static void printStatisticsOn(PrintStream ps) {
        ps.println("Name Binding Analysis Statistics:");
        ps.println();
        ps.println("    Average Times:");
        for (Class<?> clazz : avgTimes.keySet()) {
            ps.println("        " + clazz.getSimpleName() + ": " + avgTimes.get(clazz) + " ms");
        }
        ps.println();
        ps.println("    Maximum Times:");
        for (Class<?> clazz : maxTimes.keySet()) {
            ps.println("        " + clazz.getSimpleName() + ": " + maxTimes.get(clazz) + " ms (" + maxFiles.get(clazz) + ")");
        }
    }

    public static void resetStatistics() {
        counts.clear();
        avgTimes.clear();
    }
}

