/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceSpecificationUtil {
    public static String getCustomLabel(InstanceSpecification instance, Collection<String> maskValues) {
        StringBuffer buffer = new StringBuffer();
        if (maskValues.contains("name")) {
            if (instance.getName() != null) {
                buffer.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)instance));
            } else {
                buffer.append(NamedElementUtil.getDefaultNameWithIncrement((EObject)instance));
            }
        }
        if (maskValues.contains("type") && !InstanceSpecificationUtil.getTypesAsString(instance).equals("")) {
            buffer.append(": ");
            buffer.append(InstanceSpecificationUtil.getTypesAsString(instance));
        }
        if (buffer.length() == 0) {
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private static String getTypesAsString(InstanceSpecification instance) {
        StringBuffer typeString = new StringBuffer();
        if (instance != null) {
            Iterator classifierIterator = instance.getClassifiers().iterator();
            boolean firstParameter = true;
            while (classifierIterator.hasNext()) {
                Classifier classifier = (Classifier)classifierIterator.next();
                String classifierName = NamedElementUtil.getName((NamedElement)classifier);
                if (classifierName == null || "".equals(classifierName.trim())) continue;
                if (!firstParameter) {
                    typeString.append(", ");
                }
                typeString.append(classifierName);
                firstParameter = false;
            }
        }
        return typeString.toString();
    }
}

