/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.commands.PreserveAnchorsPositionCommand;
import org.eclipse.papyrus.uml.diagram.common.draw2d.anchors.LifelineAnchor;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CommentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomMessageDeleteEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DestructionOccurrenceSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageAsyncEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDCustomInteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OldCustomInteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionCompartmentXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineHeadImpactLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDLifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.locator.OLDTimeMarkElementPositionLocator;
import org.eclipse.papyrus.uml.diagram.sequence.locator.StateInvariantLocator;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.ElementIconUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineModelChildrenHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineResizeHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OperandBoundsComputeHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class OLDLifelineEditPart
extends LifelineEditPart {
    private boolean inlineMode;
    private NotificationHelper notifier = null;
    private LayoutEditPolicy inlineModeLayoutRole = this.createLayoutEditPolicy();
    private LayoutEditPolicy normalModeLayoutRole = new OLDLifelineXYLayoutEditPolicy();
    private DragDropEditPolicy dragDropEditPolicy = new DragDropEditPolicy();
    private int oldNameContainerHeight = 0;

    public static List<Property> getProperties(Lifeline lifeline) {
        StructuredClassifier structuredClassifier;
        Type type;
        ConnectableElement represents;
        if (lifeline != null && (represents = lifeline.getRepresents()) != null && (type = represents.getType()) instanceof StructuredClassifier && !(structuredClassifier = (StructuredClassifier)type).getAllAttributes().isEmpty()) {
            return new ArrayList<Property>((Collection<Property>)((StructuredClassifier)type).getAllAttributes());
        }
        return null;
    }

    public OLDLifelineEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof TimeConstraintEditPart) {
            OLDTimeMarkElementPositionLocator locator = new OLDTimeMarkElementPositionLocator(this.getMainFigure(), 0);
            locator.setEditPart(childEditPart);
            this.getBorderedFigure().getBorderItemContainer().add(((TimeConstraintEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof TimeObservationEditPart) {
            OLDTimeMarkElementPositionLocator locator = new OLDTimeMarkElementPositionLocator(this.getMainFigure(), 0);
            locator.setEditPart(childEditPart);
            this.getBorderedFigure().getBorderItemContainer().add(((TimeObservationEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof DurationConstraintEditPart) {
            OLDTimeMarkElementPositionLocator locator = new OLDTimeMarkElementPositionLocator(this.getMainFigure(), 0);
            locator.setEditPart(childEditPart);
            this.getBorderedFigure().getBorderItemContainer().add(((DurationConstraintEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof StateInvariantEditPart) {
            StateInvariantLocator locator = new StateInvariantLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((StateInvariantEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    private void configure(boolean inlineMode, boolean refresh) {
        this.getPrimaryShape().getFigureLifelineDotLineFigure().configure(inlineMode, LifelineEditPartUtil.getInnerConnectableElementList(this).size());
        if (this.inlineMode != inlineMode) {
            this.inlineMode = inlineMode;
            if (inlineMode) {
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.inlineModeLayoutRole);
                this.removeEditPolicy("DragDropPolicy");
            } else {
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.normalModeLayoutRole);
                this.installEditPolicy("DragDropPolicy", (EditPolicy)this.dragDropEditPolicy);
            }
            if (refresh) {
                this.refreshVisuals();
            }
        }
    }

    private boolean containsChildFigure(IFigure parent, int x, int y) {
        if (parent == null) {
            return false;
        }
        Map visualPartMap = this.getViewer().getVisualPartMap();
        List figures = parent.getChildren();
        Point pt = new Point(x, y);
        parent.translateFromParent((Translatable)pt);
        int i = figures.size();
        while (i > 0) {
            Object object;
            IFigure child;
            if (!(child = (IFigure)figures.get(--i)).isVisible()) continue;
            if (this.containsChildFigure(child, pt.x, pt.y)) {
                return true;
            }
            if (!visualPartMap.containsKey(child) || !((object = visualPartMap.get(child)) instanceof LifelineEditPart ? ((LifelineEditPart)((Object)object)).getPrimaryShape().containsPoint(pt) : child.containsPoint(pt))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new LifelineSelectionEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new LifelineMessageCreateHelper.ComponentEditPolicyEx());
        this.installEditPolicy("MaskManagedLabelPolicy", (EditPolicy)new LifelineLabelEditPolicy());
        this.installEditPolicy("HeadImpactLayoutEditPolicy", (EditPolicy)new LifelineHeadImpactLayoutEditPolicy());
    }

    @Override
    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case "StateInvariant_Shape": 
                    case "TimeObservation_Shape": 
                    case "DurationConstraint_Shape": 
                    case "TimeConstraint_Shape": {
                        return new BorderItemResizableEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            public org.eclipse.gef.commands.Command getCommand(Request request) {
                org.eclipse.gef.commands.Command command = null;
                if ("move children".equals(request.getType())) {
                    command = this.getMoveChildrenCommand(request);
                }
                if ("resize children".equals(request.getType()) && request instanceof ChangeBoundsRequest) {
                    command = this.getMoveResizeCommand((ChangeBoundsRequest)request);
                }
                if (command != null) {
                    return command;
                }
                return super.getCommand(request);
            }

            protected org.eclipse.gef.commands.Command getOrphanChildrenCommand(Request request) {
                return UnexecutableCommand.INSTANCE;
            }

            protected org.eclipse.gef.commands.Command getCreateCommand(CreateRequest request) {
                if (request instanceof CreateViewRequest) {
                    CreateViewRequest req = (CreateViewRequest)request;
                    for (CreateViewRequest.ViewDescriptor viewDescriptor : req.getViewDescriptors()) {
                        String semanticHint = viewDescriptor.getSemanticHint();
                        if (UMLVisualIDRegistry.getType("Lifeline_Shape").equals(semanticHint)) continue;
                        return UnexecutableCommand.INSTANCE;
                    }
                }
                return null;
            }

            protected org.eclipse.gef.commands.Command getMoveChildrenCommand(Request request) {
                if (request instanceof ChangeBoundsRequest) {
                    return this.getMoveResizeCommand((ChangeBoundsRequest)request);
                }
                return null;
            }

            private org.eclipse.gef.commands.Command getMoveResizeCommand(ChangeBoundsRequest request) {
                List changeEditParts = request.getEditParts();
                if (changeEditParts != null && changeEditParts.size() > 0) {
                    TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                    CompositeTransactionalCommand composite = new CompositeTransactionalCommand(editingDomain, null);
                    LifelineEditPart parent = (LifelineEditPart)this.getHost();
                    LifelineDotLineCustomFigure parentFig = (LifelineDotLineCustomFigure)parent.getContentPane();
                    Rectangle parentBounds = parentFig.getBounds();
                    for (Object o : changeEditParts) {
                        org.eclipse.gef.commands.Command cmd;
                        if (!(o instanceof LifelineEditPart)) continue;
                        LifelineEditPart child = (LifelineEditPart)((Object)o);
                        IFigure childFig = child.getFigure();
                        Rectangle newBounds = childFig.getBounds().getCopy();
                        Rectangle childConstraint = (Rectangle)parentFig.getLayoutManager().getConstraint(childFig);
                        newBounds.setLocation(childConstraint.getLocation().getCopy());
                        newBounds.translate(request.getMoveDelta());
                        if (!request.getType().equals("move children")) {
                            newBounds.resize(request.getSizeDelta());
                        }
                        if (newBounds.x < 0) {
                            newBounds.width += newBounds.x;
                            newBounds.x = 0;
                        }
                        if (newBounds.x + newBounds.width > parentBounds.width) {
                            newBounds.width = parentBounds.width - newBounds.x;
                        }
                        SetBoundsCommand boundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)((View)child.getModel())), newBounds);
                        composite.add((IUndoableOperation)boundsCommand);
                        composite.add((IUndoableOperation)LifelineResizeHelper.createManualLabelSizeCommand(child));
                        if (request.getType().equals("move children")) continue;
                        CompoundCommand resizeChildrenCommand = new CompoundCommand();
                        InteractionCompartmentXYLayoutEditPolicy.addLifelineResizeChildrenCommand(resizeChildrenCommand, request, child, 1);
                        org.eclipse.gef.commands.Command command = cmd = resizeChildrenCommand.isEmpty() ? null : resizeChildrenCommand.unwrap();
                        if (cmd != null) {
                            composite.add((IUndoableOperation)new CommandProxy(cmd));
                        }
                        if (request.getSizeDelta().height == 0) continue;
                        composite.add((IUndoableOperation)new PreserveAnchorsPositionCommandEx((ShapeNodeEditPart)child, request.getSizeDelta(), 0, (IFigure)child.getBorderedFigure(), request.getResizeDirection()));
                    }
                    return new ICommandProxy(composite.reduce());
                }
                return null;
            }
        };
        return lep;
    }

    protected NodeFigure createNodeFigure() {
        return new BorderedNodeFigure((IFigure)this.createMainFigure()){

            public boolean containsPoint(int x, int y) {
                if (this.getBounds().contains(x, y)) {
                    return true;
                }
                return super.containsPoint(x, y);
            }

            public void setOpaque(boolean opaque) {
                if (OLDLifelineEditPart.this.getPrimaryShape() != null) {
                    NodeFigure dashLineRectangle = OLDLifelineEditPart.this.getPrimaryShape().getFigureLifelineDotLineFigure().getDashLineRectangle();
                    dashLineRectangle.setOpaque(opaque);
                }
            }
        };
    }

    @Override
    protected NodeFigure createNodePlate() {
        LifelineDotLineCustomFigure.DefaultSizeNodeFigureEx result = new LifelineDotLineCustomFigure.DefaultSizeNodeFigureEx(100, 250){

            public boolean containsPoint(int x, int y) {
                if (OLDLifelineEditPart.this.primaryShape != null) {
                    return OLDLifelineEditPart.this.primaryShape.containsPoint(x, y);
                }
                return super.containsPoint(x, y);
            }

            protected boolean isDefaultAnchorArea(PrecisionPoint p) {
                return false;
            }
        };
        return result;
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new CustomLifelineFigure();
        return this.primaryShape;
    }

    protected ConnectionAnchor createSideAnchor(Request request, SlidableAnchor sa) {
        Point loc = AnchorHelper.getRequestLocation(request);
        PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)sa.getTerminal());
        if (loc == null || pt == null) {
            return sa;
        }
        NodeFigure fig = this.getDashLineFigure();
        Rectangle bounds = fig.getBounds().getCopy();
        fig.translateToAbsolute((Translatable)bounds);
        boolean rightHand = true;
        if (loc.x < bounds.getCenter().x) {
            rightHand = false;
        }
        return new AnchorHelper.SideAnchor(this.getNodeFigure(), pt, rightHand);
    }

    public void deactivate() {
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
        super.deactivate();
    }

    private IFigure findChildFigure(IFigure parent, int x, int y) {
        if (parent == null) {
            return null;
        }
        Map visualPartMap = this.getViewer().getVisualPartMap();
        List figures = parent.getChildren();
        Point pt = new Point(x, y);
        parent.translateFromParent((Translatable)pt);
        int i = figures.size();
        while (i > 0) {
            Object object;
            IFigure child;
            if (!(child = (IFigure)figures.get(--i)).isVisible()) continue;
            IFigure fig = this.findChildFigure(child, pt.x, pt.y);
            if (fig != null) {
                return fig;
            }
            if (!visualPartMap.containsKey(child) || !((object = visualPartMap.get(child)) instanceof LifelineEditPart ? ((LifelineEditPart)((Object)object)).getPrimaryShape().containsPoint(pt) : child.containsPoint(pt))) continue;
            return child;
        }
        return null;
    }

    public List<Property> getAvailableProperties() {
        List<Property> properties = this.getProperties();
        if (properties != null) {
            for (EditPart editPart : this.getChildren()) {
                Lifeline lifeline;
                ConnectableElement represents;
                if (!(editPart instanceof LifelineEditPart) || !properties.contains(represents = (lifeline = (Lifeline)((LifelineEditPart)editPart).resolveSemanticElement()).getRepresents())) continue;
                properties.remove(represents);
            }
        }
        return properties;
    }

    private Bounds getBounds() {
        Node node;
        if (this.getModel() instanceof Node && (node = (Node)this.getModel()).getLayoutConstraint() instanceof Bounds) {
            return (Bounds)node.getLayoutConstraint();
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        InteractionInteractionCompartmentEditPart part;
        Object obj;
        DropObjectsRequest dropRequest;
        if (this.ignoreRequest(request)) {
            return null;
        }
        if (request instanceof DropObjectsRequest && (dropRequest = (DropObjectsRequest)request).getObjects().size() > 0 && ((obj = dropRequest.getObjects().get(0)) instanceof Comment || obj instanceof Constraint || obj instanceof TimeObservation) && (part = this.getParentInteractionCompartmentEditPart()) != null) {
            return part.getCommand(request);
        }
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            EditPart target = createConnectionRequest.getTargetEditPart();
            if (target instanceof OLDLifelineEditPart) {
                OLDLifelineEditPart lifelineEditPart = (OLDLifelineEditPart)target;
                Rectangle lifelineBounds = lifelineEditPart.getContentPane().getBounds();
                for (ShapeNodeEditPart executionSpecificationEditPart : LifelineEditPartUtil.getChildShapeNodeEditPart(lifelineEditPart)) {
                    IFigure executionSpecificationFigure = executionSpecificationEditPart.getFigure();
                    Rectangle esBounds = executionSpecificationFigure.getBounds().getCopy();
                    esBounds.x = lifelineBounds.x;
                    esBounds.width = lifelineBounds.width;
                    if (createConnectionRequest.getLocation() == null) continue;
                    Point location = createConnectionRequest.getLocation().getCopy();
                    executionSpecificationFigure.translateToRelative((Translatable)location);
                    if (!esBounds.contains(location)) continue;
                    createConnectionRequest.setTargetEditPart((EditPart)executionSpecificationEditPart);
                    return executionSpecificationEditPart.getCommand(request);
                }
            } else {
                return target.getCommand(request);
            }
        }
        return super.getCommand(request);
    }

    @Override
    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return super.getContentPaneFor(editPart);
    }

    private NodeFigure getDashLineFigure() {
        NodeFigure centerFigure = null;
        if (this.getContentPane() instanceof LifelineDotLineCustomFigure) {
            centerFigure = ((LifelineDotLineCustomFigure)this.getContentPane()).getDashLineRectangle();
        }
        return centerFigure;
    }

    public int getMinimumHeight(int heightHint) {
        return this.getMinimumHeight(heightHint, false);
    }

    public int getMinimumHeight(int heightHint, boolean ignoreDestructionOccurence) {
        Rectangle rect = this.getFigure().getBounds().getCopy();
        this.getFigure().translateToAbsolute((Translatable)rect);
        if (!(this.resolveSemanticElement() instanceof Lifeline)) {
            return heightHint;
        }
        Lifeline lifeline = (Lifeline)this.resolveSemanticElement();
        EList coveredBys = lifeline.getCoveredBys();
        LifelineDotLineCustomFigure figureLifelineDotLineFigure = this.getPrimaryShape().getFigureLifelineDotLineFigure();
        Rectangle rectDotLine = figureLifelineDotLineFigure.getBounds().getCopy();
        figureLifelineDotLineFigure.translateToAbsolute((Translatable)rectDotLine);
        int bottom = rectDotLine.y + 5;
        for (InteractionFragment interactionFragment : coveredBys) {
            Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)interactionFragment);
            for (EStructuralFeature.Setting ref : settings) {
                View view;
                EditPart part;
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || !((part = DiagramEditPartsUtil.getEditPartFromView((View)(view = (View)ref.getEObject()), (EditPart)this)) instanceof GraphicalEditPart) || ignoreDestructionOccurence && (part instanceof DestructionOccurrenceSpecificationEditPart || part.getParent() instanceof CustomMessageDeleteEditPart && ((CustomMessageDeleteEditPart)part.getParent()).getSource() != this)) continue;
                GraphicalEditPart ep = (GraphicalEditPart)part;
                Rectangle r = ep.getFigure().getBounds().getCopy();
                ep.getFigure().translateToAbsolute((Translatable)r);
                bottom = Math.max(bottom, r.bottom());
            }
        }
        return Math.max(heightHint, bottom - rect.y);
    }

    public NodeFigure getNodeFigure() {
        return this.getDashLineFigure();
    }

    protected NotificationHelper getNotifier() {
        if (this.notifier == null) {
            try {
                Field f = LifelineEditPart.class.getDeclaredField("notifier");
                f.setAccessible(true);
                this.notifier = (NotificationHelper)f.get((Object)this);
            }
            catch (Exception e) {
                this.notifier = new NotificationHelper(new UIAdapterImpl(){

                    protected void safeNotifyChanged(Notification msg) {
                        OLDLifelineEditPart.this.handleNotificationEvent(msg);
                    }
                });
            }
        }
        return this.notifier;
    }

    public InteractionInteractionCompartmentEditPart getParentInteractionCompartmentEditPart() {
        OLDLifelineEditPart part = this;
        while ((part = part.getParent()) != null && !(part instanceof InteractionInteractionCompartmentEditPart)) {
        }
        return (InteractionInteractionCompartmentEditPart)((Object)part);
    }

    @Override
    public CustomLifelineFigure getPrimaryShape() {
        return (CustomLifelineFigure)this.primaryShape;
    }

    public List<Property> getProperties() {
        Lifeline lifeline = (Lifeline)this.resolveSemanticElement();
        return OLDLifelineEditPart.getProperties(lifeline);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        String terminal;
        if (connEditPart instanceof MessageCreateEditPart) {
            return new LifelineAnchor((IFigure)this.getPrimaryShape().getFigureLifelineNameContainerFigure());
        }
        if (connEditPart instanceof MessageAsyncEditPart && (terminal = AnchorHelper.getAnchorId(this.getEditingDomain(), connEditPart, false)).length() > 0) {
            int start = terminal.indexOf("{") + 1;
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)terminal);
            boolean rightHand = true;
            if (start > 0) {
                if (terminal.charAt(start) == 'L') {
                    rightHand = false;
                }
            } else {
                Connection c = (Connection)connEditPart.getFigure();
                PointList list = c.getPoints();
                if (list.getPoint((int)0).x > list.getPoint((int)1).x) {
                    rightHand = false;
                }
            }
            return new AnchorHelper.SideAnchor(this.getNodeFigure(), pt, rightHand);
        }
        return super.getTargetConnectionAnchor(connEditPart);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!UMLElementTypes.Message_CreateEdge.equals(obj)) continue;
                return LifelineMessageCreateHelper.getCreateMessageAnchor(this, request, ((CreateUnspecifiedTypeConnectionRequest)request).getLocation().getCopy());
            }
        } else if (request instanceof ReconnectRequest && (connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) instanceof MessageCreateEditPart) {
            return LifelineMessageCreateHelper.getCreateMessageAnchor(this, request, ((ReconnectRequest)request).getLocation().getCopy());
        }
        ConnectionAnchor anchor = super.getTargetConnectionAnchor(request);
        if (anchor instanceof SlidableAnchor) {
            return this.createSideAnchor(request, (SlidableAnchor)anchor);
        }
        return anchor;
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        NotificationHelper notifier = this.getNotifier();
        Object feature = notification.getFeature();
        if (ElementIconUtil.isIconNotification(notification)) {
            this.updateLifelinePosition();
        }
        EObject element = this.resolveSemanticElement();
        boolean coveredBysNeedsUpdate = false;
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (element instanceof Lifeline && !((Lifeline)element).getCoveredBys().isEmpty()) {
            Lifeline lifeline = (Lifeline)element;
            EList coveredBys = lifeline.getCoveredBys();
            if (4 == notification.getEventType()) {
                Object oldValue = notification.getOldValue();
                if (coveredBys.contains(oldValue)) {
                    coveredBysNeedsUpdate = true;
                    CommandHelper.executeCommandWithoutHistory(editingDomain, RemoveCommand.create((EditingDomain)editingDomain, (Object)lifeline, (Object)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), (Object)oldValue), true);
                }
            } else if (6 == notification.getEventType()) {
                List oldValue = (List)notification.getOldValue();
                for (Object object : oldValue) {
                    if (!coveredBys.contains(object)) continue;
                    coveredBysNeedsUpdate = true;
                    CommandHelper.executeCommandWithoutHistory(editingDomain, RemoveCommand.create((EditingDomain)editingDomain, (Object)lifeline, (Object)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), object), true);
                }
            }
        }
        if (UMLPackage.eINSTANCE.getLifeline_CoveredBy().equals(feature)) {
            EObject eContainer;
            Object newValue = notification.getNewValue();
            if (notification.getOldValue() instanceof MessageOccurrenceSpecification) {
                notifier.unlistenObject((Notifier)notification.getOldValue());
            }
            if (newValue instanceof MessageOccurrenceSpecification) {
                MessageOccurrenceSpecification newMessageOccurrenceSpecification = (MessageOccurrenceSpecification)newValue;
                notifier.listenObject((Notifier)newMessageOccurrenceSpecification);
            }
            if (newValue instanceof InteractionFragment && (eContainer = ((InteractionFragment)newValue).eContainer()) != null) {
                notifier.listenObject((Notifier)eContainer);
            }
        } else {
            UMLPackage.eINSTANCE.getOccurrenceSpecification().equals(feature);
        }
        super.handleNotificationEvent(notification);
        if (notification.getNotifier() instanceof Bounds || coveredBysNeedsUpdate) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    public boolean ignoreRequest(Request request) {
        List parts;
        if (request instanceof ChangeBoundsRequest && (request.getType().equals("add children") || request.getType().equals("drop")) && (parts = ((ChangeBoundsRequest)request).getEditParts()) != null) {
            for (Object obj : parts) {
                if (!(obj instanceof CommentEditPart) && !(obj instanceof ConstraintEditPart) && !(obj instanceof TimeObservationEditPart) && !(obj instanceof CombinedFragmentEditPart)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInlineCapability() {
        List<Property> properties = this.getAvailableProperties();
        if (properties != null && !properties.isEmpty()) {
            return this.inlineMode || this.getChildren().size() < 2;
        }
        return false;
    }

    public boolean isInlineMode() {
        List models = super.getModelChildren();
        for (Object o : models) {
            View view;
            if (!(o instanceof View) || !"Lifeline_Shape".equals(UMLVisualIDRegistry.getVisualID((view = (View)o).getType())) || !(view.getElement() instanceof Lifeline)) continue;
            return true;
        }
        return false;
    }

    protected void moveExecutionParts(Dimension sizeDelta) {
        Rectangle leftMostExecution = null;
        List<ShapeNodeEditPart> childShapeNodeEditPart = LifelineEditPartUtil.getChildShapeNodeEditPart(this);
        for (ShapeNodeEditPart executionSpecificationEP : childShapeNodeEditPart) {
            if (!(executionSpecificationEP.resolveSemanticElement() instanceof ExecutionSpecification)) continue;
            Rectangle bounds = executionSpecificationEP.getFigure().getBounds();
            Point point = bounds.getLocation();
            if (leftMostExecution != null && leftMostExecution.x <= point.x) continue;
            leftMostExecution = bounds;
        }
        if (leftMostExecution == null) {
            return;
        }
        Rectangle dotLineBounds = this.getPrimaryShape().getFigureLifelineDotLineFigure().getBounds();
        int targetX = (int)((long)dotLineBounds.x + Math.round((double)(dotLineBounds.width - leftMostExecution.width) / 2.0));
        sizeDelta.width += targetX - leftMostExecution.x;
        ChangeBoundsRequest request = new ChangeBoundsRequest();
        request.setMoveDelta(new Point(0, 0));
        request.setSizeDelta(sizeDelta);
        request.setEditParts((EditPart)this);
        Point loc = this.getFigure().getBounds().getTopRight().getCopy();
        this.getFigure().translateToAbsolute((Translatable)loc);
        request.setLocation(loc);
        request.setType((Object)"move children");
        CompoundCommand compoundCmd = new CompoundCommand();
        compoundCmd.setLabel("Move or Resize");
        InteractionCompartmentXYLayoutEditPolicy.addLifelineResizeChildrenCommand(compoundCmd, request, this, 1);
        if (compoundCmd.canExecute()) {
            CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)new GEFtoEMFCommandWrapper(compoundCmd.unwrap()), true);
        }
    }

    public void refresh() {
        this.configure(this.isInlineMode(), false);
        super.refresh();
    }

    protected void refreshBounds() {
        super.refreshBounds();
        this.adjustParentLayoutConstraint();
        if (LifelineResizeHelper.isManualSize(this)) {
            CustomLifelineFigure primaryShape = this.getPrimaryShape();
            primaryShape.setMinimumSize(new Dimension(1, -1));
        }
    }

    private void adjustParentLayoutConstraint() {
        Rectangle constraint = (Rectangle)((GraphicalEditPart)this.getParent()).getContentPane().getLayoutManager().getConstraint(this.getFigure());
        if (constraint.x == -1) {
            constraint.setX(0);
        }
    }

    protected void refreshChildren() {
        super.refreshChildren();
        List<View> modelChildren = LifelineModelChildrenHelper.getModelChildren(this.getPrimaryView());
        IFigure parent = this.getContentPane();
        List visualChildren = parent.getChildren();
        int index = 0;
        Map editPartRegistry = this.getViewer().getEditPartRegistry();
        int i = 0;
        while (i < modelChildren.size()) {
            IFigure figure;
            int currentIndex;
            Object child = editPartRegistry.get(modelChildren.get(i));
            if (child instanceof GraphicalEditPart && (currentIndex = visualChildren.indexOf(figure = ((GraphicalEditPart)child).getFigure())) != -1) {
                if (currentIndex != index) {
                    visualChildren.remove(figure);
                    visualChildren.add(index, figure);
                }
                ++index;
            }
            ++i;
        }
        this.configure(this.isInlineMode(), true);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshTransparency();
    }

    public void removeNotify() {
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
        super.removeNotify();
    }

    public void setBackgroundColor(Color c) {
        this.getPrimaryShape().getFigureLifelineNameContainerFigure().setFill(true);
        super.setBackgroundColor(c);
    }

    protected void setGradient(GradientData gradient) {
        this.getPrimaryShape().getFigureLifelineNameContainerFigure().setFill(false);
        super.setGradient(gradient);
    }

    @Override
    protected void setLineWidth(int width) {
        if (this.getPrimaryShape() instanceof NodeFigure) {
            this.getPrimaryShape().setLineWidth(width);
        }
        super.setLineWidth(width);
    }

    @Override
    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape instanceof LifelineFigure) {
            LifelineFigure lFigure = (LifelineFigure)nodeShape;
            return lFigure.getFigureLifelineDotLineFigure();
        }
        return super.setupContentPane(nodeShape);
    }

    public void showTargetFeedback(Request request) {
        if (this.ignoreRequest(request)) {
            return;
        }
        super.showTargetFeedback(request);
    }

    public int getAdjustedHeight() {
        if (!(this.getParent() instanceof OLDCustomInteractionInteractionCompartmentEditPart)) {
            return -1;
        }
        OLDCustomInteractionInteractionCompartmentEditPart parentEP = (OLDCustomInteractionInteractionCompartmentEditPart)this.getParent();
        OldCustomInteractionEditPart grandParent = (OldCustomInteractionEditPart)parentEP.getParent();
        Bounds bounds = (Bounds)((Shape)this.getModel()).getLayoutConstraint();
        Bounds boundsGrandParent = (Bounds)((Shape)grandParent.getModel()).getLayoutConstraint();
        if (bounds != null && boundsGrandParent != null) {
            Rectangle grandParentRect = OperandBoundsComputeHelper.fillRectangle(boundsGrandParent);
            if (grandParentRect.height == -1) {
                grandParentRect = grandParent.getFigure().getBounds().getCopy();
            }
            Rectangle boundsRect = OperandBoundsComputeHelper.fillRectangle(bounds);
            if (boundsRect.height == -1) {
                boundsRect.height = this.getFigure().getBounds().height;
            }
            grandParent.getFigure().translateToRelative((Translatable)boundsRect);
            int heightDiff = grandParent.getFigure().getBounds().height - parentEP.getFigure().getBounds().height;
            Dimension zoomedAddon = new Dimension(0, 14);
            grandParent.getFigure().translateToRelative((Translatable)zoomedAddon);
            return grandParentRect.height() - bounds.getY() - heightDiff - zoomedAddon.height;
        }
        return -1;
    }

    public org.eclipse.gef.commands.Command getAlignLifelineBottomToParentCommand(org.eclipse.gef.commands.Command command, boolean ignoreDOS) {
        EObject element = ViewUtil.resolveSemanticElement((View)((View)this.getModel()));
        if (!(element instanceof Lifeline)) {
            return command;
        }
        Lifeline lifeline = (Lifeline)element;
        if (!ignoreDOS) {
            for (InteractionFragment coveredBy : lifeline.getCoveredBys()) {
                if (!(coveredBy instanceof DestructionOccurrenceSpecification)) continue;
                return command;
            }
        }
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(this.getEditingDomain(), "Allign Lifeline bottom", null){
            protected int heightDelta;
            {
                this.heightDelta = 0;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int adjustedHeight = OLDLifelineEditPart.this.getAdjustedHeight();
                Bounds bounds = (Bounds)((Shape)OLDLifelineEditPart.this.getModel()).getLayoutConstraint();
                if (adjustedHeight > 0) {
                    int oldHeight = bounds.getHeight();
                    bounds.setHeight(adjustedHeight);
                    this.heightDelta = bounds.getHeight() - oldHeight;
                    if (this.heightDelta == 0) {
                        return CommandResult.newOKCommandResult();
                    }
                    Command changeHeightCommand = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)bounds, (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)bounds.getHeight());
                    changeHeightCommand.execute();
                    PreserveAnchorsPositionCommandEx preserveAnchorsCommand = new PreserveAnchorsPositionCommandEx((ShapeNodeEditPart)OLDLifelineEditPart.this, new Dimension(0, this.heightDelta), 0, (IFigure)OLDLifelineEditPart.this.getPrimaryShape().getFigureLifelineDotLineFigure(), 4);
                    if (preserveAnchorsCommand.canExecute()) {
                        preserveAnchorsCommand.execute(monitor, info);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
        return command == null ? new ICommandProxy((ICommand)cmd) : command.chain((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)cmd));
    }

    public void updateLifelineBounds(final Rectangle rect) {
        final Bounds bounds = this.getBounds();
        if (bounds != null) {
            AbstractCommand cmd = new AbstractCommand(){

                public boolean canExecute() {
                    return true;
                }

                public boolean canUndo() {
                    return false;
                }

                public void execute() {
                    bounds.setX(rect.x);
                    bounds.setY(rect.y);
                    bounds.setWidth(rect.width);
                    bounds.setHeight(rect.height);
                }

                public void redo() {
                    this.execute();
                }
            };
            CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)cmd, true);
        }
    }

    public void updateLifelinePosition() {
        Bounds bounds = this.getBounds();
        if (bounds != null) {
            Rectangle rect = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            Rectangle updatedRect = rect.getCopy();
            this.updateRectangleBounds(updatedRect);
            Dimension size = this.getPrimaryShape().getFigureLifelineNameContainerFigure().getPreferredSize(-1, this.oldNameContainerHeight);
            if (!LifelineResizeHelper.isManualSize(this)) {
                if (rect.width == -1) {
                    rect.width = updatedRect.width / 2;
                }
                if (size.width != rect.width) {
                    this.moveExecutionParts(new Dimension(size.width - rect.width, 0));
                    rect.width = size.width;
                    rect.height = this.getAdjustedHeight();
                    this.updateLifelineBounds(rect);
                }
            }
        }
    }

    private void updateRectangleBounds(Rectangle rect) {
        if (rect.width == -1) {
            rect.width = this.getFigure().getBounds().width;
        }
        if (rect.height == -1) {
            rect.height = this.getFigure().getBounds().height;
        }
        if (rect.x == -1) {
            rect.x = this.getFigure().getBounds().x;
        }
        if (rect.y == -1) {
            rect.y = this.getFigure().getBounds().y;
        }
        if (rect.width == 0) {
            rect.width = this.getFigure().getPreferredSize().width;
        }
        if (rect.height == 0) {
            rect.height = this.getFigure().getPreferredSize().height;
        }
    }

    public class CustomLifelineFigure
    extends LifelineFigure {
        @Override
        protected IMapMode getMapMode() {
            return OLDLifelineEditPart.this.getMapMode();
        }

        public boolean containsPoint(int x, int y) {
            boolean contains = super.containsPoint(x, y);
            if (!contains) {
                return false;
            }
            OLDLifelineEditPart.this.isInlineMode();
            if (this.fFigureLifelineNameContainerFigure != null && this.fFigureLifelineNameContainerFigure.containsPoint(x, y)) {
                return true;
            }
            if (!OLDLifelineEditPart.this.isInlineMode() && this.fFigureLifelineDotLineFigure != null) {
                Rectangle bounds = this.fFigureLifelineDotLineFigure.getDashLineRectangle().getBounds().getCopy();
                bounds.expand(4, 0);
                if (bounds.contains(x, y)) {
                    return true;
                }
            }
            return OLDLifelineEditPart.this.containsChildFigure((IFigure)this, x, y);
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            IFigure figure = super.findFigureAt(x, y, search);
            if (figure == null) {
                return null;
            }
            if (this.fFigureLifelineNameContainerFigure != null && this.fFigureLifelineNameContainerFigure.containsPoint(x, y)) {
                EditPart editPart = (EditPart)OLDLifelineEditPart.this.getViewer().getVisualPartMap().get(figure);
                while (editPart == null) {
                    if ((figure = figure.getParent()) == null) break;
                    editPart = (EditPart)OLDLifelineEditPart.this.getViewer().getVisualPartMap().get(figure);
                }
                return figure == null ? this : figure;
            }
            IFigure child = OLDLifelineEditPart.this.findChildFigure((IFigure)this, x, y);
            if (child != null) {
                return child;
            }
            if (!OLDLifelineEditPart.this.isInlineMode() && this.fFigureLifelineDotLineFigure != null) {
                Rectangle bounds = this.fFigureLifelineDotLineFigure.getDashLineRectangle().getBounds().getCopy();
                bounds.expand(4, 0);
                if (bounds.contains(x, y)) {
                    return this;
                }
            }
            return null;
        }

        public Dimension getMinimumSize(int wHint, int hHint) {
            if (this.minSize != null && this.minSize.height < 0) {
                Dimension d;
                int height = this.minSize.height;
                int width = this.minSize.width;
                if (this.getLayoutManager() != null) {
                    d = this.getLayoutManager().getMinimumSize((IFigure)this, wHint, hHint);
                    if (d != null) {
                        height = Math.max(height, d.height);
                        width = Math.max(width, d.width);
                    }
                } else {
                    d = this.getPreferredSize(wHint, hHint);
                    if (d != null) {
                        height = Math.max(height, d.height);
                        width = Math.max(width, d.height);
                    }
                }
                int minHeight = OLDLifelineEditPart.this.getMinimumHeight(height, true);
                return new Dimension(OLDLifelineEditPart.this.isInlineMode() ? width : this.minSize.width, minHeight);
            }
            return super.getMinimumSize(wHint, hHint);
        }
    }

    public static class PreserveAnchorsPositionCommandEx
    extends PreserveAnchorsPositionCommand {
        public PreserveAnchorsPositionCommandEx(ShapeNodeEditPart shapeEP, Dimension sizeDelta, int preserveAxis) {
            super(shapeEP, sizeDelta, preserveAxis);
        }

        public PreserveAnchorsPositionCommandEx(ShapeNodeEditPart shapeEP, Dimension sizeDelta, int preserveAxis, IFigure figure, int resizeDirection) {
            super(shapeEP, sizeDelta, preserveAxis, figure, resizeDirection);
        }

        protected String getNewIdStr(IdentityAnchor anchor) {
            Edge edge;
            if (anchor.eContainer() instanceof Edge && (edge = (Edge)anchor.eContainer()).getElement() instanceof Message && ((Message)edge.getElement()).getReceiveEvent() instanceof DestructionOccurrenceSpecification && anchor.equals(edge.getTargetAnchor())) {
                return "(0.5, 1.0)";
            }
            String res = super.getNewIdStr(anchor);
            String id = anchor.getId();
            int start = id.indexOf(123);
            if (start > 0) {
                res = String.valueOf(res) + id.substring(start);
            }
            return res;
        }
    }
}

