/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class TreeReferenceValueEditor
extends AbstractValueEditor
implements SelectionListener {
    protected Button createInstanceButton;
    protected Button unsetButton;
    protected ILabelProvider labelProvider;
    protected Object value;
    protected ReferenceValueFactory valueFactory;
    protected TreeViewer treeViewer;
    protected Tree tree;
    protected Composite compositeTree;
    private IChangeListener changeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            TreeReferenceValueEditor.this.setWidgetObservable(TreeReferenceValueEditor.this.createWidgetObservable(TreeReferenceValueEditor.this.modelProperty));
            TreeReferenceValueEditor.this.checkCreateInstanceButton();
            TreeReferenceValueEditor.this.setValueRootContentProvider();
            if (TreeReferenceValueEditor.this.treeViewer != null) {
                TreeReferenceValueEditor.this.treeViewer.refresh();
                if (TreeReferenceValueEditor.this.tree != null && TreeReferenceValueEditor.this.tree.getTopItem() != null) {
                    TreeReferenceValueEditor.this.treeViewer.expandToLevel(TreeReferenceValueEditor.this.tree.getTopItem().getData(), 10);
                }
            }
        }
    };

    public TreeReferenceValueEditor(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        Composite gridComposite = factory.createComposite((Composite)this);
        gridComposite.setLayout((Layout)new GridLayout());
        gridComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compositeTree = factory.createComposite(gridComposite);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.compositeTree.setLayout((Layout)treeColumnLayout);
        GridData compositeTreeGridData = new GridData(4, 4, true, true, 1, 1);
        compositeTreeGridData.minimumHeight = 150;
        this.compositeTree.setLayoutData((Object)compositeTreeGridData);
        this.treeViewer = new TreeViewer(this.compositeTree, 68114);
        this.tree = this.treeViewer.getTree();
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        TreeViewerColumn columnProperty = new TreeViewerColumn(this.treeViewer, 16384);
        columnProperty.getColumn().setAlignment(16384);
        columnProperty.getColumn().setText(Messages.TreeReferenceValueEditor_NameColumnProperty);
        treeColumnLayout.setColumnData((Widget)columnProperty.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        TreeViewerColumn columnValue = new TreeViewerColumn(this.treeViewer, 131072);
        columnValue.getColumn().setAlignment(16384);
        columnValue.getColumn().setText(Messages.TreeReferenceValueEditor_NameColumnValue);
        treeColumnLayout.setColumnData((Widget)columnValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(200));
        columnValue.setEditingSupport(this.createEditingSupport());
        this.createButtons();
    }

    protected void createButtons() {
        ++((GridLayout)this.getLayout()).numColumns;
        Composite gridComposite = factory.createComposite((Composite)this);
        gridComposite.setLayout((Layout)new GridLayout(2, true));
        gridComposite.setLayoutData((Object)new GridData(0, 1, false, false));
        this.createInstanceButton = factory.createButton(gridComposite, null, 8);
        this.createInstanceButton.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.createInstanceButton.setToolTipText(Messages.ReferenceDialog_CreateANewObject);
        this.createInstanceButton.addSelectionListener((SelectionListener)this);
        this.unsetButton = factory.createButton(gridComposite, null, 8);
        this.unsetButton.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.unsetButton.setToolTipText(Messages.ReferenceDialog_UnsetValue);
        this.unsetButton.addSelectionListener((SelectionListener)this);
        if (this.treeViewer != null && this.treeViewer.getSelection() != null && !this.treeViewer.getSelection().isEmpty()) {
            this.unsetButton.setEnabled(true);
        } else {
            this.unsetButton.setEnabled(false);
        }
    }

    protected void createAction() {
        if (this.valueFactory != null && this.valueFactory.canCreateObject()) {
            final Object context = this.getContextElement();
            this.getOperationExecutor(context).execute(new Runnable(){

                @Override
                public void run() {
                    Object value = TreeReferenceValueEditor.this.valueFactory.createObject((Control)TreeReferenceValueEditor.this.createInstanceButton, context);
                    if (value == null) {
                        throw new OperationCanceledException();
                    }
                    Collection<Object> validatedObjects = TreeReferenceValueEditor.this.valueFactory.validateObjects(Collections.singleton(value));
                    if (!validatedObjects.isEmpty()) {
                        int itemsSize;
                        TreeItem item;
                        TreeReferenceValueEditor.this.setValue(validatedObjects.iterator().next());
                        if (TreeReferenceValueEditor.this.tree != null && (item = TreeReferenceValueEditor.this.tree.getItem((itemsSize = TreeReferenceValueEditor.this.tree.getItems().length) - 1)) != null) {
                            TreeReferenceValueEditor.this.treeViewer.expandToLevel(item.getData(), -1);
                        }
                        TreeReferenceValueEditor.this.checkCreateInstanceButton();
                    }
                }
            }, NLS.bind((String)Messages.ReferenceDialog_setOperation, (Object)this.labelText));
        }
    }

    public void setLabelProvider(ILabelProvider provider) {
        if (provider == null) {
            this.setLabelProvider((ILabelProvider)new LabelProvider());
            return;
        }
        this.labelProvider = provider;
    }

    @Override
    public Object getValue() {
        if (this.modelProperty != null) {
            return this.modelProperty.getValue();
        }
        return this.value;
    }

    @Override
    public Object getEditableType() {
        return Object.class;
    }

    @Override
    public void setModelObservable(IObservableValue modelProperty) {
        if (modelProperty != null) {
            this.value = modelProperty.getValue();
        }
        super.setModelObservable(modelProperty);
        this.setWidgetObservable(this.createWidgetObservable(modelProperty));
        this.addListeners();
        this.checkCreateInstanceButton();
    }

    public void setValueFactory(ReferenceValueFactory factory) {
        this.valueFactory = factory;
    }

    public ReferenceValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget == this.createInstanceButton) {
            this.createAction();
        } else if (widget == this.unsetButton) {
            this.unsetAction();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setValue(Object value) {
        IContentProvider treeViewerContentProvider;
        this.removeListeners();
        this.value = value;
        if (this.modelProperty != null) {
            this.modelProperty.setValue(value);
            this.setWidgetObservable(this.createWidgetObservable(this.modelProperty));
            this.addListeners();
        }
        if (this.treeViewer != null && (treeViewerContentProvider = this.treeViewer.getContentProvider()) != null) {
            this.setValueRootContentProvider();
            this.treeViewer.refresh();
        }
        this.commit();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    protected void addListeners() {
        if (this.modelProperty != null) {
            this.modelProperty.addChangeListener(this.changeListener);
        }
    }

    protected void removeListeners() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener(this.changeListener);
        }
    }

    public abstract void setValueRootContentProvider();

    public abstract void setProvidersTreeViewer();

    public abstract EditingSupport createEditingSupport();

    public abstract IObservableValue createWidgetObservable(IObservableValue var1);

    public abstract void checkCreateInstanceButton();

    public abstract void unsetAction();
}

