/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.viewpoints.policy.IProfileHelper;

public class ProfileUtils {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.viewpoints.policy.profilehelper";

    public static IProfileHelper getProfileHelper() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i != extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j != elements.length) {
                try {
                    IProfileHelper instance = (IProfileHelper)elements[j].createExecutableExtension("class");
                    if (instance != null) {
                        return instance;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return new DefaultProfileHelper();
    }

    private static class DefaultProfileHelper
    implements IProfileHelper {
        private DefaultProfileHelper() {
        }

        @Override
        public Collection<EPackage> getAppliedProfiles(EObject model) {
            return new ArrayList<EPackage>(0);
        }

        @Override
        public Collection<EClass> getAppliedStereotypes(EObject object) {
            return new ArrayList<EClass>(0);
        }
    }
}

