/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IndentingLogger;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.evaluation.BasicEvaluationEnvironment;
import org.eclipse.ocl.pivot.internal.evaluation.BasicEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.evaluation.EvaluationCache;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.evaluation.ShadowCache;
import org.eclipse.ocl.pivot.internal.evaluation.TracingEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.NullValue;

public abstract class AbstractExecutor
implements ExecutorInternal.ExecutorInternalExtension {
    private static final int DEFAULT_REGEX_CACHE_LIMIT = 16;
    private static final float DEFAULT_REGEX_CACHE_LOAD_FACTOR = 0.75f;
    protected final @NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
    @Deprecated
    protected final ModelManager modelManager;
    private EvaluationEnvironment.EvaluationEnvironmentExtension rootEvaluationEnvironment = null;
    private EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment = null;
    private EvaluationVisitor.EvaluationVisitorExtension evaluationVisitor;
    protected final @NonNull IdResolver.IdResolverExtension idResolver;
    private Map<@NonNull String, @NonNull Pattern> regexPatterns = null;
    private EvaluationLogger logger = IndentingLogger.OUT;
    private EvaluationCache evaluationCache = null;
    private ShadowCache shadowCache = null;

    protected AbstractExecutor(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.modelManager = null;
        this.idResolver = (IdResolver.IdResolverExtension)environmentFactory.getIdResolver();
    }

    @Deprecated
    protected AbstractExecutor(@NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory, @NonNull ModelManager modelManager) {
        this.environmentFactory = environmentFactory;
        this.modelManager = modelManager;
        this.idResolver = (IdResolver.IdResolverExtension)environmentFactory.getIdResolver();
    }

    @Override
    public void add(@NonNull TypedElement referredVariable, @Nullable Object value) {
        this.evaluationEnvironment.add(referredVariable, value);
    }

    protected @NonNull EvaluationCache createEvaluationCache() {
        return new EvaluationCache(this);
    }

    protected @NonNull EvaluationVisitor.EvaluationVisitorExtension createEvaluationVisitor() {
        AbstractExtendingVisitor result = new BasicEvaluationVisitor(this);
        if (this.environmentFactory.isEvaluationTracingEnabled()) {
            result = new TracingEvaluationVisitor((EvaluationVisitor)((Object)result));
        }
        return result;
    }

    protected @NonNull Map<@NonNull String, @NonNull Pattern> createRegexCache() {
        return new LinkedHashMap<String, Pattern>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<@NonNull String, @NonNull Pattern> eldest) {
                return this.size() > 16;
            }
        };
    }

    protected @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension createNestedEvaluationEnvironment(@NonNull EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment, @NonNull NamedElement executableObject, @Nullable Object caller) {
        return new BasicEvaluationEnvironment(evaluationEnvironment, executableObject, caller);
    }

    @Deprecated
    protected @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension createNestedEvaluationEnvironment(@NonNull EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment, @NonNull NamedElement executableObject, @Nullable OCLExpression callingObject) {
        return this.createNestedEvaluationEnvironment(evaluationEnvironment, executableObject, (Object)callingObject);
    }

    @Override
    @Deprecated
    public @NonNull Evaluator createNestedEvaluator() {
        return this;
    }

    protected @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension createRootEvaluationEnvironment(@NonNull NamedElement executableObject) {
        return new BasicEvaluationEnvironment(this, executableObject);
    }

    @Override
    public void dispose() {
        this.resetCaches();
    }

    @Override
    public @Nullable Object evaluate(@NonNull OCLExpression body) {
        return this.evaluationVisitor.evaluate(body);
    }

    @Override
    public @Nullable Object getCachedEvaluationResult( @NonNull LibraryOperation.LibraryOperationExtension2 implementation, @NonNull TypedElement caller, @Nullable Object @NonNull [] sourceAndArgumentValues) {
        EvaluationCache evaluationCache2 = this.evaluationCache;
        if (evaluationCache2 == null) {
            evaluationCache2 = this.evaluationCache = this.createEvaluationCache();
        }
        return evaluationCache2.getCachedEvaluationResult(implementation, caller, sourceAndArgumentValues);
    }

    @Override
    public @NonNull CompleteEnvironment getCompleteEnvironment() {
        return this.environmentFactory.getCompleteEnvironment();
    }

    @Override
    public int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue) {
        if (resultValue == null) {
            return 4;
        }
        if (resultValue instanceof InvalidValueException) {
            return 8;
        }
        return severityPreference;
    }

    @Override
    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull EvaluationCache getEvaluationCache() {
        EvaluationCache evaluationCache2 = this.evaluationCache;
        if (evaluationCache2 == null) {
            evaluationCache2 = this.evaluationCache = this.createEvaluationCache();
        }
        return evaluationCache2;
    }

    @Override
    public @NonNull EvaluationEnvironment getEvaluationEnvironment() {
        return ClassUtil.nonNullState(this.evaluationEnvironment);
    }

    @Override
    public @NonNull EvaluationVisitor.EvaluationVisitorExtension getEvaluationVisitor() {
        EvaluationVisitor.EvaluationVisitorExtension evaluationVisitor2 = this.evaluationVisitor;
        if (evaluationVisitor2 == null) {
            this.evaluationVisitor = evaluationVisitor2 = this.createEvaluationVisitor();
        }
        return evaluationVisitor2;
    }

    @Override
    public @NonNull IdResolver.IdResolverExtension getIdResolver() {
        return this.idResolver;
    }

    @Override
    public @Nullable EvaluationLogger getLogger() {
        return this.logger;
    }

    @Override
    public @NonNull MetamodelManagerInternal getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Pattern getRegexPattern(@NonNull String regex) {
        Object object;
        if (this.regexPatterns == null) {
            object = this;
            synchronized (object) {
                if (this.regexPatterns == null) {
                    this.regexPatterns = this.createRegexCache();
                }
            }
        }
        object = this.regexPatterns;
        synchronized (object) {
            Pattern pattern = this.regexPatterns.get(regex);
            if (pattern == null) {
                pattern = Pattern.compile(regex);
                assert (pattern != null);
                this.regexPatterns.put(regex, pattern);
            }
            return pattern;
        }
    }

    @Override
    public @NonNull EvaluationEnvironment getRootEvaluationEnvironment() {
        return ClassUtil.nonNullState(this.rootEvaluationEnvironment);
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        StatusCodes.Severity severity = this.environmentFactory.getSeverity(validationKey);
        return severity != null ? severity.getStatusCode() : 2;
    }

    @Override
    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        return this.idResolver.getStaticTypeOf(value);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.idResolver.getStaticTypeOf(value, values);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.idResolver.getStaticTypeOf(value, values);
    }

    @Override
    public @Nullable Object getValueOf(@NonNull TypedElement referredVariable) {
        return this.evaluationEnvironment.getValueOf(referredVariable);
    }

    @Override
    public @NonNull EvaluationEnvironment initializeEvaluationEnvironment(@NonNull NamedElement executableObject) {
        EvaluationEnvironment.EvaluationEnvironmentExtension rootEvaluationEnvironment = this.createRootEvaluationEnvironment(executableObject);
        this.setRootEvaluationEnvironment(rootEvaluationEnvironment);
        return rootEvaluationEnvironment;
    }

    @Override
    public @Nullable Object internalExecuteNavigationCallExp(@NonNull NavigationCallExp navigationCallExp, @NonNull Property referredProperty, @Nullable Object sourceValue) {
        if (navigationCallExp.isIsSafe() && sourceValue == null) {
            return null;
        }
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        LibraryProperty.LibraryPropertyExtension implementation = (LibraryProperty.LibraryPropertyExtension)metamodelManager.getImplementation(navigationCallExp, sourceValue, referredProperty);
        try {
            return implementation.evaluate(this, navigationCallExp.getTypeId(), sourceValue);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, referredProperty, sourceValue, navigationCallExp);
        }
    }

    @Override
    public Object internalExecuteOperationCallExp(@NonNull OperationCallExp operationCallExp, @Nullable Object @NonNull [] sourceAndArgumentValues) {
        List<Parameter> asParameters;
        Operation apparentOperation = operationCallExp.getReferredOperation();
        assert (apparentOperation != null);
        Class actualSourceType = null;
        if (!apparentOperation.isIsStatic()) {
            actualSourceType = this.idResolver.getStaticTypeOf(sourceAndArgumentValues[0]);
        }
        if ((asParameters = apparentOperation.getOwnedParameters()).size() == 1 && asParameters.get(0).getType() instanceof SelfType && actualSourceType != null) {
            Class actualArgType = this.idResolver.getStaticTypeOf(sourceAndArgumentValues[1]);
            actualSourceType = (Class)actualSourceType.getCommonType(this.idResolver, actualArgType);
        }
        Operation actualOperation = actualSourceType != null ? actualSourceType.lookupActualOperation(this.environmentFactory.getStandardLibrary(), apparentOperation) : apparentOperation;
        LibraryOperation.LibraryOperationExtension2 implementation = (LibraryOperation.LibraryOperationExtension2)this.environmentFactory.getMetamodelManager().getImplementation(actualOperation);
        try {
            Object result = implementation.evaluate(this, operationCallExp, sourceAndArgumentValues);
            assert (!(result instanceof NullValue));
            return result;
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, apparentOperation, ILabelGenerator.Registry.INSTANCE.labelFor(sourceAndArgumentValues[0]), operationCallExp);
        }
    }

    @Override
    public @Nullable Object internalExecuteShadowExp(@NonNull ShadowExp asShadowExp) {
        if (this.shadowCache == null) {
            this.shadowCache = new ShadowCache(this);
        }
        Class asClass = ClassUtil.nonNullState(asShadowExp.getType());
        List<ShadowPart> asShadowParts = asShadowExp.getOwnedParts();
        int iMax = asShadowParts.size();
        @Nullable Object @NonNull [] values = new Object[iMax];
        int i = 0;
        while (i < iMax) {
            ShadowPart asShadowPart = asShadowParts.get(i);
            assert (asShadowPart != null);
            values[i] = asShadowPart;
            ++i;
        }
        Arrays.sort(values, new Comparator<Object>(){

            @Override
            public int compare(@Nullable Object o1, @Nullable Object o2) {
                ShadowPart s1 = (ShadowPart)o1;
                ShadowPart s2 = (ShadowPart)o2;
                if (!($assertionsDisabled || s1 != null && s2 != null)) {
                    throw new AssertionError();
                }
                Property p1 = s1.getReferredProperty();
                Property p2 = s2.getReferredProperty();
                String n1 = p1.getName();
                String n2 = p2.getName();
                return ClassUtil.safeCompareTo(n1, n2);
            }
        });
        @NonNull Property @NonNull [] asProperties = new Property[iMax];
        int i2 = 0;
        while (i2 < iMax) {
            ShadowPart asShadowPart = (ShadowPart)values[i2];
            assert (asShadowPart != null);
            Property asProperty = asShadowPart.getReferredProperty();
            assert (asProperty != null);
            asProperties[i2] = asProperty;
            Object boxedValue = null;
            OCLExpression initExpression = asShadowPart.getOwnedInit();
            if (initExpression != null) {
                boxedValue = this.getEvaluationVisitor().evaluate(initExpression);
            }
            values[i2] = boxedValue;
            ++i2;
        }
        Object object = asClass instanceof DataType ? asClass.createInstance(String.valueOf(values[0])) : this.shadowCache.getCachedShadowObject(asClass, asProperties, values);
        return object;
    }

    @Override
    public boolean isCanceled() {
        return this.evaluationVisitor.isCanceled();
    }

    @Override
    public void popEvaluationEnvironment() {
        this.evaluationEnvironment = ClassUtil.nonNullState(this.evaluationEnvironment.getParentEvaluationEnvironment());
    }

    @Override
    public @NonNull EvaluationEnvironment pushEvaluationEnvironment(@NonNull NamedElement executableObject, @Nullable Object caller) {
        EvaluationEnvironment.EvaluationEnvironmentExtension nestedEvaluationEnvironment;
        EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment2 = ClassUtil.nonNullState(this.evaluationEnvironment);
        this.evaluationEnvironment = nestedEvaluationEnvironment = this.createNestedEvaluationEnvironment(evaluationEnvironment2, executableObject, caller);
        return nestedEvaluationEnvironment;
    }

    @Override
    @Deprecated
    public @NonNull EvaluationEnvironment pushEvaluationEnvironment(@NonNull NamedElement executableObject, @Nullable OCLExpression callingObject) {
        return this.pushEvaluationEnvironment(executableObject, (Object)callingObject);
    }

    @Override
    public void replace(@NonNull TypedElement referredVariable, @Nullable Object value) {
        this.evaluationEnvironment.replace(referredVariable, value);
    }

    @Override
    public void resetCaches() {
        if (this.evaluationCache != null) {
            this.evaluationCache.dispose();
            this.evaluationCache = null;
        }
        if (this.shadowCache != null) {
            this.shadowCache.dispose();
            this.shadowCache = null;
        }
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.evaluationVisitor.setCanceled(isCanceled);
    }

    @Override
    public void setLogger(@Nullable EvaluationLogger logger) {
        this.logger = logger;
    }

    protected void setRootEvaluationEnvironment(@NonNull EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment) {
        assert (this.rootEvaluationEnvironment == null);
        this.rootEvaluationEnvironment = evaluationEnvironment;
        this.evaluationEnvironment = evaluationEnvironment;
    }
}

