/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImportUtils {
    public static final String IMPORTS_MARKER = "<%**imports**%>";
    public static final String IMPORTS_PREFIX = "<%";
    public static final String IMPORTS_SUFFIX = "%>";

    public static @NonNull String getAffixedName(@NonNull Class<?> javaClass) {
        return IMPORTS_PREFIX + javaClass.getName() + IMPORTS_SUFFIX;
    }

    public static @NonNull String getAffixedName(@NonNull String className) {
        assert (!className.contains("@"));
        return IMPORTS_PREFIX + className + IMPORTS_SUFFIX;
    }

    public static @NonNull Map<@NonNull String, @Nullable String> getLong2ShortImportNames(@NonNull Iterable<String> allImports) {
        String shortName;
        HashMap<String, String> long2shortNames = new HashMap<String, String>();
        HashMap<String, String> shortables = new HashMap<String, String>();
        for (String longName : allImports) {
            int index = longName.lastIndexOf(".");
            String string = shortName = index >= 0 ? longName.substring(index + 1) : longName;
            if (shortables.containsKey(shortName)) {
                String oldImport = (String)shortables.get(shortName);
                long2shortNames.put(oldImport, null);
                long2shortNames.put(longName, null);
                shortables.put(shortName, null);
                continue;
            }
            long2shortNames.put(longName, shortName);
            shortables.put(shortName, longName);
        }
        HashMap<@NonNull String, @Nullable String> long2short = new HashMap<String, String>();
        for (String longName : long2shortNames.keySet()) {
            shortName = (String)long2shortNames.get(longName);
            if (longName == null) continue;
            long2short.put(longName, shortName != null ? shortName : null);
        }
        return long2short;
    }

    @Deprecated
    public static @NonNull String resolveImports(@NonNull String source, @NonNull Map<@NonNull String, @Nullable String> long2short) {
        return ImportUtils.resolveImports(source, long2short, false);
    }

    public static @NonNull String resolveImports(@NonNull String source, @NonNull Map<@NonNull String, @Nullable String> long2short, boolean skipStartMarker) {
        int iSuffix;
        int iPrefix;
        StringBuilder s = new StringBuilder();
        int iStart = 0;
        int iMax = source.length();
        if (!skipStartMarker) {
            iStart = source.indexOf(IMPORTS_MARKER);
            if (iStart < 0) {
                return source;
            }
            s.append(source, 0, iStart);
            iStart += IMPORTS_MARKER.length();
            ArrayList<String> sortedImports = new ArrayList<String>(long2short.keySet());
            Collections.sort(sortedImports);
            for (String anImport : sortedImports) {
                String shortname = long2short.get(anImport);
                if (shortname == null || anImport.startsWith("java.lang.") && anImport.equals("java.lang." + shortname)) continue;
                s.append("import " + anImport + ";\n");
            }
        }
        while ((iPrefix = source.indexOf(IMPORTS_PREFIX, iStart)) >= 0 && (iSuffix = source.indexOf(IMPORTS_SUFFIX, iPrefix)) >= 0) {
            String shortname;
            String longName;
            s.append(source, iStart, iPrefix);
            String annotatedName = longName = source.substring(iPrefix + IMPORTS_PREFIX.length(), iSuffix);
            int startIndex = annotatedName.indexOf("@");
            int endIndex = annotatedName.indexOf(" ");
            if (startIndex >= 0) {
                // empty if block
            }
            s.append((shortname = long2short.get(longName)) != null ? shortname : longName);
            iStart = iSuffix + IMPORTS_SUFFIX.length();
        }
        s.append(source, iStart, iMax);
        return s.toString();
    }

    public static @NonNull String rewriteManagedImports(@NonNull String source, @Nullable ImportManager importManager) {
        int iSuffix;
        int iPrefix;
        int iMax = source.length();
        int iStart = 0;
        StringBuilder s = new StringBuilder();
        while ((iPrefix = source.indexOf(IMPORTS_PREFIX, iStart)) >= 0 && (iSuffix = source.indexOf(IMPORTS_SUFFIX, iPrefix)) >= 0) {
            String shortTypeName;
            s.append(source, iStart, iPrefix);
            String annotatedName = source.substring(iPrefix + IMPORTS_PREFIX.length(), iSuffix);
            String longAnnotationName = null;
            String longTypeName = annotatedName;
            int startIndex = annotatedName.indexOf("@");
            int endIndex = annotatedName.indexOf(" ");
            if (startIndex >= 0 && startIndex < endIndex) {
                longTypeName = String.valueOf(annotatedName.substring(0, startIndex)) + annotatedName.substring(endIndex).trim();
                longAnnotationName = annotatedName.substring(startIndex + 1, endIndex).trim();
                if (importManager != null) {
                    importManager.addImport(longAnnotationName);
                }
            }
            if (importManager != null) {
                importManager.addImport(longTypeName);
            }
            String string = shortTypeName = importManager != null ? importManager.getImportedName(longTypeName) : null;
            if (longAnnotationName == null) {
                s.append(IMPORTS_PREFIX);
                s.append(shortTypeName != null ? shortTypeName : longTypeName);
                s.append(IMPORTS_SUFFIX);
            } else if (shortTypeName != null && !shortTypeName.equals(longTypeName)) {
                s.append("@");
                s.append(IMPORTS_PREFIX);
                s.append(longAnnotationName);
                s.append(IMPORTS_SUFFIX);
                s.append(" ");
                s.append(shortTypeName);
            } else {
                s.append(annotatedName.substring(0, startIndex));
                s.append("@");
                s.append(IMPORTS_PREFIX);
                s.append(longAnnotationName);
                s.append(IMPORTS_SUFFIX);
                s.append(" ");
                s.append(annotatedName.substring(endIndex).trim());
            }
            iStart = iSuffix + IMPORTS_SUFFIX.length();
        }
        s.append(source, iStart, iMax);
        return s.toString();
    }
}

