/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.objectteams.otdt.core.ext.WeavingScheme;
import org.eclipse.objectteams.otdt.internal.ui.preferences.OTPreferencesMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CompilerConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_PB_BASECALL = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.basecall");
    private static final OptionsConfigurationBlock.Key PREF_PB_BASECLASS_CYCLE = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.baseclass_cycle");
    private static final OptionsConfigurationBlock.Key PREF_PB_UNSAFE_ROLE_INSTANTIATION = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.unsafe_role_instantiation");
    private static final OptionsConfigurationBlock.Key PREF_PB_FRAGILE_CALLIN = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.fragile_callin");
    private static final OptionsConfigurationBlock.Key PREF_PB_POTENTIAL_AMBIGUOUS_PLAYEDBY = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.potential_ambiguous_playedby");
    private static final OptionsConfigurationBlock.Key PREF_PB_ABSTRACT_POTENTIAL_RELEVANT_ROLE = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.abstract_potential_relevant_role");
    private static final OptionsConfigurationBlock.Key PREF_PB_DECAPSULATION = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.decapsulation");
    private static final OptionsConfigurationBlock.Key PREF_PB_DECAPSULATION_WRITE = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.decapsulation_write");
    private static final OptionsConfigurationBlock.Key PREF_PB_DEPRECATED_PATH_SYNTAX = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.deprecated_path_syntax");
    private static final OptionsConfigurationBlock.Key PREF_PB_BINDING_CONVENTIONS = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.binding_conventions");
    private static final OptionsConfigurationBlock.Key PREF_PB_INFERRED_CALLOUT = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.inferred_callout");
    private static final OptionsConfigurationBlock.Key PREF_PB_WEAVE_INTO_SYSTEM_CLASS = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.weave_into_system_class");
    private static final OptionsConfigurationBlock.Key PREF_PB_OVERRIDE_FINAL_ROLE = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.override_final_role");
    private static final OptionsConfigurationBlock.Key PREF_PB_EXCEPTION_IN_GUARD = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.exception_in_guard");
    private static final OptionsConfigurationBlock.Key PREF_PB_AMBIGUOUS_LOWERING = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.ambiguous_lowering");
    private static final OptionsConfigurationBlock.Key PREF_PB_ADAPTING_DEPRECATED = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.adapting_deprecated");
    private static final OptionsConfigurationBlock.Key PREF_PB_IGNORING_ROLE_RETURN = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.ignoring_role_return");
    private static final OptionsConfigurationBlock.Key PREF_PB_EFFECTLESS_FIELD_ACCESS = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.effectless_fieldaccess");
    private static final OptionsConfigurationBlock.Key PREF_PB_UNUSED_PARAMMAP = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.problem.unused_parammap");
    private static final OptionsConfigurationBlock.Key PREF_WEAVING_SCHEME = CompilerConfigurationBlock.getJDTCoreKey((String)"org.eclipse.objectteams.otdt.compiler.option.weaving_scheme");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String INFO = "info";
    private static final String IGNORE = "ignore";
    private static final String SETTINGS_SECTION_NAME = "OTJCompilerConfigurationBlock";
    private Composite fControlsComposite;
    private ControlEnableState fBlockEnableState = null;
    private OptionsConfigurationBlock.FilteredPreferenceTree fFilteredPrefTree;
    private PixelConverter fPixelConverter;
    private Combo fWeavingSchemeComboBox;

    public CompilerConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, CompilerConfigurationBlock.getKeys(), container);
    }

    public static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_PB_BASECALL, PREF_PB_BASECLASS_CYCLE, PREF_PB_UNSAFE_ROLE_INSTANTIATION, PREF_PB_EFFECTLESS_FIELD_ACCESS, PREF_PB_FRAGILE_CALLIN, PREF_PB_UNUSED_PARAMMAP, PREF_PB_IGNORING_ROLE_RETURN, PREF_PB_POTENTIAL_AMBIGUOUS_PLAYEDBY, PREF_PB_ABSTRACT_POTENTIAL_RELEVANT_ROLE, PREF_PB_DECAPSULATION, PREF_PB_DECAPSULATION_WRITE, PREF_PB_BINDING_CONVENTIONS, PREF_PB_DEPRECATED_PATH_SYNTAX, PREF_PB_INFERRED_CALLOUT, PREF_PB_ADAPTING_DEPRECATED, PREF_PB_WEAVE_INTO_SYSTEM_CLASS, PREF_PB_OVERRIDE_FINAL_ROLE, PREF_PB_EXCEPTION_IN_GUARD, PREF_PB_AMBIGUOUS_LOWERING, PREF_WEAVING_SCHEME};
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite commonComposite = this.createCompilerPreferenceTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        commonComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    public void enablePreferenceContent(boolean enable) {
        if (this.fControlsComposite != null && !this.fControlsComposite.isDisposed()) {
            if (enable) {
                if (this.fBlockEnableState != null) {
                    this.fBlockEnableState.restore();
                    this.fBlockEnableState = null;
                }
            } else if (this.fBlockEnableState == null) {
                this.fBlockEnableState = ControlEnableState.disable((Control)this.fControlsComposite);
            }
        }
        if (this.fWeavingSchemeComboBox != null && !this.fWeavingSchemeComboBox.isDisposed()) {
            this.fWeavingSchemeComboBox.setEnabled(enable);
        }
    }

    private Composite createCompilerPreferenceTabContent(Composite folder) {
        int indentStep = this.fPixelConverter.convertWidthInCharsToPixels(1);
        int nColumns = 3;
        Composite topComposite = new Composite(folder, 0);
        topComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout topLayout = new GridLayout(nColumns, false);
        topLayout.marginHeight = this.fPixelConverter.convertHeightInCharsToPixels(1) / 2;
        topComposite.setLayout((Layout)topLayout);
        this.fWeavingSchemeComboBox = this.addComboBox(topComposite, OTPreferencesMessages.OTCompilerConfigurationBlock_weaving_label, PREF_WEAVING_SCHEME, new String[]{WeavingScheme.OTRE.name(), WeavingScheme.OTDRE.name()}, new String[]{OTPreferencesMessages.OTCompilerConfigurationBlock_weaving_otre_label, OTPreferencesMessages.OTCompilerConfigurationBlock_weaving_otdre_label}, indentStep * 2);
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, INFO, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.ProblemSeveritiesConfigurationBlock_error, PreferencesMessages.ProblemSeveritiesConfigurationBlock_warning, PreferencesMessages.ProblemSeveritiesConfigurationBlock_info, PreferencesMessages.ProblemSeveritiesConfigurationBlock_ignore};
        this.fFilteredPrefTree = new OptionsConfigurationBlock.FilteredPreferenceTree((OptionsConfigurationBlock)this, folder, OTPreferencesMessages.OTCompilerConfigurationBlock_common_description);
        ScrolledPageContent sc1 = this.fFilteredPrefTree.getScrolledPageContent();
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        int defaultIndent = indentStep * 0;
        String label = OTPreferencesMessages.OTCompilerProblemConfiguration_otjld_ref_description;
        this.addLabel(composite, nColumns, label, 2);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_section_decapsulation;
        OptionsConfigurationBlock.Key twistieKey = OptionsConfigurationBlock.getLocalKey((String)"CompilerConfigurationBlock_section_decapsulation");
        OptionsConfigurationBlock.PreferenceTreeNode section = this.fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, null, false);
        ExpandableComposite excomposite = this.getExpandableComposite(twistieKey);
        Composite inner = this.createInnerComposite(excomposite, nColumns, composite.getFont());
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_decapsulation_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_DECAPSULATION, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_decapsulation_write_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_DECAPSULATION_WRITE, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_override_final_role;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_OVERRIDE_FINAL_ROLE, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_adapting_deprecated_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_ADAPTING_DEPRECATED, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_binding_to_system_class;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_WEAVE_INTO_SYSTEM_CLASS, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_section_unsafe;
        twistieKey = OptionsConfigurationBlock.getLocalKey((String)"CompilerConfigurationBlock_section_unsafe");
        section = this.fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, null, false);
        excomposite = this.getExpandableComposite(twistieKey);
        inner = this.createInnerComposite(excomposite, nColumns, composite.getFont());
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_fragile_callin_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_FRAGILE_CALLIN, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_unsafe_role_instantiation_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_UNSAFE_ROLE_INSTANTIATION, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_abstract_potential_relevant_role_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_ABSTRACT_POTENTIAL_RELEVANT_ROLE, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_baseclass_cycle_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_BASECLASS_CYCLE, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_potential_ambiguous_playedby_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_POTENTIAL_AMBIGUOUS_PLAYEDBY, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_section_programming_problems;
        twistieKey = OptionsConfigurationBlock.getLocalKey((String)"CompilerConfigurationBlock_section_programming_problems");
        section = this.fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, null, false);
        excomposite = this.getExpandableComposite(twistieKey);
        inner = this.createInnerComposite(excomposite, nColumns, composite.getFont());
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_effectless_fieldaccess_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_EFFECTLESS_FIELD_ACCESS, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_ignoring_role_result;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_IGNORING_ROLE_RETURN, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_unused_parammap_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_UNUSED_PARAMMAP, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_ambiguous_lowering_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_AMBIGUOUS_LOWERING, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_section_control_flow;
        twistieKey = OptionsConfigurationBlock.getLocalKey((String)"CompilerConfigurationBlock_section_control_flow");
        section = this.fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, null, false);
        excomposite = this.getExpandableComposite(twistieKey);
        inner = this.createInnerComposite(excomposite, nColumns, composite.getFont());
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_not_exactly_one_basecall_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_BASECALL, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_exception_in_guard;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_EXCEPTION_IN_GUARD, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_section_code_style;
        twistieKey = OptionsConfigurationBlock.getLocalKey((String)"CompilerConfigurationBlock_section_2");
        section = this.fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, null, false);
        excomposite = this.getExpandableComposite(twistieKey);
        inner = this.createInnerComposite(excomposite, nColumns, composite.getFont());
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_bindingconventions_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_BINDING_CONVENTIONS, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_inferred_callout_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_INFERRED_CALLOUT, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        label = OTPreferencesMessages.OTCompilerConfigurationBlock_deprecated_path_syntax_label;
        this.fFilteredPrefTree.addComboBox(inner, label, PREF_PB_DEPRECATED_PATH_SYNTAX, errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent, section);
        IDialogSettings settingsSection = JavaPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(settingsSection);
        this.fControlsComposite = sc1;
        return sc1;
    }

    private Composite createInnerComposite(ExpandableComposite excomposite, int nColumns, Font font) {
        Composite inner = new Composite((Composite)excomposite, 0);
        inner.setFont(font);
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        excomposite.setClient((Control)inner);
        return inner;
    }

    private void addLabel(Composite composite, int nColumns, String descriptionText, int fontStyle) {
        Label description = new Label(composite, 64);
        description.setText(descriptionText);
        if (fontStyle != 0) {
            Font f = composite.getFont();
            FontData[] datas = f.getFontData();
            datas[0].setStyle(fontStyle);
            description.setFont(new Font(f.getDevice(), datas[0]));
        }
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String olValue, String newValue) {
        if (changedKey != null) {
            if (!PREF_PB_BASECALL.equals(changedKey) && !PREF_PB_DECAPSULATION.equals(changedKey)) return;
            this.updateEnableStates();
            return;
        } else {
            this.updateEnableStates();
        }
    }

    private void updateEnableStates() {
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.ComplianceConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.ComplianceConfigurationBlock_needsfullbuild_message : PreferencesMessages.ComplianceConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    public void dispose() {
        IDialogSettings section = JavaPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(section);
        super.dispose();
    }
}

