/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.model;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;

public final class PrettyPrinter {
    public static String objectAsString(IObject stringObject, int limit) throws SnapshotException {
        Object valueObj = stringObject.resolveValue("value");
        if (!(valueObj instanceof IPrimitiveArray)) {
            return null;
        }
        IPrimitiveArray charArray = (IPrimitiveArray)valueObj;
        Object countObj = stringObject.resolveValue("count");
        if (countObj == null) {
            return PrettyPrinter.arrayAsString(charArray, 0, charArray.getLength(), limit);
        }
        if (!(countObj instanceof Integer)) {
            return null;
        }
        Integer count = (Integer)countObj;
        if (count == 0) {
            return "";
        }
        Object offsetObj = stringObject.resolveValue("offset");
        if (!(offsetObj instanceof Integer)) {
            return null;
        }
        Integer offset = (Integer)offsetObj;
        return PrettyPrinter.arrayAsString(charArray, offset, count, limit);
    }

    public static String arrayAsString(IPrimitiveArray charArray, int offset, int count, int limit) {
        char[] value;
        int contentToRead;
        if (charArray.getType() != 5) {
            return null;
        }
        int length = charArray.getLength();
        int n = contentToRead = count <= limit ? count : limit;
        if (contentToRead > length - offset) {
            contentToRead = length - offset;
        }
        if ((value = offset == 0 && length == contentToRead ? (char[])charArray.getValueArray() : (char[])charArray.getValueArray(offset, contentToRead)) == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(value.length);
        int ii = 0;
        while (ii < value.length) {
            char val = value[ii];
            if (val >= ' ' && val < '\u007f') {
                result.append(val);
            } else {
                result.append("\\u").append(String.format("%04x", 0xFFFF & val));
            }
            ++ii;
        }
        if (limit < count) {
            result.append("...");
        }
        return result.toString();
    }

    private PrettyPrinter() {
    }
}

