/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.acquire;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.acquire.HeapDumpProviderDescriptor;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.annotations.Usage;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapDumpProviderRegistry
extends RegistryReader<IHeapDumpProvider> {
    private final Map<String, HeapDumpProviderDescriptor> providersByIdentifier = new HashMap<String, HeapDumpProviderDescriptor>();
    private final Map<String, HeapDumpProviderDescriptor> providersByClass = new HashMap<String, HeapDumpProviderDescriptor>();
    private static final HeapDumpProviderRegistry instance = new HeapDumpProviderRegistry();

    private HeapDumpProviderRegistry() {
        this.init(MATPlugin.getDefault().getExtensionTracker(), "org.eclipse.mat.api.heapDumpProvider");
    }

    public static HeapDumpProviderRegistry instance() {
        return instance;
    }

    protected IHeapDumpProvider createDelegate(IConfigurationElement configElement) throws CoreException {
        try {
            IHeapDumpProvider dumpProvider = (IHeapDumpProvider)configElement.createExecutableExtension("impl");
            HeapDumpProviderDescriptor descriptor = this.registerProvider(dumpProvider);
            if (MATPlugin.getDefault().isDebugging()) {
                MATPlugin.log(1, MessageUtil.format((String)"IHeapDumpProvider ''{0}'' registered.", (Object[])new Object[]{descriptor.getName()}));
            }
            return descriptor != null ? dumpProvider : null;
        }
        catch (SnapshotException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mat.api", MessageUtil.format((String)"Error registering heap dump adapter: {0}", (Object[])new Object[]{configElement.getAttribute("impl")}), (Throwable)e));
        }
    }

    protected void removeDelegate(IHeapDumpProvider delegate) {
        for (HeapDumpProviderDescriptor descriptor : this.providersByIdentifier.values()) {
            if (descriptor.getSubject() != delegate.getClass()) continue;
            this.providersByIdentifier.remove(descriptor.getIdentifier());
            this.providersByClass.remove(descriptor.getSubject().getName().toLowerCase(Locale.ENGLISH));
            break;
        }
    }

    public synchronized Collection<HeapDumpProviderDescriptor> getHeapDumpProviders() {
        return Collections.unmodifiableCollection(this.providersByIdentifier.values());
    }

    public synchronized HeapDumpProviderDescriptor getHeapDumpProvider(String name) {
        HeapDumpProviderDescriptor descriptor = this.providersByIdentifier.get(name);
        return descriptor != null ? descriptor : this.providersByClass.get(name);
    }

    public synchronized HeapDumpProviderDescriptor getHeapDumpProvider(Class<? extends IHeapDumpProvider> providerClass) {
        return this.providersByClass.get(providerClass.getName().toLowerCase(Locale.ENGLISH));
    }

    private final synchronized HeapDumpProviderDescriptor registerProvider(IHeapDumpProvider provider) throws SnapshotException {
        Class<?> providerClass = provider.getClass();
        String key = providerClass.getSimpleName();
        ResourceBundle i18n = this.getBundle(providerClass);
        Name n = providerClass.getAnnotation(Name.class);
        String name = this.translate(i18n, String.valueOf(key) + ".name", n != null ? n.value() : providerClass.getSimpleName());
        String identifier = this.getIdentifier(provider);
        if (this.providersByIdentifier.containsKey(identifier)) {
            throw new SnapshotException(MessageUtil.format((String)Messages.HeapDumpProviderRegistry_NameAlreadyBouneErrorMsg, (Object[])new Object[]{identifier, this.providersByIdentifier.get(identifier).getSubject().getName()}));
        }
        Usage u = providerClass.getAnnotation(Usage.class);
        String usage = u != null ? u.value() : null;
        Help h = providerClass.getAnnotation(Help.class);
        String help = this.translate(i18n, String.valueOf(key) + ".help", h != null ? h.value() : null);
        Locale helpLoc = i18n.getLocale();
        HelpUrl hu = providerClass.getAnnotation(HelpUrl.class);
        String helpUrl = hu != null ? hu.value() : null;
        HeapDumpProviderDescriptor descriptor = new HeapDumpProviderDescriptor(identifier, name, usage, help, helpUrl, helpLoc, provider);
        Class<?> clazz = providerClass;
        while (!clazz.equals(Object.class)) {
            this.addArguments(provider, clazz, descriptor, i18n);
            clazz = clazz.getSuperclass();
        }
        this.providersByIdentifier.put(identifier, descriptor);
        this.providersByClass.put(provider.getClass().getName().toLowerCase(Locale.ENGLISH), descriptor);
        return descriptor;
    }

    private ResourceBundle getBundle(Class<? extends IHeapDumpProvider> providerClass) {
        try {
            return ResourceBundle.getBundle(String.valueOf(providerClass.getPackage().getName()) + ".annotations", Locale.getDefault(), providerClass.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            return new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) {
                    return null;
                }

                @Override
                public Enumeration<String> getKeys() {
                    return null;
                }

                @Override
                public Locale getLocale() {
                    return Locale.getDefault();
                }
            };
        }
    }

    private String translate(ResourceBundle i18n, String key, String defaultValue) {
        try {
            return i18n.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return defaultValue;
        }
    }

    private String getIdentifier(IHeapDumpProvider provider) {
        Class<?> queryClass = provider.getClass();
        Name n = queryClass.getAnnotation(Name.class);
        String name = n != null ? n.value() : queryClass.getSimpleName();
        CommandName cn = queryClass.getAnnotation(CommandName.class);
        return (cn != null ? cn.value() : name).toLowerCase(Locale.ENGLISH).replace(' ', '_');
    }

    private void addArguments(IHeapDumpProvider provider, Class<?> clazz, HeapDumpProviderDescriptor descriptor, ResourceBundle i18n) throws SnapshotException {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Argument argument = field.getAnnotation(Argument.class);
                if (argument != null) {
                    ArgumentDescriptor argDescriptor = this.fromAnnotation(clazz, argument, field, field.get(provider));
                    Help h = field.getAnnotation(Help.class);
                    String help = this.translate(i18n, String.valueOf(clazz.getSimpleName()) + "." + argDescriptor.getName() + ".help", h != null ? h.value() : null);
                    if (help != null) {
                        argDescriptor.setHelp(help);
                    }
                    descriptor.addParameter(argDescriptor);
                }
            }
            catch (SnapshotException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                String msg = Messages.HeapDumpProviderRegistry_UnableToAccessArgumentErrorMsg;
                throw new SnapshotException(MessageUtil.format((String)msg, (Object[])new Object[]{field.getName(), clazz.getName()}), (Throwable)e);
            }
            catch (Exception e) {
                throw new SnapshotException(MessageUtil.format((String)Messages.HeapDumpProviderRegistry_ErrorGettingArgumentErrorMsg, (Object[])new Object[]{field.getName(), clazz.getName()}), (Throwable)e);
            }
            ++n2;
        }
    }

    private ArgumentDescriptor fromAnnotation(Class<?> clazz, Argument annotation, Field field, Object defaultValue) throws SnapshotException {
        ArgumentDescriptor d = new ArgumentDescriptor();
        d.setMandatory(annotation.isMandatory());
        d.setName(field.getName());
        String flag = annotation.flag();
        if (flag.equals("none")) {
            flag = null;
        } else if (flag.length() == 0) {
            flag = field.getName().toLowerCase(Locale.ENGLISH);
        }
        d.setFlag(flag);
        d.setField(field);
        d.setArray(field.getType().isArray());
        d.setList(List.class.isAssignableFrom(field.getType()));
        if (d.isArray()) {
            d.setType(field.getType().getComponentType());
        } else if (d.isList()) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
                d.setType((Class)typeArguments[0]);
            }
        } else {
            d.setType(field.getType());
        }
        Argument.Advice advice = annotation.advice();
        if (advice == Argument.Advice.CLASS_NAME_PATTERN && !Pattern.class.isAssignableFrom(d.getType())) {
            String msg = MessageUtil.format((String)Messages.HeapDumpProviderRegistry_WrongTypeErrorMsg, (Object[])new Object[]{field.getName(), clazz.getName(), Argument.Advice.CLASS_NAME_PATTERN, Pattern.class.getName()});
            throw new SnapshotException(msg);
        }
        if (advice != Argument.Advice.NONE) {
            d.setAdvice(advice);
        }
        if (d.isArray() && defaultValue != null) {
            int size = Array.getLength(defaultValue);
            ArrayList<Object> l = new ArrayList<Object>(size);
            int ii = 0;
            while (ii < size) {
                l.add(Array.get(defaultValue, ii));
                ++ii;
            }
            d.setDefaultValue(Collections.unmodifiableList(l));
        } else {
            d.setDefaultValue(defaultValue);
        }
        return d;
    }
}

