/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.lsp4e.ContentTypeToLSPLaunchConfigEntry;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.NewContentTypeLSPLaunchDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LanguageServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private LanguageServersRegistry registry;
    private List<ContentTypeToLSPLaunchConfigEntry> workingCopy;
    private Button removeButton;
    private TableViewer viewer;
    private SelectionAdapter contentTypeLinkListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (LanguageServerPreferencePage.this.getContainer() instanceof IWorkbenchPreferenceContainer) {
                ((IWorkbenchPreferenceContainer)LanguageServerPreferencePage.this.getContainer()).openPage("org.eclipse.ui.preferencePages.ContentTypes", null);
            }
        }
    };

    public void init(IWorkbench workbench) {
        this.registry = LanguageServersRegistry.getInstance();
    }

    protected Control createContents(Composite parent) {
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(2, false));
        Link intro = new Link(res, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(2, 1).hint(400, -1).applyTo((Control)intro);
        intro.setText(Messages.PreferencesPage_Intro);
        intro.addSelectionListener((SelectionListener)this.contentTypeLinkListener);
        this.createStaticServersTable(res);
        Link manualServersIntro = new Link(res, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(2, 1).hint(400, -1).applyTo((Control)manualServersIntro);
        manualServersIntro.setText(Messages.PreferencesPage_manualServers);
        manualServersIntro.addSelectionListener((SelectionListener)this.contentTypeLinkListener);
        this.viewer = new TableViewer(res);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.workingCopy = new ArrayList<ContentTypeToLSPLaunchConfigEntry>();
        this.workingCopy.addAll(LanguageServersRegistry.getInstance().getContentTypeToLSPLaunches());
        TableViewerColumn contentTypeColumn = new TableViewerColumn(this.viewer, 0);
        contentTypeColumn.getColumn().setText(Messages.PreferencesPage_contentType);
        contentTypeColumn.getColumn().setWidth(200);
        contentTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IContentType)((ContentTypeToLanguageServerDefinition)element).getKey()).getName();
            }
        });
        TableViewerColumn launchConfigColumn = new TableViewerColumn(this.viewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_LaunchConfiguration);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ContentTypeToLSPLaunchConfigEntry)element).getLaunchConfiguration().getName();
            }
        });
        TableViewerColumn launchModeColumn = new TableViewerColumn(this.viewer, 0);
        launchModeColumn.getColumn().setText(Messages.PreferencesPage_LaunchMode);
        launchModeColumn.getColumn().setWidth(100);
        launchModeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                StringBuilder res = new StringBuilder();
                for (String s : ((ContentTypeToLSPLaunchConfigEntry)element).getLaunchModes()) {
                    res.append(s);
                    res.append(',');
                }
                if (res.length() > 0) {
                    res.deleteCharAt(res.length() - 1);
                }
                return res.toString();
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getTable().setHeaderVisible(true);
        Composite buttonComposite = new Composite(res, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(4, 0, true, false));
        addButton.setText(Messages.PreferencesPage_Add);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewContentTypeLSPLaunchDialog dialog = new NewContentTypeLSPLaunchDialog(LanguageServerPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    LanguageServerPreferencePage.this.workingCopy.add(new ContentTypeToLSPLaunchConfigEntry(dialog.getContentType(), dialog.getLaunchConfiguration(), dialog.getLaunchMode()));
                    LanguageServerPreferencePage.this.viewer.refresh();
                }
                super.widgetSelected(e);
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.removeButton.setText(Messages.PreferencesPage_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = LanguageServerPreferencePage.this.viewer.getSelection();
                if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)sel).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        LanguageServerPreferencePage.this.workingCopy.remove(item);
                        ++n2;
                    }
                    LanguageServerPreferencePage.this.viewer.refresh();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LanguageServerPreferencePage.this.updateButtons();
            }
        });
        this.viewer.setInput(this.workingCopy);
        this.updateButtons();
        return res;
    }

    private void createStaticServersTable(Composite res) {
        Link staticServersIntro = new Link(res, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(2, 1).hint(400, -1).applyTo((Control)staticServersIntro);
        staticServersIntro.setText(Messages.PreferencesPage_staticServers);
        staticServersIntro.addSelectionListener((SelectionListener)this.contentTypeLinkListener);
        this.viewer = new TableViewer(res);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn contentTypeColumn = new TableViewerColumn(this.viewer, 0);
        contentTypeColumn.getColumn().setText(Messages.PreferencesPage_contentType);
        contentTypeColumn.getColumn().setWidth(200);
        contentTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IContentType)((ContentTypeToLanguageServerDefinition)element).getKey()).getName();
            }
        });
        TableViewerColumn launchConfigColumn = new TableViewerColumn(this.viewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_languageServer);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)element).getValue()).getLabel();
            }
        });
        this.viewer.setInput(LanguageServersRegistry.getInstance().getContentTypeToLSPExtensions());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.viewer.getTable().setHeaderVisible(true);
    }

    protected void updateButtons() {
        this.removeButton.setEnabled(!this.viewer.getSelection().isEmpty());
    }

    public boolean performOk() {
        this.registry.setAssociations(this.workingCopy);
        return super.performOk();
    }
}

