/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class LSSymbolsContentProvider
implements ICommonContentProvider,
ITreeContentProvider,
IDocumentListener,
IResourceChangeListener {
    public static final Object COMPUTING = new Object();
    private TreeViewer viewer;
    private Throwable lastError;
    private LanguageServiceAccessor.LSPDocumentInfo info;
    private SymbolsModel symbolsModel = new SymbolsModel();
    private CompletableFuture<List<? extends SymbolInformation>> symbols;
    private IResource resource;

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.info = (LanguageServiceAccessor.LSPDocumentInfo)newInput;
        this.info.getDocument().addDocumentListener((IDocumentListener)this);
        this.resource = LSPEclipseUtils.findResourceFor(this.info.getFileUri().toString());
        this.resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.refreshTreeContentFromLS();
    }

    public Object[] getElements(Object inputElement) {
        if (this.symbols != null && !this.symbols.isDone()) {
            return new Object[]{COMPUTING};
        }
        if (this.lastError != null) {
            return new Object[]{this.lastError};
        }
        return this.symbolsModel.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        return this.symbolsModel.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.symbolsModel.getParent(element);
    }

    public boolean hasChildren(Object parentElement) {
        Object[] children = this.symbolsModel.getChildren(parentElement);
        return children != null && children.length > 0;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.refreshTreeContentFromLS();
    }

    private void refreshTreeContentFromLS() {
        if (this.symbols != null && !this.symbols.isDone()) {
            this.symbols.cancel(true);
        }
        this.lastError = null;
        DocumentSymbolParams params = new DocumentSymbolParams(new TextDocumentIdentifier(this.info.getFileUri().toString()));
        this.symbols = this.info.getLanguageClient().getTextDocumentService().documentSymbol(params);
        this.symbols.thenAccept(t -> {
            this.symbolsModel.update((List<? extends SymbolInformation>)t);
            this.viewer.getControl().getDisplay().asyncExec(() -> this.viewer.refresh());
        });
        this.symbols.exceptionally(ex -> {
            this.lastError = ex;
            this.viewer.getControl().getDisplay().asyncExec(() -> this.viewer.refresh());
            return Collections.emptyList();
        });
    }

    public void dispose() {
        this.info.getDocument().removeDocumentListener((IDocumentListener)this);
        this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if ((event.getDelta().getFlags() ^ 0x20000) != 0) {
            try {
                event.getDelta().accept(delta -> {
                    if (delta.getResource().equals((Object)this.resource)) {
                        this.viewer.getControl().getDisplay().asyncExec(() -> {
                            if (this.viewer instanceof StructuredViewer) {
                                this.viewer.refresh(true);
                            }
                        });
                    }
                    return delta.getResource().getFullPath().isPrefixOf(this.resource.getFullPath());
                });
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

