/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codelens;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPCodeLensMenu
extends ContributionItem
implements IWorkbenchContribution {
    private LanguageServiceAccessor.LSPDocumentInfo info;

    public void initialize(IServiceLocator serviceLocator) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor) {
            this.info = LanguageServiceAccessor.getLSPDocumentInfoFor(LSPEclipseUtils.getDocument((ITextEditor)editor), capabilities -> Boolean.TRUE.equals(capabilities.getCodeLensProvider()));
        }
    }

    public void fill(final Menu menu, final int index) {
        final MenuItem item = new MenuItem(menu, 0, index);
        item.setEnabled(false);
        if (this.info == null) {
            item.setText(Messages.notImplemented);
            return;
        }
        item.setText(Messages.computing);
        CodeLensParams param = new CodeLensParams(new TextDocumentIdentifier(this.info.getFileUri().toString()));
        CompletableFuture codeLens = this.info.getLanguageClient().getTextDocumentService().codeLens(param);
        codeLens.whenComplete(new BiConsumer<List<? extends CodeLens>, Throwable>(){

            @Override
            public void accept(final List<? extends CodeLens> t, final Throwable u) {
                UIJob job = new UIJob(menu.getDisplay(), Messages.updateCodelensMenu_job){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (u != null) {
                            item.setText(u.getMessage());
                        } else {
                            for (CodeLens lens : t) {
                                if (lens == null) continue;
                                MenuItem item2 = new MenuItem(menu, 0, index);
                                item2.setText(lens.getCommand().getTitle());
                                item2.setEnabled(false);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        super.fill(menu, index);
    }
}

