/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.checkevent;

import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.AbstractDataAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.EventIdCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CheckEventAdapter
extends AbstractDataAdapter {
    public static final String CHECK_EVENTS = "check-events";
    public static final String RESULT = "result";
    public static final String UNIT_MASKS = "unit_masks";
    public static final String UNIT_MASK = "unit_mask";
    public static final String MASK = "mask";
    private Element event;
    private String eventName;
    private String unitMask;
    private Document resultDoc;
    private String returnCode;

    public CheckEventAdapter(String ctr, String event, String umask) {
        this.eventName = event;
        this.unitMask = umask;
        this.event = EventIdCache.getInstance().getElementWithName(this.eventName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.resultDoc = builder.newDocument();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void process() {
        this.setReturnCode();
        this.createXML();
    }

    private void setReturnCode() {
        if (!this.isValidUnitMask()) {
            this.returnCode = "invalid-um";
            return;
        }
        this.returnCode = "ok";
    }

    private boolean isValidUnitMask() {
        TreeSet<Integer> bitMaskSet = new TreeSet<Integer>();
        Element unitMasksTag = (Element)this.event.getElementsByTagName(UNIT_MASKS).item(0);
        if (unitMasksTag == null) {
            return true;
        }
        NodeList unitMasksList = unitMasksTag.getElementsByTagName(UNIT_MASK);
        int i = 0;
        while (i < unitMasksList.getLength()) {
            Element unitMaskElem = (Element)unitMasksList.item(i);
            String val = unitMaskElem.getAttribute(MASK);
            if (val.equals(this.unitMask)) {
                return true;
            }
            bitMaskSet.add(Integer.parseInt(val));
            ++i;
        }
        String unitMaskType = EventIdCache.getInstance().getUnitMaskType(this.eventName);
        if ("bitmask".equals(unitMaskType)) {
            int tmpVal = Integer.parseInt(this.unitMask);
            int count = 0;
            while (tmpVal != 0) {
                if (tmpVal % 2 != 0 && !bitMaskSet.contains((int)Math.pow(2.0, count))) {
                    return false;
                }
                tmpVal /= 2;
                ++count;
            }
            return true;
        }
        return false;
    }

    private void createXML() {
        Element resultRoot = this.resultDoc.createElement(CHECK_EVENTS);
        Element resultTag = this.resultDoc.createElement(RESULT);
        resultTag.setTextContent(this.returnCode);
        resultRoot.appendChild(resultTag);
        this.resultDoc.appendChild(resultRoot);
    }

    @Override
    public Document getDocument() {
        return this.resultDoc;
    }
}

