/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.libra.framework.core.FrameworkInstanceDelegate;
import org.eclipse.libra.framework.core.IOSGIFrameworkInstance;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.ui.Messages;
import org.eclipse.libra.framework.ui.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.ui.wizards.target.EditTargetDefinitionWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class FrameworkInstanceLocationEditorSection
extends ServerEditorSection {
    protected Section section;
    protected IOSGIFrameworkInstance frameworkInstance;
    protected boolean defaultDeployDirIsSet;
    protected Button frameworkInstanceDirCustom;
    protected Text frameworkInstanceDir;
    protected Button frameworkInstanceDirBrowse;
    protected Text targetPlatformName;
    protected Button targetPlatformEdit;
    protected PropertyChangeListener listener;
    protected IPublishListener publishListener;
    protected IPath workspacePath;
    protected boolean allowRestrictedEditing;
    protected IPath tempDirPath;
    protected IPath installDirPath;
    protected boolean updating = false;

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (FrameworkInstanceLocationEditorSection.this.updating) {
                    return;
                }
                FrameworkInstanceLocationEditorSection.this.updating = true;
                if ("instanceDir".equals(event.getPropertyName())) {
                    FrameworkInstanceLocationEditorSection.this.updateServerDirButtons();
                    FrameworkInstanceLocationEditorSection.this.updateServerDirFields();
                    FrameworkInstanceLocationEditorSection.this.validate();
                }
                FrameworkInstanceLocationEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.publishListener = new PublishAdapter(){

            public void publishFinished(IServer server2, IStatus status) {
                boolean flag = false;
                if (status.isOK() && server2.getModules().length == 0) {
                    flag = true;
                }
                if (flag != FrameworkInstanceLocationEditorSection.this.allowRestrictedEditing) {
                    FrameworkInstanceLocationEditorSection.this.allowRestrictedEditing = flag;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            boolean customServerDir = false;
                            if (!(this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDirCustom.isDisposed()) {
                                customServerDir = (this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDirCustom.getSelection();
                            }
                            if (!(this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDirCustom.isDisposed()) {
                                (this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDirCustom.setEnabled((this).FrameworkInstanceLocationEditorSection.this.allowRestrictedEditing);
                            }
                            if (!(this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDir.isDisposed()) {
                                (this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDir.setEnabled((this).FrameworkInstanceLocationEditorSection.this.allowRestrictedEditing && customServerDir);
                            }
                            if (!(this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDirBrowse.isDisposed()) {
                                (this).FrameworkInstanceLocationEditorSection.this.frameworkInstanceDirBrowse.setEnabled((this).FrameworkInstanceLocationEditorSection.this.allowRestrictedEditing && customServerDir);
                            }
                        }
                    });
                }
            }
        };
        this.server.getOriginal().addPublishListener(this.publishListener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Messages.serverEditorLocationsSection);
        this.section.setDescription(Messages.serverEditorLocationsDescription);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.libra.framework.ui.teig0000");
        whs.setHelp((Control)this.section, "org.eclipse.libra.framework.ui.teig0000");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        this.frameworkInstanceDirCustom = toolkit.createButton(composite, NLS.bind((String)Messages.serverEditorServerDirCustom, (Object)Messages.serverEditorDoesNotModify), 16);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.frameworkInstanceDirCustom.setLayoutData((Object)data);
        this.frameworkInstanceDirCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FrameworkInstanceLocationEditorSection.this.updating || !FrameworkInstanceLocationEditorSection.this.frameworkInstanceDirCustom.getSelection()) {
                    return;
                }
                FrameworkInstanceLocationEditorSection.this.updating = true;
                FrameworkInstanceLocationEditorSection.this.updateServerDirFields();
                FrameworkInstanceLocationEditorSection.this.updating = false;
                FrameworkInstanceLocationEditorSection.this.validate();
            }
        });
        Label label = this.createLabel(toolkit, composite, Messages.serverEditorServerDir);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.frameworkInstanceDir = toolkit.createText(composite, null, 4);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 75;
        this.frameworkInstanceDir.setLayoutData((Object)data);
        this.frameworkInstanceDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FrameworkInstanceLocationEditorSection.this.updating) {
                    return;
                }
                FrameworkInstanceLocationEditorSection.this.updating = true;
                FrameworkInstanceLocationEditorSection.this.updating = false;
                FrameworkInstanceLocationEditorSection.this.validate();
            }
        });
        this.frameworkInstanceDirBrowse = toolkit.createButton(composite, Messages.editorBrowse, 8);
        this.frameworkInstanceDirBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(FrameworkInstanceLocationEditorSection.this.frameworkInstanceDir.getShell());
                dialog.setMessage(Messages.serverEditorBrowseDeployMessage);
                dialog.setFilterPath(FrameworkInstanceLocationEditorSection.this.frameworkInstanceDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null && !selectedDirectory.equals(FrameworkInstanceLocationEditorSection.this.frameworkInstanceDir.getText())) {
                    FrameworkInstanceLocationEditorSection.this.updating = true;
                    FrameworkInstanceLocationEditorSection.this.updateServerDirButtons();
                    FrameworkInstanceLocationEditorSection.this.updateServerDirFields();
                    FrameworkInstanceLocationEditorSection.this.updating = false;
                    FrameworkInstanceLocationEditorSection.this.validate();
                }
            }
        });
        this.frameworkInstanceDirBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label label2 = this.createLabel(toolkit, composite, "Target Platform");
        data = new GridData(1, 0x1000000, false, false);
        label2.setLayoutData((Object)data);
        this.targetPlatformName = toolkit.createText(composite, null, 4);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 75;
        this.targetPlatformName.setLayoutData((Object)data);
        this.targetPlatformEdit = toolkit.createButton(composite, "Edit...", 8);
        this.targetPlatformEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FrameworkInstanceLocationEditorSection.this.handleEdit();
            }
        });
        this.targetPlatformEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
            if (this.server.getOriginal() != null) {
                this.server.getOriginal().removePublishListener(this.publishListener);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.workspacePath = root.getLocation();
        if (this.server != null) {
            this.frameworkInstance = (FrameworkInstanceDelegate)this.server.loadAdapter(FrameworkInstanceDelegate.class, null);
            this.addChangeListeners();
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.frameworkInstanceDir == null || this.frameworkInstance == null) {
            return;
        }
        this.updating = true;
        IRuntime runtime = this.server.getRuntime();
        this.section.setDescription(Messages.serverEditorLocationsDescription2);
        if (runtime != null) {
            this.installDirPath = runtime.getLocation();
        }
        this.allowRestrictedEditing = false;
        Path basePath = new Path(this.frameworkInstance.getInstanceDirectory());
        if (!this.readOnly && (basePath != null && !basePath.append("conf").toFile().exists() || this.server.getOriginal().getServerPublishState() == 1 && this.server.getOriginal().getModules().length == 0)) {
            this.allowRestrictedEditing = true;
        }
        try {
            if (this.frameworkInstance != null && this.frameworkInstance.getFrameworkInstanceConfiguration() != null) {
                ITargetDefinition original = this.frameworkInstance.getFrameworkInstanceConfiguration().getTargetDefinition();
                this.targetPlatformName.setText(original.getName());
                this.targetPlatformName.setEditable(false);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.updateServerDirButtons();
        this.updateServerDirFields();
        this.updating = false;
        this.validate();
    }

    protected String getServerDir() {
        String dir = null;
        if (this.frameworkInstanceDir != null) {
            dir = this.frameworkInstanceDir.getText().trim();
            Path path = new Path(dir);
            if (this.tempDirPath != null && this.tempDirPath.equals((Object)path)) {
                dir = null;
            }
        }
        return dir;
    }

    protected void updateServerDirButtons() {
        if (this.frameworkInstance.getInstanceDirectory() == null) {
            Path path = new Path(this.frameworkInstance.getInstanceDirectory());
            if (path != null && path.equals((Object)this.installDirPath)) {
                this.frameworkInstanceDirCustom.setSelection(false);
            } else {
                this.frameworkInstanceDirCustom.setSelection(false);
            }
        } else {
            this.frameworkInstanceDirCustom.setSelection(false);
        }
    }

    protected void updateServerDirFields() {
        this.updateServerDir();
        boolean customServerDir = this.frameworkInstanceDirCustom.getSelection();
        this.frameworkInstanceDir.setEnabled(this.allowRestrictedEditing && customServerDir);
        this.frameworkInstanceDirBrowse.setEnabled(this.allowRestrictedEditing && customServerDir);
    }

    protected void updateServerDir() {
        Path path = new Path(this.frameworkInstance.getInstanceDirectory());
        this.frameworkInstanceDir.setText(path.toOSString());
    }

    public IStatus[] getSaveStatus() {
        String dir;
        if (this.frameworkInstance != null && (dir = this.frameworkInstance.getInstanceDirectory()) != null) {
            Path path = new Path(dir);
            if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                return new IStatus[]{new Status(4, "org.eclipse.libra.framework.ui", Messages.errorServerDirIsRoot)};
            }
            if (path.equals((Object)this.installDirPath)) {
                return new IStatus[]{new Status(4, "org.eclipse.libra.framework.ui", NLS.bind((String)Messages.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Messages.serverEditorServerDirInstall, (Object)"").trim()))};
            }
        }
        return super.getSaveStatus();
    }

    protected void validate() {
        String dir;
        if (this.frameworkInstance != null && (dir = this.frameworkInstance.getInstanceDirectory()) != null) {
            Path path = new Path(dir);
            if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                this.setErrorMessage(Messages.errorServerDirIsRoot);
                return;
            }
            if (path.equals((Object)this.installDirPath)) {
                this.setErrorMessage(NLS.bind((String)Messages.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Messages.serverEditorServerDirInstall, (Object)"").trim()));
                return;
            }
        }
        this.setErrorMessage(null);
    }

    protected void handleEdit() {
        try {
            if (this.frameworkInstance != null && this.frameworkInstance.getFrameworkInstanceConfiguration() != null) {
                ITargetDefinition original = this.frameworkInstance.getFrameworkInstanceConfiguration().getTargetDefinition();
                EditTargetDefinitionWizard wizard = new EditTargetDefinitionWizard(original, true);
                wizard.setWindowTitle(Messages.configurationEditorTargetDefinitionTitle);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ITargetDefinition newTarget = wizard.getTargetDefinition();
                    this.frameworkInstance.getFrameworkInstanceConfiguration().setTargetDefinition(newTarget);
                    ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
                    service.saveTargetDefinition(newTarget);
                }
            }
        }
        catch (CoreException coreException) {
            Trace.trace((byte)2, "failed to update target platform definition");
        }
    }
}

