/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IModelElementSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.ElementSynchronizerImpl;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.SeiMerger;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.SeiMethodSynchronizer;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeiSynchronizer
extends ElementSynchronizerImpl {
    private final SeiMerger seiMerger = new SeiMerger(this, new SeiMethodSynchronizer(this));

    public SeiSynchronizer(IModelElementSynchronizer parent) {
        super(parent);
    }

    public void synchronizeInterface(IWebServiceProject wsProject, IAnnotation<IType> wsAnnotation, IAnnotationInspector inspector) throws JavaModelException {
        if (((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName() == null) {
            return;
        }
        IServiceEndpointInterface sei = this.obtainInstance(wsProject, ((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName());
        this.seiMerger.merge(sei, wsAnnotation, inspector);
        this.resolveWsRefsToThisSei(sei);
        this.resource().getSerializerFactory().adapt((Notifier)sei, IAnnotationSerializer.class);
    }

    private IServiceEndpointInterface obtainInstance(IWebServiceProject wsProject, String implName) {
        IServiceEndpointInterface sei = null;
        for (IServiceEndpointInterface existing : wsProject.getServiceEndpointInterfaces()) {
            if (!existing.getImplementation().equals(implName)) continue;
            sei = existing;
        }
        if (sei == null) {
            sei = this.domFactory().createIServiceEndpointInterface();
            this.util().setFeatureValue(sei, 0, implName);
            wsProject.getServiceEndpointInterfaces().add((Object)sei);
        }
        this.util().setFeatureValue(sei, 2, false);
        return sei;
    }

    private void resolveWsRefsToThisSei(IServiceEndpointInterface sei) {
        for (IWebService ws : this.serviceData().getImplementingWs(sei.getImplementation())) {
            if (ws.getServiceEndpoint() == sei) continue;
            this.util().setFeatureValue(ws, 2, sei);
        }
    }
}

