/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.VirtualOverrideRelationship;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericOrmVirtualOverrideJoinColumnRelationshipStrategy
extends AbstractOrmXmlContextModel<VirtualOverrideRelationship>
implements VirtualJoinColumnRelationshipStrategy {
    protected final AbstractJpaContextModel.ContextListContainer<VirtualJoinColumn, JoinColumn> specifiedJoinColumnContainer;
    protected final JoinColumn.ParentAdapter joinColumnParentAdapter = this.buildJoinColumnParentAdapter();
    protected VirtualJoinColumn defaultJoinColumn;

    public GenericOrmVirtualOverrideJoinColumnRelationshipStrategy(VirtualOverrideRelationship parent) {
        super(parent);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateSpecifiedJoinColumns(monitor);
        this.updateDefaultJoinColumn(monitor);
    }

    public ListIterable<VirtualJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    public ListIterable<VirtualJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer;
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public VirtualJoinColumn getSpecifiedJoinColumn(int index) {
        return (VirtualJoinColumn)this.specifiedJoinColumnContainer.get(index);
    }

    protected void updateSpecifiedJoinColumns(IProgressMonitor monitor) {
        this.specifiedJoinColumnContainer.update(monitor);
    }

    protected ListIterable<JoinColumn> getOverriddenSpecifiedJoinColumns() {
        JoinColumnRelationshipStrategy overriddenStrategy = this.getOverriddenStrategy();
        return overriddenStrategy == null ? EmptyListIterable.instance() : new SuperListIterableWrapper(overriddenStrategy.getSpecifiedJoinColumns());
    }

    protected AbstractJpaContextModel.ContextListContainer<VirtualJoinColumn, JoinColumn> buildSpecifiedJoinColumnContainer() {
        return this.buildVirtualContextListContainer("specifiedJoinColumns", new SpecifiedJoinColumnContainerAdapter());
    }

    protected JoinColumn.ParentAdapter buildJoinColumnParentAdapter() {
        return new JoinColumnParentAdapter();
    }

    @Override
    public VirtualJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(VirtualJoinColumn joinColumn) {
        VirtualJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<VirtualJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn(IProgressMonitor monitor) {
        JoinColumn overriddenDefaultJoinColumn = this.getOverriddenDefaultJoinColumn();
        if (overriddenDefaultJoinColumn == null) {
            if (this.defaultJoinColumn != null) {
                this.setDefaultJoinColumn(null);
            }
        } else if (this.defaultJoinColumn != null && this.defaultJoinColumn.getOverriddenColumn() == overriddenDefaultJoinColumn) {
            this.defaultJoinColumn.update(monitor);
        } else {
            this.setDefaultJoinColumn(this.buildJoinColumn(overriddenDefaultJoinColumn));
        }
    }

    protected JoinColumn getOverriddenDefaultJoinColumn() {
        JoinColumnRelationshipStrategy overriddenStrategy = this.getOverriddenStrategy();
        return overriddenStrategy == null ? null : overriddenStrategy.getDefaultJoinColumn();
    }

    @Override
    public VirtualOverrideRelationship getRelationship() {
        return (VirtualOverrideRelationship)this.parent;
    }

    protected JoinColumnRelationshipStrategy getOverriddenStrategy() {
        JoinColumnRelationship relationship = this.getOverriddenJoinColumnRelationship();
        return relationship == null ? null : relationship.getJoinColumnStrategy();
    }

    protected JoinColumnRelationship getOverriddenJoinColumnRelationship() {
        Relationship relationship = this.resolveOverriddenRelationship();
        return relationship instanceof JoinColumnRelationship ? (JoinColumnRelationship)relationship : null;
    }

    protected Relationship resolveOverriddenRelationship() {
        return this.getRelationship().resolveOverriddenRelationship();
    }

    @Override
    public boolean isTargetForeignKey() {
        RelationshipMapping relationshipMapping = this.getRelationshipMapping();
        return relationshipMapping != null && relationshipMapping.getRelationship().isTargetForeignKey();
    }

    @Override
    public TypeMapping getRelationshipSource() {
        return this.isTargetForeignKey() ? this.getRelationshipMapping().getResolvedTargetEntity() : this.getRelationship().getTypeMapping();
    }

    @Override
    public TypeMapping getRelationshipTarget() {
        return this.isTargetForeignKey() ? this.getRelationship().getTypeMapping() : this.getRelationshipMappingTargetEntity();
    }

    protected TypeMapping getRelationshipMappingTargetEntity() {
        RelationshipMapping mapping = this.getRelationshipMapping();
        return mapping == null ? null : mapping.getResolvedTargetEntity();
    }

    protected Entity getRelationshipTargetEntity() {
        TypeMapping target = this.getRelationshipTarget();
        return target instanceof Entity ? (Entity)target : null;
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        return this.isTargetForeignKey() ? this.getTargetDefaultTableName() : this.getRelationship().getDefaultTableName();
    }

    protected String getTargetDefaultTableName() {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    protected Table resolveDbTable(String tableName) {
        return this.isTargetForeignKey() ? this.resolveTargetDbTable(tableName) : this.getRelationship().resolveDbTable(tableName);
    }

    protected Table resolveTargetDbTable(String tableName) {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    protected boolean tableNameIsInvalid(String tableName) {
        return this.isTargetForeignKey() ? this.targetTableNameIsInvalid(tableName) : this.getRelationship().tableNameIsInvalid(tableName);
    }

    protected boolean targetTableNameIsInvalid(String tableName) {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    protected Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterable<String> getCandidateTableNames() {
        return this.isTargetForeignKey() ? this.getTargetCandidateTableNames() : this.getRelationship().getCandidateTableNames();
    }

    protected Iterable<String> getTargetCandidateTableNames() {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping != null ? typeMapping.getAllAssociatedTableNames() : EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationship().getValidationTextRange();
    }

    protected String getAttributeName() {
        return this.getRelationship().getAttributeName();
    }

    protected VirtualJoinColumn buildJoinColumn(JoinColumn overriddenJoinColumn) {
        return this.getContextModelFactory().buildOrmVirtualJoinColumn(this.joinColumnParentAdapter, overriddenJoinColumn);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (VirtualJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter);
        }
    }

    public class JoinColumnParentAdapter
    implements JoinColumn.ParentAdapter {
        @Override
        public JpaContextModel getColumnParent() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this;
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getTableName();
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            return MappingTools.buildJoinColumnDefaultName((JoinColumn)column, this);
        }

        @Override
        public String getAttributeName() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getAttributeName();
        }

        @Override
        public Entity getRelationshipTarget() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getRelationshipTargetEntity();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.tableNameIsInvalid(tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getCandidateTableNames();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.resolveDbTable(tableName);
        }

        @Override
        public Table getReferencedColumnDbTable() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getReferencedColumnDbTable();
        }

        @Override
        public int getJoinColumnsSize() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getJoinColumnsSize();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getValidationTextRange();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getRelationship().buildColumnValidator((BaseColumn)column, this);
        }
    }

    public class SpecifiedJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<VirtualJoinColumn, JoinColumn> {
        public SpecifiedJoinColumnContainerAdapter() {
            super(GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this);
        }

        @Override
        public VirtualJoinColumn buildContextElement(JoinColumn resourceElement) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.buildJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<JoinColumn> getResourceElements() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getOverriddenSpecifiedJoinColumns();
        }

        @Override
        public JoinColumn extractResourceElement(VirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }
    }
}

