/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.internal.logging.aeri.ide.processors.EditableReportProcessorSafeWrapper;
import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.ide.processors.IEditableReportProcessor;
import org.osgi.framework.Bundle;

import com.google.common.base.Throwables;

public class CreateReportProcessorHandler {
    @Execute
    public ReportProcessorSafeWrapper execute(String providerClass, IEclipseContext context, String contributor) {
        Bundle ext = Platform.getBundle(contributor);
        try {
            Class<? extends IReportProcessor> clazz = (Class<? extends IReportProcessor>) ext.loadClass(providerClass);
            IReportProcessor reportProcessor = ContextInjectionFactory.make(clazz, context);
            if (reportProcessor instanceof IEditableReportProcessor) {
                return new EditableReportProcessorSafeWrapper((IEditableReportProcessor) reportProcessor);
            } else {
                return new ReportProcessorSafeWrapper(reportProcessor);
            }
        } catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}
