/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.environment;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.ui.environment.Messages;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LocalEnvironmentUI
implements IEnvironmentUI {
    @Override
    public String selectFolder(Shell shell) {
        return this.selectFolder(shell, null);
    }

    @Override
    public String selectFolder(Shell shell, String initialFolder) {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        if (initialFolder != null) {
            dialog.setFilterPath(initialFolder);
        }
        return dialog.open();
    }

    @Override
    public String selectFile(Shell shell, int fileType) {
        return this.selectFile(shell, fileType, null);
    }

    @Override
    public String selectFile(Shell shell, int fileType, String initialSelection) {
        Path path;
        FileDialog dialog = new FileDialog(shell);
        if (initialSelection != null && initialSelection.length() != 0 && (path = new Path(initialSelection)).segmentCount() > 0) {
            if (path.toFile().isFile()) {
                dialog.setFilterPath(path.removeLastSegments(1).toOSString());
                dialog.setFileName(path.lastSegment());
            } else {
                dialog.setFilterPath(path.toOSString());
            }
        }
        if (fileType == 1) {
            if (Platform.getOS().equals("win32")) {
                dialog.setFilterExtensions(new String[]{"*.exe;*.bat;*.exe"});
            } else {
                dialog.setFilterExtensions(new String[]{"*"});
            }
            dialog.setFilterNames(new String[]{Messages.LocalEnvironmentUI_executables});
        }
        return dialog.open();
    }
}

