/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ContainerNode;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ClassMemberInserter;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.AccessorDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterContext;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodDefinitionInsertLocationFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.Checks;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class GenerateGettersAndSettersRefactoring
extends CRefactoring {
    private final GetterSetterContext context = new GetterSetterContext();
    private InsertLocation definitionInsertLocation;

    public GenerateGettersAndSettersRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        if (status.hasError()) {
            return status;
        }
        if (!this.initStatus.hasFatalError()) {
            this.initRefactoring(pm);
            if (this.context.existingFields.isEmpty()) {
                this.initStatus.addFatalError(Messages.GenerateGettersAndSettersRefactoring_NoFields);
            }
        }
        return this.initStatus;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.context.isDefinitionSeparate()) {
            this.findDefinitionInsertLocation(pm);
            if (this.definitionInsertLocation == null || this.definitionInsertLocation.getTranslationUnit() == null) {
                status.addInfo(Messages.GenerateGettersAndSettersRefactoring_NoImplFile);
            }
        }
        Checks.addModifiedFilesToChecker(this.getAllFilesToModify(), checkContext);
        return status;
    }

    private IFile[] getAllFilesToModify() {
        ArrayList<IFile> files = new ArrayList<IFile>(2);
        IFile file = (IFile)this.tu.getResource();
        if (file != null) {
            files.add(file);
        }
        if (this.definitionInsertLocation != null && (file = this.definitionInsertLocation.getFile()) != null) {
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    private void initRefactoring(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        IASTTranslationUnit ast = this.getAST(this.tu, null);
        this.context.selectedName = this.getSelectedName(ast);
        IASTCompositeTypeSpecifier compositeTypeSpecifier = null;
        compositeTypeSpecifier = this.context.selectedName != null ? this.getCompositeTypeSpecifier(this.context.selectedName) : this.findCurrentCompositeTypeSpecifier(ast);
        if (compositeTypeSpecifier != null) {
            this.findDeclarations(compositeTypeSpecifier);
        } else {
            this.initStatus.addFatalError(Messages.GenerateGettersAndSettersRefactoring_NoClassDefFound);
        }
    }

    private IASTCompositeTypeSpecifier findCurrentCompositeTypeSpecifier(IASTTranslationUnit ast) throws OperationCanceledException, CoreException {
        int start = this.selectedRegion.getOffset();
        Container container = new Container();
        ast.accept((ASTVisitor)new CompositeTypeSpecFinder(start, container));
        return (IASTCompositeTypeSpecifier)container.getObject();
    }

    private IASTCompositeTypeSpecifier getCompositeTypeSpecifier(IASTName selectedName) {
        IASTName node = selectedName;
        while (node != null && !(node instanceof IASTCompositeTypeSpecifier)) {
            node = node.getParent();
        }
        return (IASTCompositeTypeSpecifier)node;
    }

    private IASTName getSelectedName(IASTTranslationUnit ast) {
        List<IASTName> names = this.findAllMarkedNames(ast);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(names.size() - 1);
    }

    protected void findDeclarations(IASTCompositeTypeSpecifier compositeTypeSpecifier) {
        compositeTypeSpecifier.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                IASTFunctionDefinition functionDefinition;
                if (declaration instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declaration;
                    if (simpleDeclaration.getPropertyInParent() == IASTCompositeTypeSpecifier.MEMBER_DECLARATION) {
                        IASTDeclarator[] iASTDeclaratorArray = simpleDeclaration.getDeclarators();
                        int n = iASTDeclaratorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTDeclarator declarator;
                            IASTDeclarator innermostDeclarator = declarator = iASTDeclaratorArray[n2];
                            while (innermostDeclarator.getNestedDeclarator() != null) {
                                innermostDeclarator = innermostDeclarator.getNestedDeclarator();
                            }
                            if (innermostDeclarator instanceof IASTFunctionDeclarator) {
                                ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDeclarations.add(simpleDeclaration);
                            } else if (simpleDeclaration.isPartOfTranslationUnitFile()) {
                                ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFields.add(declarator);
                            }
                            ++n2;
                        }
                    }
                } else if (declaration instanceof IASTFunctionDefinition && (functionDefinition = (IASTFunctionDefinition)declaration).getPropertyInParent() == IASTCompositeTypeSpecifier.MEMBER_DECLARATION) {
                    ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDefinitions.add(functionDefinition);
                }
                return super.visit(declaration);
            }
        });
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        ArrayList<IASTNode> getterAndSetters = new ArrayList<IASTNode>();
        ArrayList<IASTFunctionDefinition> definitions = new ArrayList<IASTFunctionDefinition>();
        ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)ASTQueries.findAncestorWithType((IASTNode)((IASTNode)this.context.existingFields.get(0)), ICPPASTCompositeTypeSpecifier.class);
        for (AccessorDescriptor accessor : this.context.selectedAccessors) {
            CPPASTName accessorName = new CPPASTName(accessor.toString().toCharArray());
            if (this.context.isDefinitionSeparate()) {
                getterAndSetters.add((IASTNode)accessor.getAccessorDeclaration());
                ICPPASTQualifiedName declaratorName = NameHelper.createQualifiedNameFor((IASTName)accessorName, classDefinition.getTranslationUnit().getOriginatingTranslationUnit(), classDefinition.getFileLocation().getNodeOffset(), this.definitionInsertLocation.getTranslationUnit(), this.definitionInsertLocation.getInsertPosition(), this.refactoringContext);
                IASTFunctionDefinition functionDefinition = accessor.getAccessorDefinition((IASTName)declaratorName);
                if (this.definitionInsertLocation.getTranslationUnit().isHeaderUnit()) {
                    functionDefinition.getDeclSpecifier().setInline(true);
                }
                definitions.add(functionDefinition);
                continue;
            }
            getterAndSetters.add((IASTNode)accessor.getAccessorDefinition((IASTName)accessorName));
        }
        if (this.context.isDefinitionSeparate()) {
            this.addDefinition(collector, definitions, pm);
        }
        ClassMemberInserter.createChange(classDefinition, VisibilityEnum.v_public, getterAndSetters, false, collector);
    }

    private void addDefinition(ModificationCollector collector, List<IASTFunctionDefinition> definitions, IProgressMonitor pm) throws CoreException {
        this.findDefinitionInsertLocation(pm);
        IASTNode parent = this.definitionInsertLocation.getParentOfNodeToInsertBefore();
        IASTTranslationUnit ast = parent.getTranslationUnit();
        ASTRewrite rewrite = collector.rewriterForTranslationUnit(ast);
        IASTNode nodeToInsertBefore = this.definitionInsertLocation.getNodeToInsertBefore();
        ContainerNode cont = new ContainerNode(new IASTNode[0]);
        for (IASTFunctionDefinition functionDefinition : definitions) {
            cont.addNode((IASTNode)functionDefinition);
        }
        rewrite = rewrite.insertBefore(parent, nodeToInsertBefore, (IASTNode)cont, null);
    }

    public GetterSetterContext getContext() {
        return this.context;
    }

    private void findDefinitionInsertLocation(IProgressMonitor pm) throws CoreException {
        if (this.definitionInsertLocation != null) {
            return;
        }
        MethodDefinitionInsertLocationFinder locationFinder = new MethodDefinitionInsertLocationFinder();
        IASTSimpleDeclaration decl = (IASTSimpleDeclaration)ASTQueries.findAncestorWithType((IASTNode)((IASTNode)this.context.existingFields.get(0)), IASTSimpleDeclaration.class);
        InsertLocation location = locationFinder.find(this.tu, decl.getFileLocation(), decl.getParent(), this.refactoringContext, pm);
        if (location.getFile() == null || NodeHelper.isContainedInTemplateDeclaration((IASTNode)decl)) {
            location.setNodeToInsertAfter(NodeHelper.findTopLevelParent((IASTNode)decl), this.tu);
        }
        this.definitionInsertLocation = location;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        return null;
    }

    private final class CompositeTypeSpecFinder
    extends ASTVisitor {
        private final int start;
        private final Container<IASTCompositeTypeSpecifier> container;

        private CompositeTypeSpecFinder(int start, Container<IASTCompositeTypeSpecifier> container) {
            this.shouldVisitDeclSpecifiers = true;
            this.start = start;
            this.container = container;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            IASTFileLocation loc;
            if (declSpec instanceof IASTCompositeTypeSpecifier && this.start > (loc = declSpec.getFileLocation()).getNodeOffset() && this.start < loc.getNodeOffset() + loc.getNodeLength()) {
                this.container.setObject((IASTCompositeTypeSpecifier)declSpec);
                return 2;
            }
            return super.visit(declSpec);
        }
    }
}

