/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.ui.view.TestPathUtils;
import org.eclipse.cdt.testsrunner.internal.ui.view.UIViewMessages;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.CopySelectedTestsAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.RedebugSelectedAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.RelaunchSelectedAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.RerunSelectedAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.TestsHierarchyCollapseAllAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.TestsHierarchyExpandAllAction;
import org.eclipse.cdt.testsrunner.model.IModelVisitor;
import org.eclipse.cdt.testsrunner.model.ITestCase;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestSuite;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;

public class TestsHierarchyViewer {
    private ITestingSession testingSession;
    private TreeViewer treeViewer;
    private boolean showTime = true;
    private boolean showTestsHierarchy = true;
    private FailedOnlyFilter failedOnlyFilter = null;
    private Clipboard clipboard;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action copyAction;
    private RelaunchSelectedAction rerunAction;
    private RelaunchSelectedAction redebugAction;

    public TestsHierarchyViewer(Composite parent, IViewSite viewSite, Clipboard clipboard) {
        this.clipboard = clipboard;
        this.treeViewer = new TreeViewer(parent, 514);
        this.treeViewer.setContentProvider((IContentProvider)new TestTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TestLabelProvider()));
        this.initContextMenu(viewSite);
    }

    private void initContextMenu(IViewSite viewSite) {
        this.expandAllAction = new TestsHierarchyExpandAllAction((AbstractTreeViewer)this.treeViewer);
        this.collapseAllAction = new TestsHierarchyCollapseAllAction((AbstractTreeViewer)this.treeViewer);
        this.copyAction = new CopySelectedTestsAction(this.treeViewer, this.clipboard);
        this.rerunAction = new RerunSelectedAction(this.testingSession, this.treeViewer);
        this.redebugAction = new RedebugSelectedAction(this.testingSession, this.treeViewer);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestsHierarchyViewer.this.handleMenuAboutToShow(manager);
            }
        });
        viewSite.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        menuMgr.add((IAction)this.copyAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.rerunAction);
        menuMgr.add((IAction)this.redebugAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.expandAllAction);
        menuMgr.add((IAction)this.collapseAllAction);
        IActionBars actionBars = viewSite.getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.updateActionBars();
    }

    private void handleMenuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        boolean isRelaunchEnabledForSelection = !selection.isEmpty() && (this.testingSession.getTestsRunnerProviderInfo().isAllowedMultipleTestFilter() || selection.size() == 1);
        this.rerunAction.setEnabled(isRelaunchEnabledForSelection);
        this.rerunAction.setTestingSession(this.testingSession);
        this.redebugAction.setEnabled(isRelaunchEnabledForSelection);
        this.redebugAction.setTestingSession(this.testingSession);
        this.copyAction.setEnabled(!selection.isEmpty());
        boolean hasAnything = this.treeViewer.getInput() != null;
        this.expandAllAction.setEnabled(hasAnything);
        this.collapseAllAction.setEnabled(hasAnything);
    }

    public void setTestingSession(ITestingSession testingSession) {
        this.testingSession = testingSession;
        this.treeViewer.setInput(testingSession != null ? testingSession.getModelAccessor().getRootSuite() : null);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void showNextFailure() {
        this.showFailure(true);
    }

    public void showPreviousFailure() {
        this.showFailure(false);
    }

    private void showFailure(boolean next) {
        ITestItem failedItem;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        ITestItem selected = (ITestItem)selection.getFirstElement();
        if (selected == null) {
            ITestItem rootSuite = (ITestItem)this.treeViewer.getInput();
            failedItem = this.findFailedImpl(rootSuite, null, next, next);
        } else {
            failedItem = this.findFailedImpl(selected.getParent(), selected, next, next);
        }
        if (failedItem != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)failedItem), true);
        }
    }

    private ITestItem findFailedImpl(ITestItem parentItem, ITestItem currItem, boolean next, boolean checkCurrentChild) {
        ITestItem result = this.findFailedChild(parentItem, currItem, next, checkCurrentChild);
        if (result != null) {
            return result;
        }
        ITestSuite grandParentItem = parentItem.getParent();
        if (grandParentItem != null) {
            return this.findFailedImpl(grandParentItem, parentItem, next, false);
        }
        return null;
    }

    private ITestItem findFailedChild(ITestItem parentItem, ITestItem currItem, boolean next, boolean checkCurrentChild) {
        ITestItem[] children = parentItem.getChildren();
        boolean doSearch = currItem == null;
        int increment = next ? 1 : -1;
        int startIndex = next ? 0 : children.length - 1;
        int endIndex = next ? children.length : -1;
        int index = startIndex;
        while (index != endIndex) {
            ITestItem result;
            ITestItem item = children[index];
            if (doSearch && item instanceof ITestCase && item.getStatus().isError()) {
                return item;
            }
            if (checkCurrentChild && item == currItem) {
                doSearch = true;
            }
            if (doSearch && (result = this.findFailedChild(item, null, next, checkCurrentChild)) != null) {
                return result;
            }
            if (!checkCurrentChild && item == currItem) {
                doSearch = true;
            }
            index += increment;
        }
        return null;
    }

    public boolean showTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        if (this.showTime != showTime) {
            this.showTime = showTime;
            this.getTreeViewer().refresh();
        }
    }

    public void setShowFailedOnly(boolean showFailedOnly) {
        if (this.failedOnlyFilter == null) {
            this.failedOnlyFilter = new FailedOnlyFilter();
        }
        if (showFailedOnly) {
            this.getTreeViewer().addFilter((ViewerFilter)this.failedOnlyFilter);
        } else {
            this.getTreeViewer().removeFilter((ViewerFilter)this.failedOnlyFilter);
        }
    }

    public boolean showTestsHierarchy() {
        return this.showTestsHierarchy;
    }

    public void setShowTestsHierarchy(boolean showTestsHierarchy) {
        if (this.showTestsHierarchy != showTestsHierarchy) {
            this.showTestsHierarchy = showTestsHierarchy;
            this.getTreeViewer().refresh();
        }
    }

    private class FailedOnlyFilter
    extends ViewerFilter {
        private FailedOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return ((ITestItem)element).getStatus().isError();
        }
    }

    private class TestLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private Map<ITestItem.Status, Image> testCaseImages = new HashMap<ITestItem.Status, Image>();
        private Image testCaseRunImage;
        private Map<ITestItem.Status, Image> testSuiteImages;
        private Image testSuiteRunImage;
        private ITestItem lastTestItemCache;
        private String lastTestItemPathCache;

        private TestLabelProvider() {
            this.testCaseImages.put(ITestItem.Status.NotRun, TestsRunnerPlugin.createAutoImage("obj16/test_notrun.gif"));
            this.testCaseImages.put(ITestItem.Status.Skipped, TestsRunnerPlugin.createAutoImage("obj16/test_skipped.gif"));
            this.testCaseImages.put(ITestItem.Status.Passed, TestsRunnerPlugin.createAutoImage("obj16/test_passed.gif"));
            this.testCaseImages.put(ITestItem.Status.Failed, TestsRunnerPlugin.createAutoImage("obj16/test_failed.gif"));
            this.testCaseImages.put(ITestItem.Status.Aborted, TestsRunnerPlugin.createAutoImage("obj16/test_aborted.gif"));
            this.testCaseRunImage = TestsRunnerPlugin.createAutoImage("obj16/test_run.gif");
            this.testSuiteImages = new HashMap<ITestItem.Status, Image>();
            this.testSuiteImages.put(ITestItem.Status.NotRun, TestsRunnerPlugin.createAutoImage("obj16/tsuite_notrun.gif"));
            this.testSuiteImages.put(ITestItem.Status.Skipped, TestsRunnerPlugin.createAutoImage("obj16/tsuite_notrun.gif"));
            this.testSuiteImages.put(ITestItem.Status.Passed, TestsRunnerPlugin.createAutoImage("obj16/tsuite_passed.gif"));
            this.testSuiteImages.put(ITestItem.Status.Failed, TestsRunnerPlugin.createAutoImage("obj16/tsuite_failed.gif"));
            this.testSuiteImages.put(ITestItem.Status.Aborted, TestsRunnerPlugin.createAutoImage("obj16/tsuite_aborted.gif"));
            this.testSuiteRunImage = TestsRunnerPlugin.createAutoImage("obj16/tsuite_run.gif");
            this.lastTestItemCache = null;
            this.lastTestItemPathCache = null;
        }

        public Image getImage(Object element) {
            Map<ITestItem.Status, Image> imagesMap = null;
            Image runImage = null;
            if (element instanceof ITestCase) {
                imagesMap = this.testCaseImages;
                runImage = this.testCaseRunImage;
            } else if (element instanceof ITestSuite) {
                imagesMap = this.testSuiteImages;
                runImage = this.testSuiteRunImage;
            }
            if (imagesMap != null) {
                ITestItem testItem = (ITestItem)element;
                if (TestsHierarchyViewer.this.testingSession.getModelAccessor().isCurrentlyRunning(testItem)) {
                    return runImage;
                }
                return imagesMap.get((Object)testItem.getStatus());
            }
            return null;
        }

        public String getText(Object element) {
            ITestItem testItem = (ITestItem)element;
            StringBuilder sb = new StringBuilder();
            sb.append(testItem.getName());
            if (!TestsHierarchyViewer.this.showTestsHierarchy) {
                this.appendTestItemPath(sb, testItem);
            }
            if (TestsHierarchyViewer.this.showTime) {
                sb.append(this.getTestingTimeString(element));
            }
            return sb.toString();
        }

        public StyledString getStyledText(Object element) {
            ITestItem testItem = (ITestItem)element;
            StringBuilder labelBuf = new StringBuilder();
            labelBuf.append(testItem.getName());
            StyledString name = new StyledString(labelBuf.toString());
            if (!TestsHierarchyViewer.this.showTestsHierarchy) {
                this.appendTestItemPath(labelBuf, testItem);
                name = StyledCellLabelProvider.styleDecoratedString((String)labelBuf.toString(), (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)name);
            }
            if (TestsHierarchyViewer.this.showTime) {
                String time = this.getTestingTimeString(element);
                labelBuf.append(time);
                name = StyledCellLabelProvider.styleDecoratedString((String)labelBuf.toString(), (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)name);
            }
            return name;
        }

        private void appendTestItemPath(StringBuilder sb, ITestItem testItem) {
            ITestSuite testItemParent = testItem.getParent();
            if (this.lastTestItemCache != testItemParent) {
                this.lastTestItemCache = testItemParent;
                this.lastTestItemPathCache = TestPathUtils.getTestItemPath(this.lastTestItemCache);
            }
            sb.append(MessageFormat.format(UIViewMessages.TestsHierarchyViewer_test_path_format, this.lastTestItemPathCache));
        }

        private String getTestingTimeString(Object element) {
            return element instanceof ITestItem ? MessageFormat.format(UIViewMessages.TestsHierarchyViewer_test_time_format, Double.toString((double)((ITestItem)element).getTestingTime() / 1000.0)) : "";
        }
    }

    private class TestTreeContentProvider
    implements ITreeContentProvider {
        private TestTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((ITestItem)parentElement).getChildren();
        }

        public Object[] getElements(Object rootTestSuite) {
            if (TestsHierarchyViewer.this.showTestsHierarchy) {
                return this.getChildren(rootTestSuite);
            }
            TestCasesCollector testCasesCollector = new TestCasesCollector();
            ((ITestItem)rootTestSuite).visit(testCasesCollector);
            return testCasesCollector.testCases.toArray();
        }

        public Object getParent(Object object) {
            return ((ITestItem)object).getParent();
        }

        public boolean hasChildren(Object object) {
            return ((ITestItem)object).hasChildren();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        private class TestCasesCollector
        implements IModelVisitor {
            public List<ITestCase> testCases = new ArrayList<ITestCase>();

            private TestCasesCollector() {
            }

            @Override
            public void visit(ITestCase testCase) {
                this.testCases.add(testCase);
            }

            @Override
            public void visit(ITestMessage testMessage) {
            }

            @Override
            public void visit(ITestSuite testSuite) {
            }

            @Override
            public void leave(ITestSuite testSuite) {
            }

            @Override
            public void leave(ITestCase testCase) {
            }

            @Override
            public void leave(ITestMessage testMessage) {
            }
        }
    }
}

