/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.IMulticoreVisualizerConstants;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerGraphicObject;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerLoadMeter;
import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class MulticoreVisualizerCPU
extends MulticoreVisualizerGraphicObject {
    protected int m_id;
    protected ArrayList<MulticoreVisualizerCore> m_cores;
    protected MulticoreVisualizerLoadMeter m_loadMeter;
    protected static final Color BG_COLOR = IMulticoreVisualizerConstants.COLOR_CPU_BG;
    protected static final Color FG_COLOR = IMulticoreVisualizerConstants.COLOR_CPU_FG;

    public MulticoreVisualizerCPU(int id) {
        this.m_id = id;
        this.m_cores = new ArrayList();
        this.m_loadMeter = new MulticoreVisualizerLoadMeter(null, null);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_loadMeter != null) {
            this.m_loadMeter.dispose();
        }
    }

    public int getID() {
        return this.m_id;
    }

    public void addCore(MulticoreVisualizerCore core) {
        this.m_cores.add(core);
    }

    public void removeCore(MulticoreVisualizerCore core) {
        this.m_cores.remove((Object)core);
    }

    public List<MulticoreVisualizerCore> getCores() {
        return this.m_cores;
    }

    public void setLoadMeter(MulticoreVisualizerLoadMeter meter) {
        this.m_loadMeter = meter;
    }

    public MulticoreVisualizerLoadMeter getLoadMeter() {
        return this.m_loadMeter;
    }

    @Override
    public void paintContent(GC gc) {
        gc.setBackground(BG_COLOR);
        this.m_loadMeter.setParentBgColor(BG_COLOR);
        if (this.m_selected) {
            gc.setForeground(IMulticoreVisualizerConstants.COLOR_SELECTED);
        } else {
            gc.setForeground(FG_COLOR);
        }
        gc.fillRectangle(this.m_bounds);
        gc.drawRectangle(this.m_bounds);
    }

    public boolean hasDecorations() {
        return true;
    }

    public void paintDecorations(GC gc) {
        if (this.m_bounds.height > 20) {
            gc.setForeground(IMulticoreVisualizerConstants.COLOR_CPU_FG);
            gc.setBackground(IMulticoreVisualizerConstants.COLOR_CPU_BG);
            int text_indent_x = 2;
            int text_indent_y = 0;
            int tx = this.m_bounds.x + this.m_bounds.width - text_indent_x;
            int ty = this.m_bounds.y + this.m_bounds.height - text_indent_y;
            GUIUtils.drawTextAligned((GC)gc, (String)Integer.toString(this.m_id), (Rectangle)this.m_bounds, (int)tx, (int)ty, (boolean)false, (boolean)false);
        }
    }
}

