/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors;

import org.eclipse.cdt.autotools.ui.editors.AutoconfEditorMessages;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfMacroElement;
import org.eclipse.cdt.autotools.ui.editors.parser.InvalidMacroException;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.core.VersionComparator;

public class AcInitElement
extends AutoconfMacroElement {
    private static final String BAD_VERSION_NUMBER = "AC_INIT_badVersionNumber";

    public AcInitElement(String name) {
        super(name);
    }

    @Override
    public void validate(String version) throws InvalidMacroException {
        super.validate(version);
        if (this.getChildren().length == 0) {
            return;
        }
        if (VersionComparator.compare((String)version, (String)AutotoolsPropertyConstants.AC_VERSION_2_59) >= 0) {
            if (this.getChildren().length < 2) {
                return;
            }
            this.validateMultipleArguments();
        }
    }

    private void validateMultipleArguments() throws InvalidMacroException {
        AutoconfElement argument = this.getChildren()[1];
        if (!argument.getName().matches("(\\d*\\.)*((\\d+))")) {
            throw new InvalidMacroException(AutoconfEditorMessages.getString(BAD_VERSION_NUMBER), argument);
        }
    }
}

