/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.ToolTipProvider;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.merrimac.DefaultBusinessObjectDelegate;
import org.eclipse.bpmn2.modeler.core.merrimac.IBusinessObjectDelegate;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.FeatureEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ObjectEditor
implements INotifyChangedListener {
    public static int ID_CREATE_BUTTON = 1;
    public static int ID_EDIT_BUTTON = 2;
    public static int ID_DELETE_BUTTON = 3;
    public static int ID_OTHER_BUTTONS = 4;
    protected EObject object;
    protected EStructuralFeature feature;
    protected AbstractDetailComposite parent;
    private Label label;
    protected ControlDecoration decoration;
    protected int style;
    protected boolean isWidgetUpdating = false;
    private IBusinessObjectDelegate boDelegate;
    private boolean valueChanged = false;

    public ObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        this.parent = parent;
        this.object = object;
        this.feature = feature;
        this.style = 0;
    }

    protected abstract Control createControl(Composite var1, String var2, int var3);

    public void setStyle(int style) {
        this.style = style;
    }

    public Control createControl(Composite composite, String label) {
        final Control c = this.createControl(composite, label, this.style);
        c.setData("notify.changed.listener", (Object)this);
        c.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ObjectEditor.this.valueChanged = false;
            }

            public void focusLost(FocusEvent e) {
                IStatus status;
                if (ObjectEditor.this.valueChanged && (status = ObjectEditor.this.parent.validate()).getSeverity() >= 4 && ObjectEditor.this.statusApplies(status)) {
                    MessageDialog.openError((Shell)ObjectEditor.this.parent.getShell(), (String)Messages.ObjectEditor_Validation_Error_Title, (String)status.getMessage());
                    if (!c.isDisposed()) {
                        c.setFocus();
                    }
                }
                ErrorUtils.showErrorMessage(null);
            }
        });
        return c;
    }

    public Control createControl(String label) {
        return this.createControl(this.parent, label);
    }

    public IBusinessObjectDelegate getBusinessObjectDelegate() {
        if (this.boDelegate == null) {
            this.boDelegate = new DefaultBusinessObjectDelegate(this.getDiagramEditor().getEditingDomain());
        }
        return this.boDelegate;
    }

    protected Object getExtendedProperty(String property) {
        Object result = null;
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(this.object);
        if (adapter != null && this.feature != null) {
            result = adapter.getProperty(this.feature, property);
        }
        return result;
    }

    protected void setExtendedProperty(String property, Object value) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(this.object);
        if (adapter != null && this.feature != null) {
            adapter.setProperty(this.feature, property, value);
        }
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EObject getObject() {
        return this.object;
    }

    public void setObject(EObject object) {
        this.object = object;
    }

    public void setObject(EObject object, EStructuralFeature feature) {
        this.object = object;
        this.feature = feature;
    }

    protected FormToolkit getToolkit() {
        return this.parent.getToolkit();
    }

    protected DiagramEditor getDiagramEditor() {
        return this.parent.getDiagramEditor();
    }

    protected Diagram getDiagram() {
        return this.getDiagramEditor().getDiagramTypeProvider().getDiagram();
    }

    protected Label createLabel(Composite parent, String name) {
        this.label = this.getToolkit().createLabel(parent, name);
        this.label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.updateLabelDecorator();
        return this.label;
    }

    public Label getLabel() {
        return this.label;
    }

    private boolean statusApplies(IStatus status) {
        if (status instanceof ConstraintStatus) {
            ConstraintStatus cs = (ConstraintStatus)status;
            for (EObject f : cs.getResultLocus()) {
                if (!(f instanceof EStructuralFeature) || f != this.feature) continue;
                return true;
            }
        }
        return false;
    }

    protected FeatureEditingDialog createFeatureEditingDialog(EObject value) {
        FeatureEditingDialog dialog = new FeatureEditingDialog(this.getDiagramEditor(), this.object, this.feature, value){

            @Override
            public void aboutToOpen() {
                this.dialogContent.setData("container", (Object)this.object);
                super.aboutToOpen();
            }
        };
        return dialog;
    }

    protected String getToolTipText() {
        String text = (String)this.getExtendedProperty("long.description");
        if (text == null || text.isEmpty()) {
            text = ToolTipProvider.INSTANCE.getToolTip((Object)this.parent, this.object, this.feature);
        }
        if (text == null || text.isEmpty()) {
            text = NLS.bind((String)Messages.ObjectEditor_No_Description, (Object)this.label.getText());
        }
        this.setExtendedProperty("long.description", text);
        return text;
    }

    protected void updateLabelDecorator() {
        if (this.label != null && !this.label.isDisposed()) {
            ValidationStatusAdapter statusAdapter;
            String tooltip = this.label.getToolTipText();
            if (tooltip == null && this.object != null && this.feature != null) {
                this.label.setToolTipText(this.getToolTipText());
            }
            boolean applies = false;
            String text = null;
            String image = null;
            if (this.isVisible() && (statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)this.object, ValidationStatusAdapter.class)) != null) {
                IStatus status = statusAdapter.getValidationStatus();
                if (status.isMultiStatus()) {
                    IStatus[] iStatusArray = status.getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus s = iStatusArray[n2];
                        if (this.statusApplies(s)) {
                            applies = true;
                            break;
                        }
                        ++n2;
                    }
                } else if (this.statusApplies(status)) {
                    applies = true;
                }
                if (applies) {
                    text = status.getMessage();
                    switch (status.getSeverity()) {
                        case 1: {
                            image = "IMG_OBJS_INFO_TSK";
                            break;
                        }
                        case 2: {
                            image = "IMG_DEC_FIELD_WARNING";
                            break;
                        }
                        case 4: {
                            image = "IMG_DEC_FIELD_ERROR";
                            break;
                        }
                    }
                }
            }
            if (applies) {
                if (this.decoration == null) {
                    this.decoration = new ControlDecoration((Control)this.label, 16512);
                }
                this.decoration.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(image));
                this.decoration.show();
                this.decoration.setDescriptionText(text);
            } else if (this.decoration != null) {
                this.decoration.hide();
                this.decoration.dispose();
                this.decoration = null;
            }
        }
    }

    public boolean setValue(Object result) {
        boolean success = this.getBusinessObjectDelegate().setValue(this.object, this.feature, result);
        if (!success) {
            this.showErrorMessage(NLS.bind((String)Messages.ObjectEditor_Set_Error_Message, (Object[])new Object[]{this.getBusinessObjectDelegate().getTextValue(this.object), this.getBusinessObjectDelegate().getLabel(this.object, this.feature), ModelUtil.getTextValue(result)}));
            return false;
        }
        this.valueChanged = true;
        return true;
    }

    protected void showErrorMessage(String message) {
        ErrorUtils.showErrorMessage(message);
    }

    public abstract Object getValue();

    public void notifyChanged(Notification notification) {
        this.updateLabelDecorator();
    }

    public void setVisible(boolean visible) {
        this.label.setVisible(visible);
        GridData data = (GridData)this.label.getLayoutData();
        data.exclude = !visible;
        this.updateLabelDecorator();
    }

    public boolean isVisible() {
        return this.label.isVisible();
    }

    public void dispose() {
        if (this.label != null && !this.label.isDisposed()) {
            this.label.dispose();
            this.label = null;
        }
        if (this.decoration != null) {
            this.decoration.hide();
            this.decoration.dispose();
            this.decoration = null;
        }
    }

    public Control getControl() {
        return this.label;
    }

    protected boolean isMultiLineText() {
        return this.getBusinessObjectDelegate().isMultiLineText(this.object, this.feature);
    }

    protected boolean canEdit() {
        return this.getBusinessObjectDelegate().canEdit(this.object, this.feature);
    }

    protected boolean canCreateNew() {
        return this.getBusinessObjectDelegate().canCreateNew(this.object, this.feature);
    }

    protected boolean canEditInline() {
        return this.getBusinessObjectDelegate().canEditInline(this.object, this.feature);
    }

    protected boolean canSetNull() {
        return this.getBusinessObjectDelegate().canSetNull(this.object, this.feature);
    }

    protected boolean canAdd() {
        return false;
    }

    protected boolean canRemove() {
        return false;
    }

    public void setEditable(boolean editable) {
        Control control = this.getControl();
        if (control instanceof Text) {
            ((Text)control).setEditable(editable);
            if (!editable) {
                control.setBackground(control.getDisplay().getSystemColor(22));
                control.setForeground(control.getDisplay().getSystemColor(21));
                control.setData("do_not_adapt", (Object)Boolean.TRUE);
            }
        }
    }
}

