/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.borders;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.FlowEditPart;
import org.eclipse.bpel.ui.editparts.borders.GradientBorder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class FlowBorder
extends GradientBorder {
    static final int margin = 1;
    public static final int LINE_WIDTH = 2;
    private IFigure parentFigure;
    private org.eclipse.draw2d.geometry.Rectangle bounds;

    public FlowBorder(IFigure parentFigure) {
        super(true, 7);
        this.parentFigure = parentFigure;
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Image bottomImage;
        Image topImage;
        this.bounds = figure.getBounds();
        int topDrawerX = this.bounds.x;
        int topDrawerY = this.bounds.y + 7;
        int bottomDrawerX = this.bounds.x;
        int bottomDrawerY = this.bounds.y + 7 + 12;
        IMarker topMarker = this.getTopMarker();
        IMarker bottomMarker = this.getBottomMarker();
        if (topMarker != null || bottomMarker != null) {
            org.eclipse.draw2d.geometry.Rectangle oldClip = new org.eclipse.draw2d.geometry.Rectangle();
            oldClip = graphics.getClip(oldClip);
            ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
            graphics.setForegroundColor(registry.get("activityBorder"));
            org.eclipse.draw2d.geometry.Rectangle clippingRect = bottomMarker == null ? new org.eclipse.draw2d.geometry.Rectangle(topDrawerX, topDrawerY, 16, 13) : (topMarker == null ? new org.eclipse.draw2d.geometry.Rectangle(bottomDrawerX, bottomDrawerY, 16, 13) : new org.eclipse.draw2d.geometry.Rectangle(topDrawerX, topDrawerY, 16, 26));
            graphics.setClip(clippingRect);
            graphics.drawRoundRectangle(new org.eclipse.draw2d.geometry.Rectangle(topDrawerX + 30, topDrawerY, 32, 24), 7, 7);
            graphics.setClip(oldClip);
            if (bottomMarker == null || topMarker == null) {
                graphics.drawLine(topDrawerX + 30, topDrawerY + 12, topDrawerX + 16, topDrawerY + 12);
            }
        }
        if ((topImage = this.getTopImage()) != null) {
            graphics.drawImage(topImage, topDrawerX, topDrawerY);
        }
        if ((bottomImage = this.getBottomImage()) != null) {
            graphics.drawImage(bottomImage, bottomDrawerX, bottomDrawerY);
        }
        ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
        graphics.setForegroundColor(registry.get("compositeActivityBorder"));
        org.eclipse.draw2d.geometry.Rectangle roundBounds = this.bounds.getCopy();
        roundBounds.crop(new Insets(0, 16, 1, 16));
        graphics.drawRoundRectangle(roundBounds, 7, 7);
        graphics.setForegroundColor(registry.get("flowBorder"));
        int lineStartX = roundBounds.x + 15;
        int lineEndX = roundBounds.x + roundBounds.width - 15;
        graphics.drawLine(lineStartX, roundBounds.y, lineEndX, roundBounds.y);
        graphics.drawLine(lineStartX, roundBounds.y + 1, lineEndX, roundBounds.y + 1);
        int y = roundBounds.bottom() - 2 + 1;
        graphics.drawLine(lineStartX, y, lineEndX, y);
        graphics.drawLine(lineStartX, y + 1, lineEndX, y + 1);
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return new Insets(3, 17, 3, 17);
    }

    public Dimension getPreferredSize(IFigure f) {
        return new Dimension(200, 200);
    }

    @Override
    protected org.eclipse.draw2d.geometry.Rectangle getGradientRect() {
        BPELEditPart ep = this.getEditPart();
        org.eclipse.draw2d.geometry.Rectangle rect = null;
        if (ep != null) {
            IFigure fig = ep.getContentPane();
            if (fig != null) {
                rect = fig.getBounds();
            }
            if (!((FlowEditPart)ep).isCollapsed()) {
                rect = rect.getCopy();
                rect.crop(new Insets(0, 16, 0, 16));
            }
        }
        return rect;
    }

    @Override
    public boolean isPointInTopDrawer(int x, int y) {
        if (this.bounds == null) {
            return false;
        }
        if (this.getTopMarker() == null) {
            return false;
        }
        Point p = new Point(x, y);
        this.parentFigure.translateToRelative((Translatable)p);
        Image image = this.getTopImage();
        Rectangle imageSize = image.getBounds();
        int imageX = this.bounds.x + 30;
        int imageY = this.bounds.y + 30 + 7;
        org.eclipse.draw2d.geometry.Rectangle imageBounds = new org.eclipse.draw2d.geometry.Rectangle(imageX, imageY, imageSize.width, imageSize.height);
        return imageBounds.contains(p);
    }

    @Override
    public boolean isPointInBottomDrawer(int x, int y) {
        if (this.bounds == null) {
            return false;
        }
        if (this.getBottomMarker() == null) {
            return false;
        }
        Point p = new Point(x, y);
        this.parentFigure.translateToRelative((Translatable)p);
        Image image = this.getBottomImage();
        Rectangle imageSize = image.getBounds();
        int imageX = this.bounds.x + 30;
        int imageY = this.bounds.y + 30 + 12 + 7;
        org.eclipse.draw2d.geometry.Rectangle imageBounds = new org.eclipse.draw2d.geometry.Rectangle(imageX, imageY, imageSize.width, imageSize.height);
        return imageBounds.contains(p);
    }
}

