/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.List;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.details.providers.CompositeContentProvider;
import org.eclipse.bpel.ui.details.providers.GatedContentProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.PartnerLinkTypeContentProvider;
import org.eclipse.bpel.ui.details.providers.PartnerLinkTypeTreeContentProvider;
import org.eclipse.bpel.ui.details.providers.PortTypeContentProvider;
import org.eclipse.bpel.ui.details.providers.WSDLDefinitionFromResourceContentProvider;
import org.eclipse.bpel.ui.dialogs.BrowseSelectorDialog;
import org.eclipse.bpel.ui.dialogs.NamespaceMappingDialog;
import org.eclipse.bpel.ui.dialogs.SchemaImportDialog;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.wizards.CreatePartnerLinkWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;

public class PartnerLinkTypeSelectorDialog
extends BrowseSelectorDialog {
    private static final int BID_SHOW_PORT_TYPES = 1224;
    private static final String SHOW_PORT_TYPES = Messages.PartnerLinkTypeSelectorDialog_0;
    private boolean showPortTypes = false;
    GatedContentProvider portTypeContentProvider;
    PartnerLinkType fPartnerLinkType;
    Button fShowPortTypes;

    public PartnerLinkTypeSelectorDialog(Shell parent, EObject eObj) {
        super(parent, new ModelLabelProvider(eObj));
        this.modelObject = eObj;
        this.portTypeContentProvider = new GatedContentProvider(new PortTypeContentProvider());
        CompositeContentProvider ccp = new CompositeContentProvider();
        ccp.add(new PartnerLinkTypeContentProvider());
        ccp.add(this.portTypeContentProvider);
        this.contentProvider = ccp;
        this.resourceContentProvider = new WSDLDefinitionFromResourceContentProvider(this.modelObject.eResource().getResourceSet());
        this.treeContentProvider = new PartnerLinkTypeTreeContentProvider(true);
        this.setTitle(Messages.PartnerLinkTypeSelectorDialog_1);
        this.setLowerViewLabel(Messages.PartnerLinkTypeSelectorDialog_2);
        this.setBrowseFromLabel(Messages.PartnerLinkTypeSelectorDialog_3);
        IDialogSettings settings = this.getDialogSettings();
        try {
            this.showPortTypes = settings.getBoolean(SHOW_PORT_TYPES);
        }
        catch (Exception exception) {
            this.showPortTypes = false;
        }
        this.portTypeContentProvider.setEnabled(this.showPortTypes);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.refresh();
        return control;
    }

    @Override
    protected void saveSettings() {
        super.saveSettings();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SHOW_PORT_TYPES, this.showPortTypes);
    }

    @Override
    protected void buttonPressed(int id, boolean checked, boolean bRefresh) {
        switch (id) {
            case 1224: {
                this.showPortTypes = checked;
                this.portTypeContentProvider.setEnabled(this.showPortTypes);
                break;
            }
            default: {
                super.buttonPressed(id, checked, bRefresh);
                return;
            }
        }
        if (bRefresh) {
            this.refresh();
        }
    }

    @Override
    protected void computeResult() {
        if (this.fPartnerLinkType != null) {
            this.setResult(0, this.fPartnerLinkType);
        } else {
            super.computeResult();
        }
    }

    @Override
    protected void okPressed() {
        this.computeResult();
        Object obj = this.getFirstResult();
        if (obj instanceof PortType) {
            PortType pt = (PortType)obj;
            CreatePartnerLinkWizard wizard = new CreatePartnerLinkWizard();
            wizard.setMandatoryPortType(pt);
            wizard.setBPELEditor(ModelHelper.getBPELEditor(pt));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 1) {
                return;
            }
            this.fPartnerLinkType = wizard.getPartnerLinkType();
            if (this.fPartnerLinkType == null) {
                return;
            }
            if (!this.checkNamespace(this.fPartnerLinkType)) {
                return;
            }
            super.okPressed();
            return;
        }
        if (obj instanceof PartnerLinkType) {
            if (!this.checkNamespace((PartnerLinkType)obj)) {
                return;
            }
            super.okPressed();
            return;
        }
        throw new IllegalStateException(Messages.PartnerLinkTypeSelectorDialog_4);
    }

    private boolean checkNamespace(PartnerLinkType obj) {
        String targetNamespace = obj.getEnclosingDefinition().getTargetNamespace();
        String prefix = BPELUtils.getNamespacePrefix((EObject)this.modelObject, (String)targetNamespace);
        if (prefix != null) {
            return true;
        }
        NamespaceMappingDialog dialog = new NamespaceMappingDialog(this.getShell(), this.modelObject);
        dialog.setNamespace(targetNamespace);
        if (dialog.open() == 1) {
            return false;
        }
        BPELUtils.setPrefix((EObject)BPELUtils.getProcess((Object)this.modelObject), (String)targetNamespace, (String)dialog.getPrefix());
        return true;
    }

    @Override
    protected void createBrowseFilterGroupButtons(Group group) {
        this.fShowPortTypes = this.createCheckButton((Composite)group, Messages.PartnerLinkTypeSelectorDialog_5, 1224, this.showPortTypes);
        super.createBrowseFilterGroupButtons(group);
    }

    @Override
    protected void handleAddImport() {
        SchemaImportDialog dialog = new SchemaImportDialog(this.getShell(), this.modelObject);
        dialog.configureAsWSDLImport();
        if (dialog.open() == 1) {
            return;
        }
        Object obj = dialog.getFirstResult();
        if (obj == null) {
            return;
        }
        if (this.handleAddImport(obj)) {
            this.showImportedTypes();
            this.refresh();
        }
    }

    @Override
    protected void showImportedTypes() {
        this.fShowPortTypes.setSelection(true);
        this.buttonPressed(1224, true, false);
        super.showImportedTypes();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.PartnerLinkTypeSelectorDialog_6, false);
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected int getAutoExpandLevel() {
        return 5;
    }

    protected List<Definition> collectItemsFromImports() {
        return ModelHelper.getDefinitions(this.modelObject);
    }
}

