/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class BPELResourceSet
extends ResourceSetImpl {
    public static final String SLIGHTLY_HACKED_KEY = "slightly.hacked.resource.set";

    public Resource getResource(URI uri, boolean loadOnDemand, String kind) {
        Resource resource;
        Map map = this.getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            return resource;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        for (Resource resource2 : this.getResources()) {
            if (!theURIConverter.normalize(resource2.getURI()).equals(normalizedURI)) continue;
            if (loadOnDemand && !resource2.isLoaded()) {
                this.demandLoadHelper(resource2);
            }
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        if (loadOnDemand) {
            Resource resource2;
            resource2 = this.demandCreateResource(uri, kind);
            if (resource2 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource2);
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        return null;
    }

    protected Resource demandCreateResource(URI uri, String kind) {
        return this.createResource(uri, kind);
    }

    public Resource createResource(URI uri, String kind) {
        if (kind == null) {
            return super.createResource(uri, null);
        }
        Resource resource = this.createResource(URI.createURI((String)("*." + kind)));
        if (resource != null) {
            resource.setURI(uri);
        }
        return resource;
    }
}

