/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public abstract class BorderDescriptorProvider
extends AbstractDescriptorProvider {
    protected Object input;
    protected HashMap styleMap = new HashMap();

    public BorderDescriptorProvider() {
        this.styleMap.put("borderLeftStyle", Boolean.FALSE);
        this.styleMap.put("borderRightStyle", Boolean.FALSE);
        this.styleMap.put("borderTopStyle", Boolean.FALSE);
        this.styleMap.put("borderBottomStyle", Boolean.FALSE);
    }

    public void setStyleProperty(String style, Boolean value) {
        this.styleMap.put(style, value);
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    protected String getLocalStringValue(String property) {
        GroupElementHandle handle = null;
        if (this.input instanceof List) {
            handle = DEUtil.getGroupElementHandle((List)((List)this.input));
        }
        if (handle == null) {
            return "";
        }
        String value = handle.getLocalStringProperty(property);
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getStringValue(String property) {
        GroupElementHandle handle = null;
        if (this.input instanceof List) {
            handle = DEUtil.getGroupElementHandle((List)((List)this.input));
        }
        if (handle == null) {
            return "";
        }
        String value = handle.getStringProperty(property);
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getDisplayValue(String property) {
        GroupElementHandle handle = null;
        if (this.input instanceof List) {
            handle = DEUtil.getGroupElementHandle((List)((List)this.input));
        }
        if (handle == null) {
            return "";
        }
        if (this.getLocalStringValue(property).equals("")) {
            String value = handle.getPropertyHandle(property).getStringValue();
            if (value == null) {
                value = "";
            }
            return value;
        }
        return "";
    }

    protected String getDefaultStringValue(String property) {
        GroupElementHandle handle = null;
        if (this.input instanceof List) {
            handle = DEUtil.getGroupElementHandle((List)((List)this.input));
        }
        if (handle == null) {
            return "";
        }
        if (this.getLocalStringValue(property).equals("")) {
            String value = handle.getStringProperty(property);
            if (value == null) {
                value = "";
            }
            return value;
        }
        return "";
    }

    protected void save(String property, Object value) throws SemanticException {
        GroupElementHandle groupElementHandle = null;
        if (this.input instanceof GroupElementHandle) {
            groupElementHandle = (GroupElementHandle)this.input;
        } else if (this.input instanceof List) {
            groupElementHandle = DEUtil.getGroupElementHandle((List)((List)this.input));
        }
        if (groupElementHandle != null) {
            GroupPropertyHandle handle = groupElementHandle.getPropertyHandle(property);
            if (handle != null && handle.getLocalStringValue() != null && handle.getLocalStringValue().equals(value)) {
                return;
            }
            groupElementHandle.setProperty(property, value);
        }
    }

    abstract void handleModifyEvent();
}

