/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.actf.model.internal.flash.proxy.Messages;
import org.eclipse.actf.model.internal.flash.proxy.ProxyPlugin;
import org.eclipse.actf.model.internal.flash.proxy.logs.ProxyLogHandler;
import org.eclipse.actf.model.internal.flash.proxy.logs.ProxyLogRecord;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProxyLogView
extends ViewPart {
    public static final String ID = ProxyLogView.class.getName();
    private static final String[] HEADINGS = new String[]{Messages.proxy_message, "ID", Messages.proxy_source, Messages.proxy_time};
    private static final int[] WEIGHTS = new int[]{30, 3, 10, 5};
    private static final int[] ALIGNMENTS = new int[]{16384, 16384, 16384, 16384};
    private static final int ROW_MESSAGE = 0;
    private static final int ROW_ID = 1;
    private static final int ROW_SOURCE = 2;
    private static final int ROW_TIME = 3;
    private TableViewer viewer;
    private ProxyLogViewComparator sorter = new ProxyLogViewComparator();
    private Action clearAction;
    private Action showFineAction;
    private Action copyAction;
    private ViewLabelProvider labelProvider;
    private static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();

    public void refresh() {
        this.viewer.refresh();
    }

    public void createPartControl(Composite composite) {
        Table table = new Table(composite, 68356);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int n = 0;
        while (n < HEADINGS.length) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(WEIGHTS[n]));
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(HEADINGS[n]);
            tableColumn.setAlignment(ALIGNMENTS[n]);
            tableColumn.setResizable(true);
            final int n2 = n + 1;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ((ProxyLogView)ProxyLogView.this).sorter.sortingColumn = n2 == ((ProxyLogView)ProxyLogView.this).sorter.sortingColumn ? -n2 : n2;
                    ProxyLogView.this.refresh();
                }
            });
            ++n;
        }
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.labelProvider = new ViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setComparator((ViewerComparator)this.sorter);
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ProxyLogView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.showFineAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.clearAction);
        iMenuManager.add((IAction)this.copyAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.clearAction);
    }

    private void makeActions() {
        this.clearAction = new Action(Messages.proxy_clear){

            public void run() {
                ProxyLogHandler.clear();
                ProxyLogView.this.viewer.refresh();
            }
        };
        this.clearAction.setToolTipText(Messages.proxy_clear_tip);
        this.clearAction.setImageDescriptor(ProxyPlugin.IMAGE_CLEAR);
        this.showFineAction = new Action(Messages.proxy_show_fine, 2){

            public void run() {
                ProxyLogHandler.setLogLevel(ProxyLogView.this.showFineAction.isChecked() ? Level.FINE : Level.INFO);
            }
        };
        this.copyAction = new Action(Messages.proxy_copy){

            public void run() {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while ((object = ProxyLogView.this.viewer.getElementAt(n)) != null) {
                    int n2 = 0;
                    while (n2 < HEADINGS.length) {
                        stringBuffer.append(ProxyLogView.this.labelProvider.getColumnText(object, n2));
                        stringBuffer.append(n2 == HEADINGS.length - 1 ? "\r\n" : "\t");
                        ++n2;
                    }
                    ++n;
                }
                if (stringBuffer.length() > 0) {
                    new Clipboard(Display.getCurrent()).setContents(new Object[]{stringBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        };
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private class ProxyLogViewComparator
    extends ViewerComparator {
        public int sortingColumn = 0;

        private ProxyLogViewComparator() {
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            IBaseLabelProvider iBaseLabelProvider;
            if (this.sortingColumn != 0 && viewer instanceof TableViewer && (iBaseLabelProvider = ((TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                int n = Math.abs(this.sortingColumn) - 1;
                String string = ((ITableLabelProvider)iBaseLabelProvider).getColumnText(object, n);
                String string2 = ((ITableLabelProvider)iBaseLabelProvider).getColumnText(object2, n);
                int n2 = 0;
                switch (n) {
                    case 3: {
                        n2 = (int)(((ProxyLogRecord)object).getMillis() - ((ProxyLogRecord)object2).getMillis());
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        n2 = super.compare(viewer, (Object)string, (Object)string2);
                    }
                }
                return this.sortingColumn > 0 ? n2 : -n2;
            }
            return 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return ProxyLogHandler.getLogs().toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ProxyLogRecord) {
                switch (n) {
                    case 3: {
                        long l = ((ProxyLogRecord)object).getMillis();
                        return MessageFormat.format((String)"{0,time}", (Object[])new Object[]{new Date(l)});
                    }
                    case 0: {
                        return ((ProxyLogRecord)object).getMessage();
                    }
                    case 1: {
                        return ((ProxyLogRecord)object).getID();
                    }
                    case 2: {
                        String string = ((ProxyLogRecord)object).getLoggerName();
                        int n2 = string.lastIndexOf(46);
                        if (-1 != n2) {
                            return string.substring(n2 + 1);
                        }
                        return string;
                    }
                }
            }
            return this.getText(object);
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0 && object instanceof ProxyLogRecord) {
                ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
                int n2 = ((ProxyLogRecord)object).getLevel().intValue();
                if (n2 > Level.WARNING.intValue()) {
                    return iSharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
                if (n2 > Level.INFO.intValue()) {
                    return iSharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                if (n2 > Level.FINE.intValue()) {
                    return iSharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return null;
        }
    }
}

