/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.conflation;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.sourceforge.nattable.conflation.IEventConflater;
import net.sourceforge.nattable.layer.event.ILayerEvent;

public class EventConflaterChain
implements IEventConflater {
    public static final int DEFAULT_INITIAL_DELAY = 100;
    public static final int DEFAULT_REFRESH_INTERVAL = 100;
    private final List<IEventConflater> chain = new LinkedList<IEventConflater>();
    private boolean started;
    private final long refreshInterval;
    private final long initialDelay;
    private ScheduledExecutorService scheduler;

    public EventConflaterChain() {
        this(100, 100);
    }

    public EventConflaterChain(int refreshInterval, int initialDelay) {
        this.refreshInterval = refreshInterval;
        this.initialDelay = initialDelay;
    }

    public void add(IEventConflater conflater) {
        this.chain.add(conflater);
    }

    public void start() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        if (!this.started) {
            this.scheduler.scheduleWithFixedDelay(this.getConflaterTask(), this.initialDelay, this.refreshInterval, TimeUnit.MILLISECONDS);
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            this.scheduler.shutdownNow();
            this.started = false;
        }
    }

    public void addEvent(ILayerEvent event) {
        for (IEventConflater eventConflater : this.chain) {
            eventConflater.addEvent(event);
        }
    }

    public void clearQueue() {
        for (IEventConflater eventConflater : this.chain) {
            eventConflater.clearQueue();
        }
    }

    public int getCount() {
        int count = 0;
        for (IEventConflater eventConflater : this.chain) {
            count += eventConflater.getCount();
        }
        return count;
    }

    public Runnable getConflaterTask() {
        return new Runnable(){

            public void run() {
                for (IEventConflater conflater : EventConflaterChain.this.chain) {
                    conflater.getConflaterTask().run();
                }
            }
        };
    }
}

