/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Driver {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Options")
    private Map<String, String> options;

    public String name() {
        return this.name;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Driver that = (Driver)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.options);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("options", this.options).toString();
    }

    public static class Builder {
        private Driver driver = new Driver();

        public Builder withName(String name) {
            this.driver.name = name;
            return this;
        }

        public Builder withOption(String name, String value) {
            if (this.driver.options == null) {
                this.driver.options = new HashMap();
            }
            this.driver.options.put(name, value);
            return this;
        }

        public Driver build() {
            return this.driver;
        }
    }
}

