/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.changemonitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.job.EnableJob;
import org.eclipse.viatra.transformation.evm.specific.job.StatelessJob;
import org.eclipse.viatra.transformation.evm.specific.scheduler.UpdateCompleteBasedScheduler;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.ChangeDelta;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.IChangeMonitor;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.QueryResultChangeDelta;

public class ChangeMonitor
extends IChangeMonitor {
    private Map<IQuerySpecification<?>, QueryResultChangeDelta> changesBetweenCheckpoints = new HashMap();
    private Map<IQuerySpecification<?>, QueryResultChangeDelta> accumulator = new HashMap();
    private Set<RuleSpecification<IPatternMatch>> rules;
    private Map<IQuerySpecification<?>, RuleSpecification<IPatternMatch>> specs;
    private Set<Job<?>> allJobs = new HashSet();
    private boolean started = false;
    private ExecutionSchema executionSchema;

    public ChangeMonitor(ViatraQueryEngine engine) {
        super(engine);
        this.rules = new HashSet<RuleSpecification<IPatternMatch>>();
        this.specs = new HashMap();
        UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory schedulerFactory = Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)engine);
        this.executionSchema = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)engine, (Scheduler.ISchedulerFactory)schedulerFactory);
    }

    public void addRule(RuleSpecification<IPatternMatch> rule) {
        this.rules.add(rule);
        Map jobs = rule.getJobs();
        if (this.started) {
            this.executionSchema.addRule(rule);
        }
        for (Set jobEntries : jobs.values()) {
            for (Job job : jobEntries) {
                if (this.started) {
                    EnableJob enableJob = (EnableJob)job;
                    enableJob.setEnabled(true);
                    continue;
                }
                this.allJobs.add(job);
            }
        }
    }

    public void addRule(IQuerySpecification<?> spec) {
        RuleSpecification rule = Rules.newMatcherRuleSpecification(spec, (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), this.createDefaultProcessorJobs());
        this.specs.put(spec, (RuleSpecification<IPatternMatch>)rule);
        this.addRule((RuleSpecification<IPatternMatch>)rule);
    }

    public void removeRule(RuleSpecification<IPatternMatch> rule) {
        this.rules.remove(rule);
        this.executionSchema.removeRule(rule);
    }

    public void removeRule(IQuerySpecification<?> spec) {
        RuleSpecification<IPatternMatch> ruleSpecification = this.specs.get(spec);
        this.rules.remove(ruleSpecification);
        this.specs.remove(spec);
        this.executionSchema.removeRule(ruleSpecification);
    }

    @Override
    public ChangeDelta createCheckpoint() {
        this.changesBetweenCheckpoints = this.accumulator;
        this.accumulator = new HashMap();
        return new ChangeDelta(this.changesBetweenCheckpoints);
    }

    @Override
    public ChangeDelta getDeltaSinceLastCheckpoint() {
        return new ChangeDelta(this.accumulator);
    }

    @Override
    public void startMonitoring() {
        for (RuleSpecification<IPatternMatch> ruleSpecification : this.rules) {
            this.executionSchema.addRule(ruleSpecification);
        }
        this.executionSchema.startUnscheduledExecution();
        for (Job job : this.allJobs) {
            EnableJob enableJob = (EnableJob)job;
            enableJob.setEnabled(true);
        }
        this.started = true;
    }

    public void dispose() {
        this.executionSchema.dispose();
    }

    protected Set<Job<IPatternMatch>> createDefaultProcessorJobs() {
        Consumer<IPatternMatch> appearProcessor = this::registerAppear;
        Consumer<IPatternMatch> disappearProcessor = this::registerDisappear;
        Consumer<IPatternMatch> updateProcessor = this::registerUpdate;
        HashSet<Job<IPatternMatch>> jobs = new HashSet<Job<IPatternMatch>>();
        StatelessJob appear = new StatelessJob(CRUDActivationStateEnum.CREATED, appearProcessor);
        StatelessJob disappear = new StatelessJob(CRUDActivationStateEnum.DELETED, disappearProcessor);
        StatelessJob update = new StatelessJob(CRUDActivationStateEnum.UPDATED, updateProcessor);
        jobs.add(Jobs.newEnableJob((Job)appear));
        jobs.add(Jobs.newEnableJob((Job)disappear));
        jobs.add(Jobs.newEnableJob((Job)update));
        this.allJobs.addAll(jobs);
        return jobs;
    }

    protected void registerUpdate(IPatternMatch match) {
        this.accumulator.computeIfAbsent(match.specification(), QueryResultChangeDelta::new).getUpdated().add(match);
    }

    protected void registerAppear(IPatternMatch match) {
        this.accumulator.computeIfAbsent(match.specification(), QueryResultChangeDelta::new).getAppeared().add(match);
    }

    protected void registerDisappear(IPatternMatch match) {
        Set<IPatternMatch> appearMatches = this.accumulator.computeIfAbsent(match.specification(), QueryResultChangeDelta::new).getAppeared();
        Set<IPatternMatch> updateMatches = this.accumulator.computeIfAbsent(match.specification(), QueryResultChangeDelta::new).getUpdated();
        Set<IPatternMatch> disappearMatches = this.accumulator.computeIfAbsent(match.specification(), QueryResultChangeDelta::new).getDisappeared();
        if (updateMatches.contains(match)) {
            updateMatches.remove(match);
        }
        if (appearMatches.contains(match)) {
            appearMatches.remove(match);
        } else {
            disappearMatches.add(match);
        }
    }
}

