/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.SpecializedProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.Tunnel;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class AbstractUniquenessEnforcerNode
extends StandardNode
implements Tunnel {
    protected final Collection<Supplier> parents = new ArrayList<Supplier>();
    protected ProjectionIndexer memoryNullIndexer;
    protected ProjectionIndexer memoryIdentityIndexer;
    protected final int tupleWidth;
    protected Mailbox mailbox;
    protected final TupleMask nullMask;
    protected final TupleMask identityMask;
    protected final List<SpecializedProjectionIndexer.ListenerSubscription> specializedListeners = new ArrayList<SpecializedProjectionIndexer.ListenerSubscription>();

    public AbstractUniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth) {
        super(reteContainer);
        this.tupleWidth = tupleWidth;
        this.nullMask = TupleMask.linear((int)0, (int)tupleWidth);
        this.identityMask = TupleMask.identity((int)tupleWidth);
    }

    protected abstract Mailbox instantiateMailbox();

    @Override
    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public abstract Set<Tuple> getTuples();

    protected void propagate(Direction direction, Tuple update, Timestamp timestamp) {
        for (SpecializedProjectionIndexer.ListenerSubscription subscription : this.specializedListeners) {
            subscription.propagate(direction, update, timestamp);
        }
        this.propagateUpdate(direction, update, timestamp);
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask, TraceInfo ... traces) {
        if (this.nullMask.equals((Object)mask)) {
            ProjectionIndexer indexer = this.getNullIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                TraceInfo traceInfo = traceInfoArray[n2];
                indexer.assignTraceInfo(traceInfo);
                ++n2;
            }
            return indexer;
        }
        if (this.identityMask.equals((Object)mask)) {
            ProjectionIndexer indexer = this.getIdentityIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n3 = 0;
            while (n3 < n) {
                TraceInfo traceInfo = traceInfoArray[n3];
                indexer.assignTraceInfo(traceInfo);
                ++n3;
            }
            return indexer;
        }
        return super.constructIndex(mask, traces);
    }

    public abstract ProjectionIndexer getNullIndexer();

    public abstract ProjectionIndexer getIdentityIndexer();

    @Override
    public void appendParent(Supplier supplier) {
        this.parents.add(supplier);
    }

    @Override
    public void removeParent(Supplier supplier) {
        this.parents.remove(supplier);
    }

    @Override
    public Collection<Supplier> getParents() {
        return this.parents;
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateFromStandardNodeToSupplierParent()) {
            for (Supplier parent : this.parents) {
                parent.acceptPropagatedTraceInfo(traceInfo);
            }
        }
    }
}

