/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.connection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.launch.PHPUnitLaunchUtils;
import org.eclipse.php.phpunit.model.connection.Message;
import org.eclipse.php.phpunit.model.connection.PHPUnitMessageParser;
import org.eclipse.php.phpunit.model.elements.PHPUnitElementManager;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;

public class PHPUnitConnectionListener
implements Runnable {
    protected ILaunch launch;
    protected int port = 0;
    protected ServerSocket serverSocket;
    protected Socket socket;
    private Thread listenThread;
    private Gson gson = new GsonBuilder().create();

    public PHPUnitConnectionListener(int port, ILaunch launch) {
        this.port = port;
        this.launch = launch;
    }

    protected void handleReport(Socket socket) {
        if (!PHPUnitLaunchUtils.isPHPUnitRunning()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                String line;
                PHPUnitMessageParser parser = PHPUnitMessageParser.getInstance();
                parser.clean();
                parser.setDebugTarget(PHPUnitView.getDefault().getLaunch().getDebugTarget());
                parser.setInProgress(true);
                while ((line = reader.readLine()) != null && parser.isInProgress()) {
                    try {
                        this.processLine(line, parser);
                    }
                    catch (JsonSyntaxException e) {
                        PHPUnitPlugin.log(e);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PHPUnitPlugin.log(e);
        }
    }

    private void processLine(String line, PHPUnitMessageParser parser) throws JsonSyntaxException {
        if (StringUtils.isEmpty((CharSequence)line) || line.charAt(0) != '{') {
            return;
        }
        Message message = (Message)this.gson.fromJson(line, Message.class);
        parser.parseMessage(message, PHPUnitView.getDefault().getViewer());
    }

    @Override
    public void run() {
        ILaunch launch = PHPUnitView.getDefault().getLaunch();
        int tries = 3;
        String message = PHPUnitMessages.PHPUnitView_Run_Error;
        do {
            try {
                try {
                    this.serverSocket = new ServerSocket(this.port, 1);
                    this.serverSocket.setSoTimeout(5000);
                    this.serverSocket.setReuseAddress(true);
                    this.socket = this.serverSocket.accept();
                    this.handleReport(this.socket);
                }
                catch (IOException e) {
                    if (--tries == 0) {
                        PHPUnitPlugin.log(e);
                        message = NLS.bind((String)PHPUnitMessages.PHPUnitView_Run_SocketError, (Object)this.port, (Object)e.getMessage());
                    }
                    this.shutdown(false);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.shutdown(false);
                throw throwable;
            }
            this.shutdown(false);
        } while (tries > 0 && this.socket == null || !launch.isTerminated() && "debug".equals(launch.getLaunchMode()));
        PHPUnitView.getDefault().stop(PHPUnitElementManager.getInstance().getRoot(), message);
    }

    public void shutdown(boolean terminateLaunch) {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (terminateLaunch && this.launch != null && !this.launch.isTerminated()) {
            try {
                this.launch.terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        PHPUnitMessageParser.getInstance().setInProgress(false);
    }

    public void start() {
        this.listenThread = new Thread((Runnable)this, "PHPUnit PHPUnitConnectionListener");
        this.listenThread.start();
    }
}

