/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.bndtools;

import aQute.bnd.build.Workspace;
import java.io.StringWriter;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.ui.target.ITargetLocationHandler;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BndTargetLocation
extends AbstractBundleContainer
implements ITargetLocationHandler,
ILabelProvider {
    static final String PLUGIN_ID = "bndtools.pde";
    static final String MESSAGE_UNABLE_TO_LOCATE_WORKSPACE = "Unable to locate the Bnd workspace";
    static final String MESSAGE_UNABLE_TO_RESOLVE_BUNDLES = "Unable to resolve bundles";
    static final String ELEMENT_LOCATION = "location";
    static final String ATTRIBUTE_LOCATION_TYPE = "type";
    private final String type;
    private final Image containerIcon;

    public BndTargetLocation(String type, String containerIconName) {
        this.type = Objects.requireNonNull(type);
        this.containerIcon = PDEPluginImages.get("/icons/bndtools/" + containerIconName);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ILabelProvider.class) {
            return (T)this;
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public boolean canEdit(ITargetDefinition targetLocation, TreePath treePath) {
        return targetLocation == this;
    }

    @Override
    public boolean canUpdate(ITargetDefinition targetLocation, TreePath treePath) {
        return targetLocation == this;
    }

    @Override
    public IStatus update(ITargetDefinition target, TreePath[] treePaths, IProgressMonitor monitor) {
        this.clearResolutionStatus();
        return Status.OK_STATUS;
    }

    public Image getImage(Object element) {
        return this.containerIcon;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (definition instanceof TargetDefinition) {
            return ((TargetDefinition)definition).resolveFeatures(this.getLocation(false), monitor);
        }
        return new TargetFeature[0];
    }

    public String getType() {
        return this.type;
    }

    public String serialize() {
        try {
            DocumentBuilder docBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
            Document document = docBuilder.newDocument();
            Element locationElement = document.createElement(ELEMENT_LOCATION);
            locationElement.setAttribute(ATTRIBUTE_LOCATION_TYPE, this.getType());
            document.appendChild(locationElement);
            this.serialize(document, locationElement);
            StreamResult result = new StreamResult(new StringWriter());
            Transformer transformer = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            PDECore.log((Throwable)e);
            return null;
        }
    }

    protected abstract void serialize(Document var1, Element var2);

    public static Workspace getWorkspace() throws CoreException {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(BndTargetLocation.class);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            tracker.open();
            try (ServiceTracker tracker = new ServiceTracker(bundleContext, Workspace.class, null);){
                Workspace service = (Workspace)tracker.getService();
                if (service != null) {
                    Workspace workspace = service;
                    return workspace;
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, MESSAGE_UNABLE_TO_LOCATE_WORKSPACE));
    }
}

