/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.FieldSizedCapacityCollectionExtractor;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;

public class FieldSizedCapacityMapExtractor
extends FieldSizedCapacityCollectionExtractor
implements IMapExtractor {
    String capacityField;

    public FieldSizedCapacityMapExtractor(String sizeField, String arrayField, String capacityField) {
        super(sizeField, arrayField);
        this.capacityField = capacityField;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        Integer i;
        if (this.capacityField != null && (i = ExtractionUtils.toInteger(coll.resolveValue(this.capacityField))) != null) {
            return i;
        }
        return super.getCapacity(coll);
    }

    @Override
    public boolean hasCollisionRatio() {
        return true;
    }

    @Override
    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        IArray obj = this.getArray(coll);
        if (obj instanceof IPrimitiveArray) {
            IPrimitiveArray pa = (IPrimitiveArray)obj;
            int consec = 0;
            boolean prev = false;
            boolean prev0 = false;
            int i = 0;
            while (i < pa.getLength()) {
                Object ba = pa.getValueAt(i);
                if (ba instanceof Boolean && ((Boolean)ba).booleanValue()) {
                    if (prev) {
                        ++consec;
                    }
                    prev = true;
                    if (i == 0) {
                        prev0 = true;
                    }
                } else {
                    prev = false;
                }
                ++i;
            }
            if (prev && prev0) {
                ++consec;
            }
            double x = (double)consec / (double)pa.getLength();
            return 0.29 * x + 0.21 * x * x;
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject collection) throws SnapshotException {
        return Collections.emptyIterator();
    }
}

