/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.model.edit.pom.translators;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2e.model.edit.pom.translators.SSESyncResource;
import org.eclipse.m2e.model.edit.pom.translators.TranslatorAdapter;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class ValueUpdateAdapter
extends TranslatorAdapter
implements INodeAdapter {
    private final EObject modelObject;
    private final EStructuralFeature feature;
    private List<Node> linkedWhitespaceNodes = Collections.emptyList();

    public ValueUpdateAdapter(SSESyncResource resource, Element node, EObject object, EStructuralFeature feature) {
        super(resource);
        this.node = node;
        this.modelObject = object;
        this.feature = feature;
    }

    public boolean isAdapterForType(Object type) {
        return ValueUpdateAdapter.class.equals(type);
    }

    /*
     * WARNING - void declaration
     */
    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.resource.isProcessEvents()) {
            try {
                this.resource.setProcessEvents(false);
                Object object = newValue;
                if (object instanceof Text) {
                    void text;
                    Text text2 = (Text)object;
                    Text cfr_ignored_0 = (Text)object;
                    changedFeature = newValue;
                    newValue = text.getData();
                }
                if (changedFeature instanceof Text) {
                    if (newValue == null) {
                        ExtendedEcoreUtil.eUnsetOrRemove((EObject)this.modelObject, (EStructuralFeature)this.feature, (Object)oldValue);
                    } else {
                        ExtendedEcoreUtil.eSetOrAdd((EObject)this.modelObject, (EStructuralFeature)this.feature, (Object)newValue.toString().trim());
                    }
                }
            }
            finally {
                this.resource.setProcessEvents(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load() {
        Object value = ValueUpdateAdapter.getElementText(this.node);
        EStructuralFeature eStructuralFeature = this.feature;
        if (eStructuralFeature instanceof EAttribute) {
            void ea;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            value = EcoreUtil.createFromString((EDataType)ea.getEAttributeType(), (String)value.toString());
        }
        this.modelObject.eSet(this.feature, value);
    }

    @Override
    public void save() {
        this.setElementTextValue(this.node, null, this.modelObject.eGet(this.feature));
    }

    @Override
    public void update(Object oldValue, Object newValue, int index) {
        this.setElementTextValue(this.node, oldValue, this.modelObject.eGet(this.feature));
    }

    /*
     * WARNING - void declaration
     */
    private void setElementTextValue(Element element, Object oldValue, Object newValue) {
        newValue = newValue == null ? "" : newValue.toString();
        boolean replacedChild = false;
        if (oldValue != null) {
            NodeList children = element.getChildNodes();
            int nChildren = children.getLength();
            int i = 0;
            while (i < nChildren) {
                Node child = children.item(i);
                Node node = child;
                if (node instanceof Text) {
                    void text;
                    Text cfr_ignored_0 = (Text)node;
                    Text cfr_ignored_1 = (Text)node;
                    String value = text.getData();
                    int oldIdx = value.indexOf(oldValue.toString());
                    if (oldIdx > -1) {
                        String replacement = value.substring(0, oldIdx) + newValue.toString() + value.substring(oldIdx + oldValue.toString().length());
                        ((Text)child).setData(replacement);
                        replacedChild = true;
                    }
                }
                ++i;
            }
        }
        if (!replacedChild) {
            while (element.getFirstChild() != null) {
                element.removeChild(element.getFirstChild());
            }
            Text text = this.node.getOwnerDocument().createTextNode(newValue.toString());
            element.appendChild(text);
        }
    }

    public List<Node> getLinkedWhitespaceNodes() {
        return this.linkedWhitespaceNodes;
    }

    public void setLinkedWhitespaceNodes(List<Node> linkedWhitespaceNodes) {
        this.linkedWhitespaceNodes = linkedWhitespaceNodes;
    }
}

