/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ClasspathUtils {
    public static final String copyright = "(c) Copyright IBM Corporation 2003.";
    private static ClasspathUtils instance_;
    private static String DOT_JAR;
    private static String JAR;
    private static String WEBINF_LIB;

    static {
        DOT_JAR = ".jar";
        JAR = "jar";
        WEBINF_LIB = "/WEB-INF/lib";
    }

    private ClasspathUtils() {
    }

    public static ClasspathUtils getInstance() {
        if (instance_ == null) {
            instance_ = new ClasspathUtils();
        }
        return instance_;
    }

    public String getClasspathString(IProject project) {
        StringBuffer classpath = new StringBuffer();
        String[] classpathEntries = this.getClasspath(project, false);
        Vector<String> classpathVector = new Vector<String>();
        int i = 0;
        while (i < classpathEntries.length) {
            if (!classpathVector.contains(classpathEntries[i])) {
                classpathVector.add(classpathEntries[i]);
                classpath.append(classpathEntries[i]);
                classpath.append(";");
            }
            ++i;
        }
        return classpath.toString();
    }

    private String[] getClasspath(IProject project, boolean isDependent) {
        IJavaProject javaProj;
        String[] moduleClasspath = new String[]{};
        ArrayList<String> projectClasspath = new ArrayList<String>();
        boolean needJavaClasspath = false;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        if (comp != null) {
            if (J2EEUtils.isEARComponent((IVirtualComponent)comp)) {
                moduleClasspath = this.getClasspathForEARProject(project, comp.getName());
                int j = 0;
                while (j < moduleClasspath.length) {
                    projectClasspath.add(moduleClasspath[j]);
                    ++j;
                }
            } else if (J2EEUtils.isWebComponent((IVirtualComponent)comp) || J2EEUtils.isJavaComponent((IVirtualComponent)comp)) {
                needJavaClasspath = true;
                IContainer outputContainer = null;
                IResource fragmentRoot = null;
                IPackageFragmentRoot[] pkgFragmentRoot = ResourceUtils.getJavaPackageFragmentRoots((IProject)project);
                ArrayList<String> webModuleClasspath = new ArrayList<String>();
                try {
                    int i = 0;
                    while (i < pkgFragmentRoot.length) {
                        fragmentRoot = pkgFragmentRoot[i].getCorrespondingResource();
                        if (fragmentRoot != null && fragmentRoot.getProject().equals((Object)project) && fragmentRoot.getType() != 1 && (outputContainer = J2EEProjectUtilities.getOutputContainer((IProject)project, (IPackageFragmentRoot)pkgFragmentRoot[i])) != null) {
                            webModuleClasspath.add(outputContainer.getLocation().toOSString());
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
                Iterator iter = webModuleClasspath.iterator();
                while (iter.hasNext()) {
                    projectClasspath.add((String)iter.next());
                }
            }
            if (!isDependent && J2EEUtils.isWebComponent((IVirtualComponent)comp)) {
                needJavaClasspath = true;
                moduleClasspath = this.getWEBINFLib(project);
                int j = 0;
                while (j < moduleClasspath.length) {
                    projectClasspath.add(moduleClasspath[j]);
                    ++j;
                }
            }
        } else {
            needJavaClasspath = true;
        }
        if (needJavaClasspath && (javaProj = JavaCore.create((IProject)project)) != null) {
            String[] javaClasspath = this.getClasspathForJavaProject(javaProj);
            int j = 0;
            while (j < javaClasspath.length) {
                projectClasspath.add(javaClasspath[j]);
                ++j;
            }
        }
        return projectClasspath.toArray(new String[projectClasspath.size()]);
    }

    private String[] getUtilityJarClasspath(IProject project) {
        String[] utilityJarString = new String[]{};
        String[] moduleClasspath = new String[]{};
        ArrayList<String> utilityJarsClasspath = new ArrayList<String>();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        if (comp != null) {
            String module = comp.getName();
            if (J2EEUtils.isEARComponent((IVirtualComponent)comp)) {
                moduleClasspath = this.getClasspathForEARProject(project, module);
                int j = 0;
                while (j < moduleClasspath.length) {
                    utilityJarsClasspath.add(moduleClasspath[j]);
                    ++j;
                }
                utilityJarString = utilityJarsClasspath.toArray(new String[utilityJarsClasspath.size()]);
            }
        }
        return utilityJarString;
    }

    private String[] getClasspathForEARProject(IProject project, String module) {
        IPath projectPath = project.getProject().getLocation().addTrailingSeparator().append(module).addTrailingSeparator();
        return this.getDirectoryJarFiles(projectPath);
    }

    private String[] getDirectoryJarFiles(IPath iPath) {
        File dir = iPath.toFile();
        Vector<String> jarsVector = new Vector<String>();
        if (dir.exists() && dir.isDirectory()) {
            String[] filenames = dir.list();
            int i = 0;
            while (i < filenames.length) {
                if (filenames[i].endsWith(DOT_JAR)) {
                    jarsVector.add(String.valueOf(this.path2String(iPath)) + filenames[i]);
                }
                ++i;
            }
        }
        Object[] jars = new String[jarsVector.size()];
        jarsVector.copyInto(jars);
        return jars;
    }

    private String[] getWEBINFLib(IProject project) {
        String[] webinfLibJars = new String[]{};
        ArrayList<String> anArrayList = new ArrayList<String>();
        try {
            IVirtualFolder webInfLib;
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null && (webInfLib = component.getRootFolder().getFolder((IPath)new Path(WEBINF_LIB))) != null) {
                IVirtualResource[] resources = webInfLib.members();
                IResource aResource = null;
                int i = 0;
                while (i < resources.length) {
                    aResource = resources[i].getUnderlyingResource();
                    if (JAR.equalsIgnoreCase(aResource.getFileExtension())) {
                        anArrayList.add(aResource.getLocation().toOSString());
                    }
                    ++i;
                }
                if (anArrayList.size() != 0) {
                    webinfLibJars = anArrayList.toArray(new String[anArrayList.size()]);
                }
            }
        }
        catch (CoreException coreException) {}
        return webinfLibJars;
    }

    private String[] getClasspathForJavaProject(IJavaProject javaProject) {
        ArrayList<String> projectClasspath = new ArrayList<String>();
        try {
            IClasspathEntry[] buildPath = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < buildPath.length) {
                String[] buildPathString = this.classpathEntry2String(buildPath[i], javaProject.getProject());
                int j = 0;
                while (j < buildPathString.length) {
                    projectClasspath.add(buildPathString[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        IProject project = javaProject.getProject();
        IProject[] referencingProjects = project.getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            String[] utilityJarsClasspath = this.getUtilityJarClasspath(referencingProjects[i]);
            int j = 0;
            while (j < utilityJarsClasspath.length) {
                projectClasspath.add(utilityJarsClasspath[j]);
                ++j;
            }
            ++i;
        }
        return projectClasspath.toArray(new String[projectClasspath.size()]);
    }

    private String[] classpathEntry2String(IClasspathEntry entry, IProject project) {
        switch (entry.getEntryKind()) {
            case 1: {
                return new String[]{this.path2String(entry.getPath())};
            }
            case 2: {
                return this.getClasspath(ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment()), true);
            }
            case 3: {
                IPath path = entry.getPath();
                if (path.segment(0).equals(project.getName())) {
                    path = path.removeFirstSegments(1);
                }
                return new String[]{this.path2String(project.getLocation().addTrailingSeparator().append(path))};
            }
            case 4: {
                return this.classpathEntry2String(JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry), project);
            }
        }
        return new String[]{this.path2String(entry.getPath())};
    }

    private String path2String(IPath path) {
        return path.toOSString();
    }
}

